/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.errors;

import bluej.stride.framedjava.ast.StringSlotFragment;
import bluej.stride.framedjava.errors.Correction;
import bluej.stride.framedjava.errors.DirectSlotError;
import bluej.stride.framedjava.errors.FixSuggestion;
import bluej.stride.framedjava.slots.ExpressionSlot;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public class UndeclaredMethodError
extends DirectSlotError {
    private final String methodName;
    private final int startPosInSlot;
    private final int endPosInSlot;
    private List<? extends FixSuggestion> corrections;

    public UndeclaredMethodError(StringSlotFragment slotFragment, String methodName, int startPosInSlot, int endPosInSlot, ExpressionSlot slot, List<String> possibleCorrections) {
        super(slotFragment);
        this.methodName = methodName;
        this.startPosInSlot = startPosInSlot;
        this.endPosInSlot = endPosInSlot;
        this.corrections = Correction.winnowAndCreateCorrections(methodName, possibleCorrections.stream().map(Correction.SimpleCorrectionInfo::new), s -> slot.replace(startPosInSlot, endPosInSlot, this.isJavaPos(), (String)s));
    }

    @Override
    public int getStartPosition() {
        return this.startPosInSlot;
    }

    @Override
    public int getEndPosition() {
        return this.endPosInSlot;
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getMessage() {
        return "Undeclared method: " + this.methodName;
    }

    @Override
    public List<? extends FixSuggestion> getFixSuggestions() {
        return this.corrections;
    }

    @Override
    public boolean isJavaPos() {
        return false;
    }
}

