/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.errors;

import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.FixSuggestion;
import java.util.Collections;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public class JavaCompileError
extends CodeError {
    private final int startPos;
    private final int endPos;
    private final String message;
    private final int identifier;

    @OnThread(value=Tag.Any)
    public JavaCompileError(JavaFragment slotElement, int startPos, int endPos, String message, int identifier) {
        super(slotElement);
        this.startPos = startPos;
        this.endPos = endPos;
        if (endPos < startPos) {
            throw new IllegalArgumentException("JavaCompileError ends before it begins");
        }
        this.message = message;
        this.identifier = identifier;
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getMessage() {
        return this.message;
    }

    public List<FixSuggestion> getFixSuggestions() {
        return Collections.emptyList();
    }

    public String toString() {
        return "JavaCompileError [startPos=" + this.startPos + ", endPos=" + this.endPos + ", message=" + this.message + "]";
    }

    @Override
    public int getStartPosition() {
        return this.startPos;
    }

    @Override
    public int getEndPosition() {
        return this.endPos;
    }

    @Override
    public boolean isJavaPos() {
        return true;
    }

    @Override
    @OnThread(value=Tag.Any)
    public int getIdentifier() {
        return this.identifier;
    }
}

