/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.errors;

import bluej.editor.EditorWatcher;
import bluej.editor.stride.CodeOverlayPane;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.FixSuggestion;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.DoubleExpression;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ErrorAndFixDisplay {
    private static final Duration SHOW_DELAY = Duration.millis((double)400.0);
    private static final double SPACING = 5.0;
    private final InteractionManager editor;
    private final CodeError error;
    private final ErrorFixListener slot;
    private final VBox vbox = new VBox();
    private final List<FixDisplay> fixes = new ArrayList<FixDisplay>();
    private int highlighted = -1;
    private FXPlatformRunnable cancelShow;
    private boolean showing = false;

    public boolean isShowing() {
        return this.showing;
    }

    public ErrorAndFixDisplay(InteractionManager editor, CodeError err, ErrorFixListener slot) {
        this(editor, "", err, slot);
    }

    public ErrorAndFixDisplay(InteractionManager editor, String prefix, CodeError err, ErrorFixListener slot) {
        this.editor = editor;
        this.error = err;
        this.slot = slot;
        this.vbox.setOnMousePressed(Event::consume);
        Label errorLabel = new Label(prefix + err.getMessage());
        JavaFXUtil.addStyleClass((Styleable)errorLabel, "error-label");
        this.vbox.getChildren().add((Object)errorLabel);
        for (FixSuggestion fixSuggestion : err.getFixSuggestions()) {
            FixDisplay l = new FixDisplay("  Fix: " + fixSuggestion.getDescription());
            l.onMouseClickedProperty().set(e -> {
                this.recordExecute(this.fixes.indexOf((Object)l));
                fix.execute();
                this.hide();
                slot.fixedError(this.error);
                e.consume();
            });
            l.onMouseEnteredProperty().set(e -> this.setHighlighted(this.fixes.indexOf((Object)l)));
            this.vbox.getChildren().add((Object)l);
            this.fixes.add(l);
        }
        JavaFXUtil.addStyleClass((Styleable)this.vbox, "error-fix-display");
        this.vbox.setMinWidth(250.0);
        CodeOverlayPane.setDropShadow((Node)this.vbox);
    }

    public CodeError getError() {
        return this.error;
    }

    @OnThread(value=Tag.FXPlatform)
    public void showAbove(Region n, Duration delay) {
        if (this.cancelShow != null) {
            this.cancelShow.run();
            this.cancelShow = null;
        }
        this.cancelShow = JavaFXUtil.runAfter(delay, () -> {
            this.editor.getCodeOverlayPane().addOverlay((Node)this.vbox, (Node)n, null, (DoubleExpression)this.vbox.heightProperty().negate().subtract(5.0), CodeOverlayPane.WidthLimit.LIMIT_WIDTH_AND_SLIDE_LEFT);
            this.vbox.toBack();
            this.error.focusedProperty().set(true);
            this.showing = true;
            this.recordShow();
        });
    }

    private void recordShow() {
        EditorWatcher watcher = this.editor.getFrameEditor().getWatcher();
        List<String> fixDisplayText = Utility.mapList(this.fixes, FixDisplay::getDisplayText);
        SwingUtilities.invokeLater(() -> watcher.recordShowErrorMessage(this.error.getIdentifier(), fixDisplayText));
    }

    @OnThread(value=Tag.FXPlatform)
    public void showAbove(Region n) {
        this.showAbove(n, SHOW_DELAY);
    }

    @OnThread(value=Tag.FXPlatform)
    public void showBelow(Region n) {
        this.showBelow(n, SHOW_DELAY);
    }

    @OnThread(value=Tag.FXPlatform)
    public void showBelow(Region n, Duration delay) {
        if (this.cancelShow != null) {
            this.cancelShow.run();
            this.cancelShow = null;
        }
        this.cancelShow = JavaFXUtil.runAfter(delay, () -> {
            this.editor.getCodeOverlayPane().addOverlay((Node)this.vbox, (Node)n, null, (DoubleExpression)n.heightProperty().add(5.0), CodeOverlayPane.WidthLimit.LIMIT_WIDTH_AND_SLIDE_LEFT);
            this.vbox.toBack();
            this.error.focusedProperty().set(true);
            this.showing = true;
            this.recordShow();
        });
    }

    @OnThread(value=Tag.FXPlatform)
    public void hide() {
        if (this.cancelShow != null) {
            this.cancelShow.run();
            this.cancelShow = null;
        }
        this.editor.getCodeOverlayPane().removeOverlay((Node)this.vbox);
        this.error.focusedProperty().set(false);
        this.showing = false;
    }

    public boolean hasFixes() {
        return !this.fixes.isEmpty();
    }

    public void down() {
        this.setHighlighted(Math.min(this.fixes.size() - 1, this.highlighted + 1));
    }

    public void up() {
        this.setHighlighted(Math.max(0, this.highlighted - 1));
    }

    private void setHighlighted(int newHighlight) {
        if (this.highlighted != newHighlight) {
            if (this.highlighted != -1) {
                this.fixes.get(this.highlighted).setHighlight(false);
            }
            this.highlighted = newHighlight;
            if (this.highlighted != -1) {
                this.fixes.get(this.highlighted).setHighlight(true);
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void executeSelected() {
        if (this.highlighted != -1) {
            this.recordExecute(this.highlighted);
            this.error.getFixSuggestions().get(this.highlighted).execute();
            this.hide();
            this.slot.fixedError(this.error);
        }
    }

    private void recordExecute(int fixIndex) {
        EditorWatcher watcher = this.editor.getFrameEditor().getWatcher();
        SwingUtilities.invokeLater(() -> watcher.recordFix(this.error.getIdentifier(), fixIndex));
    }

    private static class FixDisplay
    extends HBox {
        private final Label enterHint = new Label("\u21b5");
        private final String displayText;

        public FixDisplay(String display) {
            this.displayText = display;
            this.enterHint.setVisible(false);
            Label l = new Label(display);
            this.getChildren().addAll((Object[])new Node[]{l, this.enterHint});
            HBox.setHgrow((Node)l, (Priority)Priority.ALWAYS);
            l.setMaxWidth(9999.0);
        }

        private void setHighlight(boolean highlight) {
            if (highlight) {
                JavaFXUtil.addStyleClass((Styleable)this, "fix-highlight");
            } else {
                JavaFXUtil.removeStyleClass((Styleable)this, "fix-highlight");
            }
            this.enterHint.setVisible(highlight);
        }

        @OnThread(value=Tag.Any)
        public String getDisplayText() {
            return this.displayText;
        }
    }

    public static interface ErrorFixListener {
        @OnThread(value=Tag.FXPlatform)
        public void fixedError(CodeError var1);
    }
}

