/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.errors;

import bluej.stride.framedjava.errors.FixSuggestion;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformConsumer;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import threadchecker.OnThread;
import threadchecker.Tag;

class Correction
extends FixSuggestion {
    private final String correction;
    private final String display;
    private final FXPlatformConsumer<String> replacer;
    private static final int MAX_EDIT_DISTANCE = 2;

    @OnThread(value=Tag.Any)
    private Correction(String correction, FXPlatformConsumer<String> replacer, String display) {
        this.correction = correction;
        this.display = display;
        this.replacer = replacer;
    }

    @Override
    public String getDescription() {
        return "Correct to: " + this.display;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void execute() {
        this.replacer.accept(this.correction);
    }

    @OnThread(value=Tag.Any)
    public static List<Correction> winnowAndCreateCorrections(String cur, Stream<CorrectionInfo> possibleCorrections, FXPlatformConsumer<String> replacer) {
        return possibleCorrections.map(n -> new StringAndDist((CorrectionInfo)n, Utility.editDistance(cur.toLowerCase(), n.getCorrection().toLowerCase()))).filter(sd -> sd.distance <= 2).sorted((a, b) -> Integer.compare(a.distance, b.distance)).limit(3L).map(sd -> new Correction(sd.value.getCorrection(), replacer, sd.value.getDisplay())).collect(Collectors.toList());
    }

    @OnThread(value=Tag.Any)
    public static class SimpleCorrectionInfo
    implements CorrectionInfo {
        private String correction;

        public SimpleCorrectionInfo(String correction) {
            this.correction = correction;
        }

        @Override
        public String getCorrection() {
            return this.correction;
        }

        @Override
        public String getDisplay() {
            return this.correction;
        }
    }

    @OnThread(value=Tag.Any)
    public static interface CorrectionInfo {
        public String getCorrection();

        public String getDisplay();
    }

    @OnThread(value=Tag.Any)
    private static class StringAndDist {
        public final CorrectionInfo value;
        public final int distance;

        public StringAndDist(CorrectionInfo value, int distance) {
            this.value = value;
            this.distance = distance;
        }
    }
}

