/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.debugger.gentype.ConstructorReflective;
import bluej.parser.CodeSuggestions;
import bluej.parser.entity.EntityResolver;
import bluej.stride.framedjava.ast.FrameFragment;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ContainerCodeElement;
import bluej.stride.framedjava.elements.ImportElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.errors.DirectSlotError;
import bluej.stride.framedjava.errors.SyntaxCodeError;
import bluej.stride.framedjava.frames.TopLevelFrame;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import threadchecker.OnThread;
import threadchecker.Tag;

public interface TopLevelCodeElement {
    public static ArrayList<TypeSlotFragment> xmlToTypeList(Element el, String container, String itemName, String itemAttribute) {
        ArrayList<TypeSlotFragment> members = new ArrayList<TypeSlotFragment>();
        Element collectionChildElement = el.getFirstChildElement(container);
        if (collectionChildElement != null) {
            Elements children = collectionChildElement.getChildElements();
            for (int i = 0; i < children.size(); ++i) {
                Element child = children.get(i);
                if (child.getLocalName().equals(itemName)) {
                    members.add(new TypeSlotFragment(child.getAttributeValue(itemAttribute), child.getAttributeValue(itemAttribute + "-java")));
                    continue;
                }
                Debug.reportError("Wrong element format: expected '" + itemName + "', found '" + child.getLocalName() + "'.");
            }
        }
        return members;
    }

    public static Element typeListToXML(List<TypeSlotFragment> items, String container, String itemName, String itemAttribute) {
        Element el = new Element(container);
        for (TypeSlotFragment s : items) {
            LocatableElement child = new LocatableElement(null, itemName);
            child.addAttributeStructured(itemAttribute, s);
            el.appendChild((Node)child);
        }
        return el;
    }

    public static List<CodeElement> fillChildrenElements(ContainerCodeElement parent, Element el, String string) {
        ArrayList<CodeElement> members = new ArrayList<CodeElement>();
        Element collectionChildElement = el.getFirstChildElement(string);
        if (collectionChildElement != null) {
            Elements children = collectionChildElement.getChildElements();
            for (int i = 0; i < children.size(); ++i) {
                CodeElement member = Loader.loadElement(children.get(i));
                members.add(member);
                member.setParent(parent);
            }
        }
        return members;
    }

    public static Attribute getStrideVersionAttribute() {
        return new Attribute("strideversion", "1");
    }

    @OnThread(value=Tag.Swing)
    public CodeSuggestions getCodeSuggestions(JavaFragment.PosInSourceDoc var1, ExpressionSlot<?> var2);

    @OnThread(value=Tag.FX)
    public TopLevelFrame<? extends TopLevelCodeElement> createTopLevelFrame(InteractionManager var1);

    public List<ImportElement> getImports();

    public String getName();

    public String getStylePrefix();

    @OnThread(value=Tag.Swing)
    public EntityResolver getResolver();

    @OnThread(value=Tag.FX)
    public InteractionManager getEditor();

    public LocatableElement toXML();

    public TopLevelFrame getFrame();

    public Stream<CodeElement> streamContained();

    public Stream<SyntaxCodeError> findEarlyErrors();

    public Stream<Future<List<DirectSlotError>>> findDirectLateErrors(InteractionManager var1, LocatableElement.LocationMap var2);

    public JavaSource toJavaSource();

    default public JavaSource toJavaSource(boolean warning) {
        JavaSource java = this.toJavaSource();
        if (warning) {
            java = new JavaSource(java);
            java.prependLine(Arrays.asList(new FrameFragment(null, (CodeElement)((Object)this), "// WARNING: This file is auto-generated and any changes to it will be overwritten")), null);
        }
        return java;
    }

    public void updateSourcePositions();

    @OnThread(value=Tag.Swing)
    public List<ConstructorReflective> getSuperConstructors();

    @OnThread(value=Tag.FX)
    public List<AssistContentThreadSafe> getThisConstructors();
}

