/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaContainerDebugHandler;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ContainerCodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.SwitchFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import nu.xom.Element;
import nu.xom.Node;

public class SwitchElement
extends ContainerCodeElement
implements JavaSingleLineDebugHandler {
    public static final String ELEMENT = "switch";
    private final FilledExpressionSlotFragment expression;
    private final List<CodeElement> casesContents;
    private final List<CodeElement> defaultContents;
    private SwitchFrame frame;

    public SwitchElement(SwitchFrame frame, FilledExpressionSlotFragment expression, List<? extends CodeElement> casesContents, List<CodeElement> defaultContents, boolean enabled) {
        this.frame = frame;
        this.expression = expression;
        this.casesContents = new ArrayList<CodeElement>(casesContents);
        this.casesContents.forEach(c -> c.setParent(this));
        this.defaultContents = defaultContents;
        if (this.defaultContents != null) {
            this.defaultContents.forEach(c -> c.setParent(this));
        }
        this.enable = enabled;
    }

    @Override
    public List<CodeElement> childrenUpTo(CodeElement c) {
        if (this.casesContents.contains(c)) {
            return this.casesContents.subList(0, this.casesContents.indexOf(c));
        }
        if (this.defaultContents != null && this.defaultContents.contains(c)) {
            return this.defaultContents.subList(0, this.defaultContents.indexOf(c));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public JavaSource toJavaSource() {
        List<JavaSource> contentsJavaSource = CodeElement.toJavaCodes(this.casesContents);
        if (this.defaultContents != null) {
            JavaContainerDebugHandler defaultHandler = debug -> this.frame.getDefaultDebug().showDebugAtEnd(debug);
            contentsJavaSource.add(JavaSource.createCompoundStatement(this.frame, this, this, defaultHandler, Arrays.asList(this.f(this.frame, "default :")), CodeElement.toJavaCodes(this.defaultContents)));
        }
        JavaContainerDebugHandler casesHandler = debug -> this.frame.getCasesDebug().showDebugAtEnd(debug);
        return JavaSource.createCompoundStatement(this.frame, this, this, casesHandler, Arrays.asList(this.f(this.frame, "switch ("), this.expression, this.f(this.frame, ")")), contentsJavaSource);
    }

    @Override
    public LocatableElement toXML() {
        LocatableElement switchEl = new LocatableElement(this, ELEMENT);
        switchEl.addAttributeStructured("expression", this.expression);
        this.addEnableAttribute(switchEl);
        Element casesEl = new Element("cases");
        this.casesContents.forEach(c -> casesEl.appendChild((Node)c.toXML()));
        switchEl.appendChild((Node)casesEl);
        if (this.defaultContents != null) {
            Element defaultEl = new Element("default");
            this.defaultContents.forEach(c -> defaultEl.appendChild((Node)c.toXML()));
            switchEl.appendChild((Node)defaultEl);
        }
        return switchEl;
    }

    public SwitchElement(Element el) {
        this.expression = new FilledExpressionSlotFragment(el.getAttributeValue("expression"), el.getAttributeValue("expression-java"));
        this.casesContents = new ArrayList<CodeElement>();
        Element casesEl = el.getChildElements("cases").get(0);
        for (int i = 0; i < casesEl.getChildElements().size(); ++i) {
            Element child = casesEl.getChildElements().get(i);
            CodeElement member = Loader.loadElement(child);
            this.casesContents.add(member);
            member.setParent(this);
        }
        if (el.getChildElements("default").size() == 1) {
            this.defaultContents = new ArrayList<CodeElement>();
            Element defaultEl = el.getChildElements("default").get(0);
            for (int i = 0; i < defaultEl.getChildElements().size(); ++i) {
                Element child = defaultEl.getChildElements().get(i);
                CodeElement member = Loader.loadElement(child);
                this.defaultContents.add(member);
                member.setParent(this);
            }
        } else if (el.getChildElements("default").size() == 0) {
            this.defaultContents = null;
        } else {
            throw new IllegalArgumentException();
        }
        this.enable = Boolean.valueOf(el.getAttributeValue("enable"));
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new SwitchFrame(editor, this.expression, this.isEnable());
        this.casesContents.forEach(c -> this.frame.getCasesCanvas().insertBlockAfter(c.createFrame(editor), null));
        if (this.defaultContents != null) {
            this.frame.addDefault();
            this.defaultContents.forEach(c -> this.frame.getDefaultCanvas().insertBlockAfter(c.createFrame(editor), null));
        }
        return this.frame;
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return this.frame.showDebugBefore(debug);
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    public Stream<CodeElement> streamContained() {
        return Utility.concat(SwitchElement.streamContained(this.casesContents), SwitchElement.streamContained(this.defaultContents));
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.of(this.expression);
    }
}

