/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.FrameFragment;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.elements.ContainerCodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.errors.DirectSlotError;
import bluej.stride.framedjava.errors.SyntaxCodeError;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nu.xom.Attribute;
import nu.xom.Element;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class CodeElement {
    protected boolean enable = true;
    private ContainerCodeElement parent;

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    protected void addEnableAttribute(Element element) {
        element.addAttribute(new Attribute("enable", String.valueOf(this.enable)));
    }

    public final Stream<SyntaxCodeError> findEarlyErrors(LocatableElement.LocationMap rootPathMap) {
        if (!this.isEnable()) {
            return Stream.empty();
        }
        return this.toJavaSource().getAllFragments().flatMap(fragment -> fragment.findEarlyErrors().peek(e -> e.recordPath(rootPathMap.locationFor((JavaFragment)fragment))));
    }

    @OnThread(value=Tag.FXPlatform)
    public final Stream<Future<List<DirectSlotError>>> findDirectLateErrors(InteractionManager editor, LocatableElement.LocationMap rootPathMap) {
        if (!this.isEnable()) {
            return Stream.empty();
        }
        return this.getDirectSlotFragments().map(g -> g.findLateErrors(editor, this, rootPathMap)).filter(x -> x != null);
    }

    protected abstract Stream<SlotFragment> getDirectSlotFragments();

    @OnThread(value=Tag.Any)
    public abstract JavaSource toJavaSource();

    public abstract LocatableElement toXML();

    @OnThread(value=Tag.FX)
    public abstract Frame createFrame(InteractionManager var1);

    public void setParent(ContainerCodeElement e) {
        this.parent = e;
    }

    public ContainerCodeElement getParent() {
        return this.parent;
    }

    public List<LocalParamInfo> getDeclaredVariablesAfter() {
        return Collections.emptyList();
    }

    public static List<JavaSource> toJavaCodes(List<? extends CodeElement> contents) {
        return contents.stream().filter(c -> c.isEnable()).map(c -> c.toJavaSource()).collect(Collectors.toList());
    }

    protected FrameFragment f(Frame frame, String s) {
        return new FrameFragment(frame, this, s);
    }

    protected JavaFragment space() {
        return new FrameFragment(null, this, " ");
    }

    public static void preserveWhitespace(Element el) {
        el.addAttribute(new Attribute("xml:space", "http://www.w3.org/XML/1998/namespace", "preserve"));
    }

    @OnThread(value=Tag.FX)
    public final void showException() {
        this.show(Frame.ShowReason.EXCEPTION);
    }

    @OnThread(value=Tag.FX)
    public abstract void show(Frame.ShowReason var1);

    public Stream<CodeElement> streamContained() {
        return Stream.empty();
    }

    public static class LocalParamInfo {
        private final String type;
        private final String name;
        private final boolean param;
        private final CodeElement declarer;

        public LocalParamInfo(String type, String name, boolean param, CodeElement declarer) {
            this.type = type;
            this.name = name;
            this.param = param;
            this.declarer = declarer;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public boolean isParam() {
            return this.param;
        }

        public CodeElement getDeclarer() {
            return this.declarer;
        }
    }
}

