/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.convert;

import bluej.parser.lexer.JavaLexer;
import bluej.parser.lexer.LocatableToken;
import bluej.stride.framedjava.ast.CallExpressionSlotFragment;
import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.OptionalExpressionSlotFragment;
import bluej.stride.framedjava.ast.SuperThisParamsExpressionFragment;
import bluej.stride.framedjava.convert.ConversionWarning;
import bluej.stride.framedjava.elements.AssignElement;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.elements.CodeElement;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class Expression {
    private final String stride;
    private final String java;
    private final List<Integer> incDec;
    private final Consumer<ConversionWarning> addWarning;

    Expression(String src, List<Integer> incDec, Consumer<ConversionWarning> addWarning) {
        this.stride = Expression.uniformSpacing(src, true);
        this.java = Expression.uniformSpacing(src, false);
        this.incDec = new ArrayList<Integer>(incDec);
        this.addWarning = addWarning;
    }

    Expression(List<Expression> expressions, String join, Consumer<ConversionWarning> addWarning) {
        this.stride = expressions.stream().map(e -> e.stride).collect(Collectors.joining(join));
        this.java = expressions.stream().map(e -> e.java).collect(Collectors.joining(join));
        this.incDec = new ArrayList<Integer>();
        expressions.forEach(e -> this.incDec.addAll(e.incDec));
        this.addWarning = addWarning;
    }

    static String uniformSpacing(String src, boolean replaceInstanceof) {
        JavaLexer lexer = new JavaLexer(new StringReader(src));
        StringBuilder r = new StringBuilder();
        LocatableToken token;
        while ((token = lexer.nextToken()).getType() != 1) {
            if (r.length() != 0) {
                r.append(" ");
            }
            if (replaceInstanceof && token.getType() == 145) {
                r.append("<:");
                continue;
            }
            r.append(token.getText());
        }
        return r.toString();
    }

    FilledExpressionSlotFragment toFilled() {
        this.warnIncDec();
        return new FilledExpressionSlotFragment(this.stride, this.java);
    }

    OptionalExpressionSlotFragment toOptional() {
        this.warnIncDec();
        return new OptionalExpressionSlotFragment(this.stride, this.java);
    }

    SuperThisParamsExpressionFragment toSuperThis() {
        this.warnIncDec();
        return new SuperThisParamsExpressionFragment(this.stride, this.java);
    }

    public CodeElement toStatement() {
        boolean startInc = this.java.startsWith("++ ");
        boolean startDec = this.java.startsWith("-- ");
        boolean endInc = this.java.endsWith(" ++");
        boolean endDec = this.java.endsWith(" --");
        if (startInc || startDec) {
            this.incDec.remove((Object)(startInc ? 151 : 152));
            this.warnIncDec();
            return new AssignElement(null, new FilledExpressionSlotFragment(this.stride.substring(3), this.java.substring(3)), new FilledExpressionSlotFragment(this.stride.substring(3) + " " + this.stride.substring(0, 1) + " 1", this.java.substring(3) + " " + this.java.substring(0, 1) + " 1"), true);
        }
        if (endInc || endDec) {
            this.incDec.remove((Object)(endInc ? 151 : 152));
            this.warnIncDec();
            String choppedStride = this.stride.substring(0, this.stride.length() - 3);
            String choppedJava = this.java.substring(0, this.java.length() - 3);
            return new AssignElement(null, new FilledExpressionSlotFragment(choppedStride, choppedJava), new FilledExpressionSlotFragment(choppedStride + " " + this.stride.substring(this.stride.length() - 1, this.stride.length()) + " 1", choppedJava + " " + this.java.substring(this.java.length() - 1, this.java.length()) + " 1"), true);
        }
        this.warnIncDec();
        return new CallElement(null, new CallExpressionSlotFragment(this.stride, this.java), true);
    }

    private void warnIncDec() {
        if (!this.incDec.isEmpty()) {
            this.addWarning.accept(new ConversionWarning.UnsupportedFeature("++/-- in expression"));
        }
    }

    public String toString() {
        return this.java;
    }
}

