/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.ErrorShower;
import bluej.stride.slots.EditableSlot;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class StringSlotFragment
extends SlotFragment {
    protected final String content;

    public StringSlotFragment(String content) {
        this.content = content;
        if (content == null) {
            throw new IllegalArgumentException("SlotElement content cannot be null");
        }
        if (content.contains("\n")) {
            throw new IllegalStateException("SlotElement content contains newline");
        }
    }

    public abstract EditableSlot getSlot();

    @Override
    public ErrorShower getErrorShower() {
        return this.getSlot();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public final void addError(CodeError error) {
        if (this.getSlot() != null) {
            this.getSlot().addError(error);
        }
    }

    @Override
    protected final JavaFragment getCompileErrorRedirect() {
        return null;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }
}

