/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.stride.framedjava.ast.Parser;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.ErrorShower;
import bluej.stride.framedjava.errors.JavaCompileError;
import bluej.stride.framedjava.errors.SyntaxCodeError;
import bluej.stride.framedjava.slots.ExpressionSlot;
import java.util.stream.Stream;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class JavaFragment {
    private int lineNumber;
    private int columnNumber;
    private int len;

    protected abstract String getJavaCode(Destination var1, ExpressionSlot<?> var2, Parser.DummyNameGenerator var3);

    @OnThread(value=Tag.FX)
    public abstract ErrorShower getErrorShower();

    @OnThread(value=Tag.FX)
    public final void recordDiskPosition(int lineNumber, int columnNumber, int len) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.len = len;
    }

    public ErrorRelation checkCompileError(int startLine, int startColumn, int endLine, int endColumn) {
        if (startLine > this.lineNumber) {
            return ErrorRelation.AFTER_FRAGMENT;
        }
        if (endLine < this.lineNumber) {
            return ErrorRelation.BEFORE_FRAGMENT;
        }
        if (startLine == this.lineNumber) {
            if (startColumn > this.columnNumber + this.len) {
                return ErrorRelation.AFTER_FRAGMENT;
            }
            if (endLine > this.lineNumber) {
                return ErrorRelation.OVERLAPS_FRAGMENT;
            }
            if (endColumn < this.columnNumber) {
                return ErrorRelation.BEFORE_FRAGMENT;
            }
        } else if (endLine == this.lineNumber && endColumn < this.columnNumber + this.len) {
            return ErrorRelation.BEFORE_FRAGMENT;
        }
        return ErrorRelation.OVERLAPS_FRAGMENT;
    }

    @OnThread(value=Tag.FX)
    public final void showCompileError(int startLine, int startColumn, int endLine, int endColumn, String message, int identifier) {
        JavaFragment redirect = this.getCompileErrorRedirect();
        if (redirect != null) {
            new JavaCompileError(redirect, 0, redirect.len, message, identifier);
        } else {
            this.showCompileErrorDirect(startLine, startColumn, endLine, endColumn, message, identifier);
        }
    }

    @OnThread(value=Tag.FX)
    protected abstract JavaFragment getCompileErrorRedirect();

    private void showCompileErrorDirect(int startLine, int startColumn, int endLine, int endColumn, String message, int identifier) {
        int startPos = this.getErrorStartPos(startLine, startColumn);
        int endPos = this.getErrorEndPos(endLine, endColumn);
        new JavaCompileError(this, startPos, endPos, message, identifier);
    }

    public int getErrorEndPos(int endLine, int endColumn) {
        int endPos = endLine > this.lineNumber ? this.len : (endLine == this.lineNumber ? Math.max(0, Math.min(this.len, endColumn - this.columnNumber)) : this.len);
        return endPos;
    }

    public int getErrorStartPos(int startLine, int startColumn) {
        int startPos = startLine < this.lineNumber ? 0 : (startLine == this.lineNumber ? Math.min(Math.max(0, startColumn - this.columnNumber), this.len) : 0);
        return startPos;
    }

    public abstract Stream<SyntaxCodeError> findEarlyErrors();

    @OnThread(value=Tag.FXPlatform)
    public abstract void addError(CodeError var1);

    public PosInSourceDoc getPosInSourceDoc(int offset) {
        return new PosInSourceDoc(offset);
    }

    public PosInSourceDoc getPosInSourceDoc() {
        return this.getPosInSourceDoc(0);
    }

    public class PosInSourceDoc {
        public final int offset;

        public PosInSourceDoc(int offset) {
            this.offset = offset;
        }

        public JavaFragment getFragment() {
            return JavaFragment.this;
        }
    }

    public static enum ErrorRelation {
        BEFORE_FRAGMENT,
        OVERLAPS_FRAGMENT,
        AFTER_FRAGMENT,
        CANNOT_SHOW;

    }

    public static enum Destination {
        JAVA_FILE_TO_COMPILE,
        SOURCE_DOC_TO_ANALYSE,
        TEMPORARY;


        public boolean substitute() {
            return this == SOURCE_DOC_TO_ANALYSE;
        }
    }
}

