/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast;

import bluej.parser.JavaParser;
import bluej.parser.lexer.LocatableToken;
import bluej.stride.framedjava.ast.ASTUtility;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.Parser;
import bluej.stride.framedjava.ast.StructuredSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.framedjava.errors.DirectSlotError;
import bluej.stride.framedjava.errors.SyntaxCodeError;
import bluej.stride.framedjava.errors.UndeclaredVariableInExpressionError;
import bluej.stride.framedjava.errors.UndeclaredVariableLvalueError;
import bluej.stride.framedjava.errors.UnknownTypeError;
import bluej.stride.framedjava.errors.UnneededSemiColonError;
import bluej.stride.framedjava.frames.AssignFrame;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformConsumer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;

public abstract class ExpressionSlotFragment
extends StructuredSlotFragment {
    private ExpressionSlot slot;
    private final List<LocatableToken> plains = new ArrayList<LocatableToken>();
    private List<LocatableToken> curCompound = null;
    private final List<List<LocatableToken>> compounds = new ArrayList<List<LocatableToken>>();
    private final List<List<LocatableToken>> types = new ArrayList<List<LocatableToken>>();
    private Map<String, CodeElement> vars;
    private AssignFrame assignmentLHSParent;

    public ExpressionSlotFragment(String content, String javaCode, ExpressionSlot slot) {
        super(content, javaCode);
        this.slot = slot;
        Parser.parseAsExpression(new JavaParser(new StringReader(this.wrapForParse(this.getJavaCode())), false){

            @Override
            protected void gotIdentifier(LocatableToken token) {
                ExpressionSlotFragment.this.plains.add(ExpressionSlotFragment.this.unwrapForParse(token));
            }

            @Override
            protected void gotIdentifierEOF(LocatableToken token) {
                ExpressionSlotFragment.this.plains.add(ExpressionSlotFragment.this.unwrapForParse(token));
            }

            @Override
            protected void gotArrayTypeIdentifier(LocatableToken token) {
            }

            @Override
            protected void gotParentIdentifier(LocatableToken token) {
            }

            @Override
            protected void gotCompoundIdent(LocatableToken token) {
                if (ExpressionSlotFragment.this.curCompound != null) {
                    throw new IllegalStateException();
                }
                ExpressionSlotFragment.this.curCompound = new ArrayList();
                ExpressionSlotFragment.this.curCompound.add(token);
            }

            @Override
            protected void gotCompoundComponent(LocatableToken token) {
                if (ExpressionSlotFragment.this.curCompound == null || ExpressionSlotFragment.this.curCompound.isEmpty()) {
                    throw new IllegalStateException();
                }
                ExpressionSlotFragment.this.curCompound.add(token);
            }

            @Override
            protected void gotMemberAccess(LocatableToken token) {
            }

            @Override
            protected void completeCompoundValue(LocatableToken token) {
                ExpressionSlotFragment.this.compounds.add(this.finishCompound(token));
            }

            private List<LocatableToken> finishCompound(LocatableToken token) {
                if (ExpressionSlotFragment.this.curCompound == null || ExpressionSlotFragment.this.curCompound.isEmpty()) {
                    throw new IllegalStateException();
                }
                ExpressionSlotFragment.this.curCompound.add(token);
                List<LocatableToken> r = Utility.mapList(ExpressionSlotFragment.this.curCompound, ExpressionSlotFragment.this::unwrapForParse);
                ExpressionSlotFragment.this.curCompound = null;
                return r;
            }

            @Override
            protected void completeCompoundClass(LocatableToken token) {
                ExpressionSlotFragment.this.types.add(this.finishCompound(token));
            }

            @Override
            protected void gotTypeSpec(List<LocatableToken> tokens) {
                ExpressionSlotFragment.this.types.add(Utility.mapList(tokens, ExpressionSlotFragment.this::unwrapForParse));
            }
        });
    }

    public ExpressionSlotFragment(String content, String javaCode) {
        this(content, javaCode, null);
    }

    public ExpressionSlotFragment(ExpressionSlotFragment f) {
        this(f.content, f.getJavaCode());
    }

    @Override
    public String getJavaCode(JavaFragment.Destination dest, ExpressionSlot<?> completing, Parser.DummyNameGenerator dummyNameGenerator) {
        if (!dest.substitute() || this.slot == completing || this.getJavaCode() != null && Parser.parseableAsExpression(this.wrapForParse(this.getJavaCode()))) {
            return this.getJavaCode();
        }
        return "true";
    }

    @Override
    public ExpressionSlot getSlot() {
        return this.slot;
    }

    public void registerSlot(ExpressionSlot slot) {
        if (this.slot == null) {
            this.slot = slot;
        }
    }

    protected abstract boolean isRequired();

    protected String wrapForParse(String orig) {
        return orig;
    }

    protected LocatableToken unwrapForParse(LocatableToken token) {
        return token;
    }

    @Override
    public Stream<SyntaxCodeError> findEarlyErrors() {
        if (this.content != null && this.content.endsWith(";")) {
            return Stream.of(new UnneededSemiColonError(this, () -> this.getSlot().setText(this.content.substring(0, this.content.length() - 1))));
        }
        if (this.content != null && this.content.isEmpty() && this.isRequired()) {
            return Stream.of(new SyntaxCodeError(this, "Expression cannot be empty"));
        }
        if (this.content == null || !Parser.parseableAsExpression(this.wrapForParse(this.getJavaCode()))) {
            return Stream.of(new SyntaxCodeError(this, "Invalid expression"));
        }
        return Stream.empty();
    }

    @Override
    public Future<List<DirectSlotError>> findLateErrors(InteractionManager editor, CodeElement parent, LocatableElement.LocationMap rootPathMap) {
        CompletableFuture<List<DirectSlotError>> f = new CompletableFuture<List<DirectSlotError>>();
        Platform.runLater(() -> ASTUtility.withLocalsParamsAndFields(parent, editor, this.getPosInSourceDoc(), this.includeDirectDecl(), vars -> {
            this.vars = vars;
            Stream<DirectSlotError> undeclaredVarErrors = this.plains.stream().map(identToken -> {
                if (!vars.containsKey(identToken.getText())) {
                    if (this.assignmentLHSParent != null && identToken.getText().equals(this.getJavaCode())) {
                        return new UndeclaredVariableLvalueError(this, this.assignmentLHSParent, vars.keySet());
                    }
                    return new UndeclaredVariableInExpressionError(this, identToken.getText(), identToken.getColumn() - 1, identToken.getColumn() - 1 + identToken.getLength(), this.slot, vars.keySet());
                }
                return null;
            }).filter(x -> x != null);
            editor.withTypes(availableTypes -> {
                Stream<DirectSlotError> unknownTypeErrors = this.types.stream().filter(t -> t.size() == 1).map(t -> (LocatableToken)t.get(0)).map(token -> {
                    String typeName = token.getText();
                    if (availableTypes.containsKey(typeName)) {
                        return null;
                    }
                    final int startPosInSlot = token.getColumn() - 1;
                    final int endPosInSlot = token.getColumn() - 1 + token.getLength();
                    FXPlatformConsumer<String> replace = s -> this.slot.replace(startPosInSlot, endPosInSlot, true, (String)s);
                    return new UnknownTypeError(this, typeName, replace, editor, availableTypes.values().stream(), editor.getImportSuggestions().values().stream().flatMap(Collection::stream)){

                        @Override
                        public int getStartPosition() {
                            return startPosInSlot;
                        }

                        @Override
                        public int getEndPosition() {
                            return endPosInSlot;
                        }
                    };
                }).filter(x -> x != null);
                f.complete(Stream.concat(undeclaredVarErrors, unknownTypeErrors).peek(e -> e.recordPath(rootPathMap.locationFor(this))).collect(Collectors.toList()));
            });
        }));
        return f;
    }

    protected boolean includeDirectDecl() {
        return false;
    }

    public void markAssignmentLHS(AssignFrame parent) {
        this.assignmentLHSParent = parent;
    }

    @Override
    public Map<String, CodeElement> getVars() {
        return this.vars;
    }
}

