/*
 * Decompiled with CFR 0.152.
 */
package bluej.prefmgr;

import bluej.Boot;
import bluej.Config;
import bluej.collect.DataCollector;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.javafx.JavaFXUtil;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class MiscPrefPanel
extends VBox
implements PrefPanelListener {
    private static final String bluejJdkURL = "bluej.url.javaStdLib";
    private static final String greenfootJdkURL = "greenfoot.url.javaStdLib";
    private TextField jdkURLField;
    private CheckBox linkToLibBox;
    private CheckBox showUncheckedBox;
    private String jdkURLPropertyName;
    private TextField playerNameField;
    private TextField participantIdentifierField;
    private TextField experimentIdentifierField;
    private Label statusLabel;

    public MiscPrefPanel() {
        JavaFXUtil.addStyleClass((Styleable)this, "prefmgr-pref-panel");
        this.jdkURLPropertyName = Config.isGreenfoot() ? greenfootJdkURL : bluejJdkURL;
        this.getChildren().add((Object)this.makeDocumentationPanel());
        if (Config.isGreenfoot()) {
            this.getChildren().add((Object)this.makePlayerNamePanel());
            if (Boot.isTrialRecording()) {
                this.getChildren().add((Object)this.makeDataCollectionPanel());
            }
        } else {
            this.getChildren().add((Object)this.makeVMPanel());
            this.getChildren().add((Object)this.makeDataCollectionPanel());
        }
    }

    private Node makeDataCollectionPanel() {
        ArrayList<Node> dataCollectionPanel = new ArrayList<Node>();
        this.statusLabel = new Label(DataCollector.getOptInOutStatus());
        this.statusLabel.setMinWidth(100.0);
        Button optButton = new Button(Config.getString("prefmgr.collection.change"));
        optButton.setOnAction(e -> {
            DataCollector.changeOptInOut(false);
            this.statusLabel.setText(DataCollector.getOptInOutStatus());
        });
        optButton.setMinWidth(Double.NEGATIVE_INFINITY);
        dataCollectionPanel.add(PrefMgrDialog.labelledItem(this.statusLabel, (Node)optButton));
        Label identifierLabel = new Label(Config.getString("prefmgr.collection.identifier.explanation") + ":");
        dataCollectionPanel.add((Node)identifierLabel);
        GridPane experimentParticipantPanel = new GridPane();
        JavaFXUtil.addStyleClass((Styleable)experimentParticipantPanel, "prefmgr-experiment-participant");
        Label experimentLabel = new Label(Config.getString("prefmgr.collection.identifier.experiment"));
        experimentParticipantPanel.add((Node)experimentLabel, 0, 0);
        this.experimentIdentifierField = new TextField();
        experimentParticipantPanel.add((Node)this.experimentIdentifierField, 1, 0);
        Label participantLabel = new Label(Config.getString("prefmgr.collection.identifier.participant"));
        experimentParticipantPanel.add((Node)participantLabel, 0, 1);
        this.participantIdentifierField = new TextField();
        experimentParticipantPanel.add((Node)this.participantIdentifierField, 1, 1);
        dataCollectionPanel.add((Node)experimentParticipantPanel);
        return PrefMgrDialog.headedVBox("prefmgr.collection.title", dataCollectionPanel);
    }

    private Node makeVMPanel() {
        this.showUncheckedBox = new CheckBox(Config.getString("prefmgr.misc.showUnchecked"));
        return PrefMgrDialog.headedVBox("prefmgr.misc.vm.title", Arrays.asList(this.showUncheckedBox));
    }

    private Node makePlayerNamePanel() {
        ArrayList<Node> contents = new ArrayList<Node>();
        String shortcutText = " ";
        KeyStroke accelerator = Config.GREENFOOT_SET_PLAYER_NAME_SHORTCUT;
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                shortcutText = shortcutText + KeyEvent.getKeyModifiersText(modifiers);
                shortcutText = shortcutText + (Config.isMacOS() ? "" : "+");
            }
            shortcutText = (keyCode = accelerator.getKeyCode()) != 0 ? shortcutText + KeyEvent.getKeyText(keyCode) : shortcutText + accelerator.getKeyChar();
        }
        contents.add((Node)new Label(Config.getString("playername.dialog.help")));
        this.playerNameField = new TextField(Config.getPropString("extensions.rmiextension.RMIExtension.settings.greenfoot.player.name", "Player"));
        this.playerNameField.setPrefColumnCount(20);
        contents.add(PrefMgrDialog.labelledItem("playername.dialog.help", (Node)this.playerNameField));
        contents.add(PrefMgrDialog.wrappedLabel(Config.getString("prefmgr.misc.playerNameNote") + shortcutText));
        return PrefMgrDialog.headedVBox("prefmgr.misc.playername.title", contents);
    }

    private Node makeDocumentationPanel() {
        ArrayList<Node> contents = new ArrayList<Node>();
        this.jdkURLField = new TextField();
        JavaFXUtil.addStyleClass((Styleable)this.jdkURLField, "prefmgr-jdk-url");
        contents.add(PrefMgrDialog.labelledItem("prefmgr.misc.jdkurlpath", (Node)this.jdkURLField));
        this.linkToLibBox = new CheckBox(Config.getString("prefmgr.misc.linkToLib"));
        contents.add((Node)this.linkToLibBox);
        contents.add(PrefMgrDialog.wrappedLabel(Config.getStringList("prefmgr.misc.linkToLibNoteLine").stream().collect(Collectors.joining(" "))));
        return PrefMgrDialog.headedVBox("prefmgr.misc.documentation.title", contents);
    }

    @Override
    public void beginEditing() {
        this.linkToLibBox.setSelected(PrefMgr.getFlag("doctool.linkToStandardLib"));
        this.jdkURLField.setText(Config.getPropString(this.jdkURLPropertyName));
        if (!Config.isGreenfoot()) {
            this.showUncheckedBox.setSelected(PrefMgr.getFlag("bluej.compiler.showunchecked"));
            this.statusLabel.setText(DataCollector.getOptInOutStatus());
            this.experimentIdentifierField.setText(DataCollector.getExperimentIdentifier());
            this.participantIdentifierField.setText(DataCollector.getParticipantIdentifier());
        } else {
            this.playerNameField.setText(Config.getPropString("extensions.rmiextension.RMIExtension.settings.greenfoot.player.name", "Player"));
        }
    }

    @Override
    public void revertEditing() {
    }

    @Override
    public void commitEditing() {
        PrefMgr.setFlag("doctool.linkToStandardLib", this.linkToLibBox.isSelected());
        if (!Config.isGreenfoot()) {
            PrefMgr.setFlag("bluej.compiler.showunchecked", this.showUncheckedBox.isSelected());
            String expId = this.experimentIdentifierField.getText();
            String partId = this.participantIdentifierField.getText();
            SwingUtilities.invokeLater(() -> {
                DataCollector.setExperimentIdentifier(expId);
                DataCollector.setParticipantIdentifier(partId);
            });
        }
        String jdkURL = this.jdkURLField.getText();
        Config.putPropString(this.jdkURLPropertyName, jdkURL);
        if (Config.isGreenfoot()) {
            Config.putPropString("extensions.rmiextension.RMIExtension.settings.greenfoot.player.name", this.playerNameField.getText());
        }
    }
}

