/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target.role;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.debugger.DebuggerObject;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.editor.TextEditor;
import bluej.parser.SourceLocation;
import bluej.parser.SourceSpan;
import bluej.parser.UnitTestAnalyzer;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.TestRunnerThread;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.DependentTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.role.ClassRole;
import bluej.testmgr.TestDisplayFrame;
import bluej.testmgr.record.ExistingFixtureInvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import bluej.utility.JavaUtils;
import bluej.utility.javafx.dialog.InputDialog;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import org.junit.Test;
import threadchecker.OnThread;
import threadchecker.Tag;

public class UnitTestClassRole
extends ClassRole {
    public static final String UNITTEST_ROLE_NAME = "UnitTestTarget";
    public static final String UNITTEST_ROLE_NAME_JUNIT4 = "UnitTestTargetJunit4";
    private final Color unittestbg = Config.getOptionalItemColour("colour.class.bg.unittest");
    private static final String testAll = Config.getString("pkgmgr.test.popup.testAll");
    private static final String createTest = Config.getString("pkgmgr.test.popup.createTest");
    private static final String benchToFixture = Config.getString("pkgmgr.test.popup.benchToFixture");
    private static final String fixtureToBench = Config.getString("pkgmgr.test.popup.fixtureToBench");
    private final boolean isJunit4;
    private static final String spaces = "                                 ";

    public UnitTestClassRole(boolean isJunit4) {
        this.isJunit4 = isJunit4;
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getRoleName() {
        if (this.isJunit4) {
            return UNITTEST_ROLE_NAME_JUNIT4;
        }
        return UNITTEST_ROLE_NAME;
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getStereotypeLabel() {
        return "unit test";
    }

    @Override
    public Paint getBackgroundPaint(int width, int height) {
        if (this.unittestbg != null) {
            return this.unittestbg;
        }
        Paint result = !Config.isRaspberryPi() ? new GradientPaint(0.0f, 0.0f, new Color(197, 211, 165), 0.0f, height, new Color(170, 190, 140)) : new Color(184, 201, 153);
        return result;
    }

    @OnThread(value=Tag.Any)
    private boolean isJUnitTestMethod(Method m) {
        if (this.isJunit4) {
            Class<?> cl = m.getDeclaringClass();
            ClassLoader classLoader = cl.getClassLoader();
            try {
                Class testClass = classLoader == null ? Test.class : classLoader.loadClass("org.junit.Test");
                if (m.getAnnotation(testClass) != null) {
                    if (!Modifier.isPublic(m.getModifiers())) {
                        return false;
                    }
                    return m.getParameterTypes().length == 0;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            return false;
        }
        if (!m.getName().startsWith("test")) {
            return false;
        }
        if (!Modifier.isPublic(m.getModifiers())) {
            return false;
        }
        if (m.getParameterTypes().length != 0) {
            return false;
        }
        return m.getReturnType().equals(Void.TYPE);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean createRoleMenu(ObservableList<MenuItem> menu, ClassTarget ct, Class<?> cl, DependentTarget.State state) {
        boolean enableTestAll = false;
        if (state == DependentTarget.State.NORMAL && cl != null && !ct.isAbstract()) {
            Method[] allMethods = cl.getMethods();
            for (int i = 0; i < allMethods.length; ++i) {
                Method m = allMethods[i];
                if (!this.isJUnitTestMethod(m)) continue;
                enableTestAll = true;
                break;
            }
        }
        UnitTestClassRole.addMenuItem(menu, new TestAction(testAll, ct.getPackage().getEditor(), ct), enableTestAll);
        menu.add((Object)new SeparatorMenuItem());
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    private static void addMenuItem(ObservableList<MenuItem> menu, TargetAbstractAction testAction, boolean enableTestAll) {
        menu.add((Object)testAction);
        testAction.setDisable(!enableTestAll);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean createClassConstructorMenu(ObservableList<MenuItem> menu, ClassTarget ct, Class<?> cl) {
        boolean hasEntries = false;
        Method[] allMethods = cl.getMethods();
        if (!ct.isAbstract()) {
            for (int i = 0; i < allMethods.length; ++i) {
                String rtype;
                Method m = allMethods[i];
                if (!this.isJUnitTestMethod(m)) continue;
                try {
                    rtype = JavaUtils.getJavaUtils().getReturnType(m).toString(true);
                }
                catch (ClassNotFoundException cnfe) {
                    rtype = m.getReturnType().getName();
                }
                TestAction testAction = new TestAction(rtype + " " + m.getName() + "()", ct.getPackage().getEditor(), ct, m.getName());
                menu.add((Object)testAction);
                hasEntries = true;
            }
            if (!hasEntries) {
                MenuItem item = new MenuItem(Config.getString("pkgmgr.test.popup.noTests"));
                item.setDisable(true);
                menu.add((Object)item);
            }
        } else {
            MenuItem item = new MenuItem(Config.getString("pkgmgr.test.popup.abstract"));
            item.setDisable(true);
            menu.add((Object)item);
        }
        return true;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean createClassStaticMenu(ObservableList<MenuItem> menu, ClassTarget ct, boolean hasSource, Class<?> cl) {
        boolean enable = !ct.getPackage().getProject().inTestMode() && hasSource && !ct.isAbstract();
        UnitTestClassRole.addMenuItem(menu, new MakeTestCaseAction(createTest, ct.getPackage().getEditor(), ct), enable);
        UnitTestClassRole.addMenuItem(menu, new BenchToFixtureAction(benchToFixture, ct.getPackage().getEditor(), ct), enable);
        UnitTestClassRole.addMenuItem(menu, new FixtureToBenchAction(fixtureToBench, ct.getPackage().getEditor(), ct), enable);
        return true;
    }

    @Override
    @OnThread(value=Tag.Any)
    public boolean canConvertToStride() {
        return false;
    }

    @Override
    public void run(PkgMgrFrame pmf, ClassTarget ct, String param) {
        if (param != null) {
            Project proj = pmf.getProject();
            Platform.runLater(() -> TestDisplayFrame.getTestDisplay().startTest(proj, 1));
        }
        new TestRunnerThread(pmf, ct, param).start();
    }

    public List<String> startRunTest(PkgMgrFrame pmf, ClassTarget ct, TestRunnerThread trt) {
        Class<?> cl = pmf.getPackage().loadClass(ct.getQualifiedName());
        if (cl == null) {
            return null;
        }
        List<String> testMethods = Arrays.stream(cl.getMethods()).filter(this::isJUnitTestMethod).map(Method::getName).collect(Collectors.toList());
        Project proj = pmf.getProject();
        Platform.runLater(() -> TestDisplayFrame.getTestDisplay().startTest(proj, testMethods.size()));
        return testMethods;
    }

    public int getTestCount(ClassTarget ct) {
        if (!ct.isCompiled()) {
            return 0;
        }
        Class<?> cl = ct.getPackage().loadClass(ct.getQualifiedName());
        if (cl == null) {
            return 0;
        }
        Method[] allMethods = cl.getMethods();
        int testCount = 0;
        for (int i = 0; i < allMethods.length; ++i) {
            if (!this.isJUnitTestMethod(allMethods[i])) continue;
            ++testCount;
        }
        return testCount;
    }

    @OnThread(value=Tag.FXPlatform)
    public void doMakeTestCase(PkgMgrFrame pmf, ClassTarget ct) {
        String newTestName = new TestNameDialog("unittest-new-test-method", "").showAndWait().orElse(null);
        if (newTestName == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            try {
                Charset charset = pmf.getProject().getProjectCharset();
                UnitTestAnalyzer uta = this.analyzeUnitTest(ct, charset);
                SourceSpan existingSpan = uta.getMethodBlockSpan(newTestName);
                if (existingSpan != null) {
                    Platform.runLater(() -> {
                        if (DialogManager.askQuestionFX((Window)pmf.getFXWindow(), "unittest-method-present") != 1) {
                            SwingUtilities.invokeLater(() -> this.finishTestCase(pmf, ct, newTestName));
                        }
                    });
                } else {
                    this.finishTestCase(pmf, ct, newTestName);
                }
            }
            catch (IOException ioe) {
                Platform.runLater(() -> {
                    DialogManager.showErrorWithTextFX((Window)pmf.getFXWindow(), "unittest-io-error", ioe.getLocalizedMessage());
                    Debug.reportError("Error reading unit test source", ioe);
                    SwingUtilities.invokeLater(() -> this.finishTestCase(pmf, ct, newTestName));
                });
            }
        });
    }

    @OnThread(value=Tag.Swing)
    private void finishTestCase(PkgMgrFrame pmf, ClassTarget ct, String newTestName) {
        pmf.testRecordingStarted(Config.getString("pkgmgr.test.recording") + " " + ct.getBaseName() + "." + newTestName + "()");
        pmf.getProject().removeClassLoader();
        this.runTestSetup(pmf, ct, false);
        pmf.getObjectBench().resetRecordingInteractions();
        pmf.setTestInfo(newTestName, ct);
    }

    private UnitTestAnalyzer analyzeUnitTest(ClassTarget ct, Charset fileEncoding) throws IOException {
        ct.ensureSaved();
        UnitTestAnalyzer uta = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(ct.getSourceFile());
            InputStreamReader reader = new InputStreamReader((InputStream)fis, fileEncoding);
            uta = new UnitTestAnalyzer(reader);
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    Debug.reportError(ioe);
                }
            }
        }
        return uta;
    }

    private void runTestSetup(final PkgMgrFrame pmf, final ClassTarget ct, final boolean recordAsFixtureToBench) {
        new Thread(){

            @Override
            public void run() {
                final Map<String, DebuggerObject> dobs = pmf.getProject().getDebugger().runTestSetUp(ct.getQualifiedName());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<DataCollector.NamedTyped> recordObjects = new ArrayList<DataCollector.NamedTyped>();
                        for (Map.Entry mapent : dobs.entrySet()) {
                            DebuggerObject objVal = (DebuggerObject)mapent.getValue();
                            if (objVal.isNullObject()) continue;
                            String actualName = pmf.putObjectOnBench((String)mapent.getKey(), objVal, objVal.getGenType(), null, Optional.empty());
                            recordObjects.add(new DataCollector.NamedTyped(actualName, objVal.getClassName()));
                        }
                        if (recordAsFixtureToBench) {
                            DataCollector.fixtureToObjectBench(pmf.getPackage(), ct.getSourceFile(), recordObjects);
                        }
                    }
                });
            }
        }.start();
    }

    private String getIndentString() {
        int ts = Math.min(Config.getPropInteger("bluej.editor.tabsize", 4), spaces.length());
        return spaces.substring(0, ts);
    }

    public void doEndMakeTestCase(PkgMgrFrame pmf, ClassTarget ct, String name) {
        TextEditor ed = ct.getEditor().assumeText();
        String ts = this.getIndentString();
        try {
            Charset charset = pmf.getProject().getProjectCharset();
            UnitTestAnalyzer uta = this.analyzeUnitTest(ct, charset);
            SourceSpan existingSpan = uta.getMethodBlockSpan(name);
            if (existingSpan != null) {
                ed.setSelection(existingSpan.getStartLine(), existingSpan.getStartColumn(), existingSpan.getEndLine(), existingSpan.getEndColumn());
                ed.insertText("{\n" + pmf.getObjectBench().getTestMethod(ts + ts) + ts + "}", false);
            } else {
                SourceLocation methodInsert = uta.getNewMethodInsertLocation();
                if (methodInsert != null) {
                    ed.setSelection(methodInsert.getLine(), methodInsert.getColumn(), 1);
                    if (this.isJunit4) {
                        ed.insertText("\n" + ts + "@Test\n" + ts + "public void " + name + "()\n" + ts + "{\n" + pmf.getObjectBench().getTestMethod(ts + ts) + ts + "}\n}\n", false);
                    } else {
                        ed.insertText("\n" + ts + "public void " + name + "()\n" + ts + "{\n" + pmf.getObjectBench().getTestMethod(ts + ts) + ts + "}\n}\n", false);
                    }
                }
            }
            ed.save();
        }
        catch (IOException ioe) {
            PkgMgrFrame.showMessageWithText(pmf.getPackage(), "generic-file-save-error", ioe.getLocalizedMessage());
        }
    }

    public void doFixtureToBench(PkgMgrFrame pmf, ClassTarget ct) {
        TextEditor ed = ct.getEditor().assumeText();
        ExistingFixtureInvokerRecord existing = new ExistingFixtureInvokerRecord();
        try {
            Charset charset = pmf.getProject().getProjectCharset();
            UnitTestAnalyzer uta = this.analyzeUnitTest(ct, charset);
            List<SourceSpan> fixtureSpans = uta.getFieldSpans();
            ListIterator<SourceSpan> it = fixtureSpans.listIterator();
            while (it.hasNext()) {
                SourceSpan variableSpan = it.next();
                String fieldDecl = ed.getText(variableSpan.getStartLocation(), variableSpan.getEndLocation());
                existing.addFieldDeclaration(fieldDecl);
            }
            SourceSpan setUpSpan = uta.getMethodBlockSpan("setUp");
            if (setUpSpan != null) {
                String setUpWithBrackets = ed.getText(setUpSpan.getStartLocation(), setUpSpan.getEndLocation());
                String setUpWithoutBrackets = setUpWithBrackets.substring(setUpWithBrackets.indexOf(123) + 1, setUpWithBrackets.lastIndexOf(125)).trim();
                existing.setSetupMethod(setUpWithoutBrackets);
            }
        }
        catch (IOException ioe) {
            PkgMgrFrame.showMessageWithText(pmf.getPackage(), "generic-file-save-error", ioe.getLocalizedMessage());
        }
        this.runTestSetup(pmf, ct, true);
        pmf.getObjectBench().addInteraction(existing);
    }

    public void doBenchToFixture(PkgMgrFrame pmf, ClassTarget ct) {
        if (pmf.getObjectBench().getObjectCount() == 0) {
            return;
        }
        TextEditor ed = ct.getEditor().assumeText();
        try {
            SourceLocation fixtureInsertLocation;
            Charset charset = pmf.getProject().getProjectCharset();
            UnitTestAnalyzer uta = this.analyzeUnitTest(ct, charset);
            List<SourceSpan> variables = uta.getFieldSpans();
            if (variables != null && variables.size() > 0) {
                AtomicBoolean shouldContinue = new AtomicBoolean();
                SecondaryLoop loop = Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
                Platform.runLater(() -> {
                    boolean cont = DialogManager.askQuestionFX(null, "unittest-fixture-present") != 1;
                    shouldContinue.set(cont);
                    loop.exit();
                });
                loop.enter();
                if (!shouldContinue.get()) {
                    return;
                }
            }
            if (variables != null) {
                ListIterator<SourceSpan> it = variables.listIterator(variables.size());
                while (it.hasPrevious()) {
                    SourceSpan variableSpan = it.previous();
                    ed.setSelection(variableSpan.getStartLine(), variableSpan.getStartColumn(), variableSpan.getEndLine(), variableSpan.getEndColumn());
                    ed.insertText("", false);
                }
                uta = this.analyzeUnitTest(ct, charset);
            }
            if ((fixtureInsertLocation = uta.getFixtureInsertLocation()) == null) {
                return;
            }
            ArrayList<String> names = new ArrayList<String>();
            for (ObjectWrapper obj : pmf.getObjectBench().getObjects()) {
                names.add(obj.getName());
            }
            DataCollector.objectBenchToFixture(pmf.getPackage(), ct.getSourceFile(), names);
            SourceSpan setupSpan = uta.getMethodBlockSpan("setUp");
            String ts = this.getIndentString();
            if (setupSpan != null) {
                ed.setSelection(setupSpan.getStartLine(), setupSpan.getStartColumn(), setupSpan.getEndLine(), setupSpan.getEndColumn());
            } else {
                ed.setSelection(fixtureInsertLocation.getLine(), fixtureInsertLocation.getColumn(), 1);
                if (this.isJunit4) {
                    ed.insertText("{\n" + ts + "@Before\n" + ts + "public void setUp()\n" + ts, false);
                } else {
                    ed.insertText("{\n" + ts + "public void setUp()\n" + ts, false);
                }
            }
            ed.insertText("{\n" + pmf.getObjectBench().getFixtureSetup(ts + ts) + ts + "}", false);
            ed.setSelection(fixtureInsertLocation.getLine(), fixtureInsertLocation.getColumn(), 1);
            ed.insertText("{\n" + pmf.getObjectBench().getFixtureDeclaration(ts), false);
            ed.save();
        }
        catch (IOException ioe) {
            PkgMgrFrame.showMessageWithText(pmf.getPackage(), "generic-file-save-error", ioe.getLocalizedMessage());
        }
        pmf.getPackage().compileQuiet(ct, CompileReason.MODIFIED, CompileType.INTERNAL_COMPILE);
        pmf.getProject().removeClassLoader();
        pmf.getProject().newRemoteClassLoaderLeavingBreakpoints();
    }

    @OnThread(value=Tag.FXPlatform)
    private class TestNameDialog
    extends InputDialog<String> {
        public TestNameDialog(String dialogLabel, String prompt) {
            super(dialogLabel, prompt, "test-name-dialog");
        }

        @Override
        protected String convert(String newTestName) {
            if (!UnitTestClassRole.this.isJunit4 && !newTestName.startsWith("test")) {
                return "test" + Character.toTitleCase(newTestName.charAt(0)) + newTestName.substring(1);
            }
            return newTestName;
        }

        @Override
        protected boolean validate(String oldInput, String newTestName) {
            if (newTestName.length() == 0) {
                this.setErrorText(Config.getString("pkgmgr.test.noTestName"));
                this.setOKEnabled(false);
            } else if (!JavaNames.isIdentifier(this.convert(newTestName))) {
                this.setErrorText(Config.getString("pkgmgr.test.invalidTestName"));
                this.setOKEnabled(false);
            } else {
                this.setErrorText("");
                this.setOKEnabled(true);
            }
            return true;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private class FixtureToBenchAction
    extends TargetAbstractAction {
        public FixtureToBenchAction(String name, PackageEditor ped, Target t) {
            super(name, ped, t);
        }

        @Override
        @OnThread(value=Tag.Swing)
        public void actionPerformed(ActionEvent e) {
            this.ped.raiseFixtureToBenchEvent(this.t);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private class BenchToFixtureAction
    extends TargetAbstractAction {
        public BenchToFixtureAction(String name, PackageEditor ped, Target t) {
            super(name, ped, t);
        }

        @Override
        @OnThread(value=Tag.Swing)
        public void actionPerformed(ActionEvent e) {
            this.ped.raiseBenchToFixtureEvent(this.t);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private class MakeTestCaseAction
    extends TargetAbstractAction {
        public MakeTestCaseAction(String name, PackageEditor ped, Target t) {
            super(name, ped, t);
        }

        @Override
        @OnThread(value=Tag.Swing)
        public void actionPerformed(ActionEvent e) {
            this.ped.raiseMakeTestCaseEvent(this.t);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private class TestAction
    extends TargetAbstractAction {
        private String testName;

        public TestAction(String actionName, PackageEditor ped, Target t) {
            super(actionName, ped, t);
            this.testName = null;
        }

        public TestAction(String actionName, PackageEditor ped, Target t, String testName) {
            super(actionName, ped, t);
            this.testName = testName;
        }

        @Override
        @OnThread(value=Tag.Swing)
        public void actionPerformed(ActionEvent e) {
            this.ped.raiseRunTargetEvent(this.t, this.testName);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private abstract class TargetAbstractAction
    extends MenuItem {
        protected Target t;
        protected PackageEditor ped;

        public TargetAbstractAction(String name, PackageEditor ped, Target t) {
            super(name);
            this.ped = ped;
            this.t = t;
            this.setOnAction(e -> SwingUtilities.invokeLater(() -> this.actionPerformed((ActionEvent)e)));
        }

        @OnThread(value=Tag.Swing)
        public abstract void actionPerformed(ActionEvent var1);
    }
}

