/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.Config;
import bluej.collect.DiagnosticWithShown;
import bluej.collect.StrideEditReason;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.editor.Editor;
import bluej.editor.EditorManager;
import bluej.extensions.SourceType;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.target.EditableTarget;
import bluej.utility.Debug;
import bluej.utility.javafx.JavaFXUtil;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javafx.application.Platform;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ReadmeTarget
extends EditableTarget {
    private static final String openStr = Config.getString("pkgmgr.packagemenu.open");
    private static final Color envOpColour = Config.ENV_COLOUR;
    public static final String README_ID = "@README";
    private static @OnThread(value=Tag.FXPlatform) Image readmeImage;
    private static @OnThread(value=Tag.FXPlatform) Image selectedReadmeImage;
    private @OnThread(value=Tag.FXPlatform) ImageView imageView;

    public ReadmeTarget(Package pkg) {
        super(pkg, README_ID);
        Platform.runLater(() -> {
            if (readmeImage == null) {
                readmeImage = Config.getImageAsFXImage("image.readme");
            }
            if (selectedReadmeImage == null) {
                selectedReadmeImage = Config.getImageAsFXImage("image.readme-selected");
            }
            this.setPos(10, 10);
            this.setSize((int)readmeImage.getWidth(), (int)readmeImage.getHeight());
            JavaFXUtil.addStyleClass((Styleable)this.pane, "readme-target");
            this.pane.setTop(null);
            this.imageView = new ImageView();
            this.imageView.setImage(readmeImage);
            this.pane.setCenter((Node)this.imageView);
        });
    }

    @Override
    public void load(Properties props, String prefix) throws NumberFormatException {
    }

    @Override
    public File getSourceFile() {
        return new File(this.getPackage().getPath(), "README.TXT");
    }

    @Override
    @OnThread(value=Tag.FX)
    public boolean isResizable() {
        return false;
    }

    @Override
    @OnThread(value=Tag.Any)
    public boolean isSaveable() {
        return false;
    }

    @Override
    public Editor getEditor() {
        if (this.editor == null) {
            this.editor = EditorManager.getEditorManager().openText(this.getSourceFile().getPath(), this.getPackage().getProject().getProjectCharset(), "README.TXT", this.getPackage().getProject()::getDefaultFXTabbedEditor);
        }
        return this.editor;
    }

    private void openEditor() {
        if (this.editor == null && !this.getSourceFile().exists()) {
            try {
                this.getSourceFile().createNewFile();
            }
            catch (IOException ioe) {
                Debug.reportError("Couldn't open README", ioe);
            }
        }
        if (this.getEditor() != null) {
            this.editor.setVisible(true);
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void doubleClick() {
        SwingUtilities.invokeLater(() -> this.openEditor());
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void popupMenu(int x, int y, PackageEditor editor) {
        ContextMenu menu = this.createMenu();
        if (menu != null) {
            this.showingMenu(menu);
            menu.show(this.getNode(), (double)x, (double)y);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private ContextMenu createMenu() {
        MenuItem open = new MenuItem(openStr);
        open.setOnAction(e -> SwingUtilities.invokeLater(() -> this.openEditor()));
        JavaFXUtil.addStyleClass((Styleable)open, "class-action-inbuilt");
        return new ContextMenu(new MenuItem[]{open});
    }

    @Override
    public void remove() {
    }

    public void generateDoc() {
    }

    public String getProperty(String key) {
        return null;
    }

    public void setProperty(String key, String value) {
    }

    public void recordEdit(SourceType sourceType, String curSource, boolean includeOneLineEdits, StrideEditReason reason) {
    }

    public void recordClose() {
    }

    public void recordOpen() {
    }

    public void recordSelected() {
    }

    public void recordShowErrorMessage(int identifier, List<String> quickFixes) {
    }

    public void recordEarlyErrors(List<DiagnosticWithShown> diagnostics) {
    }

    public void recordLateErrors(List<DiagnosticWithShown> diagnostics) {
    }

    public void recordFix(int errorIdentifier, int fixIndex) {
    }

    public void recordCodeCompletionStarted(Integer line, Integer column, String xpath, Integer index, String stem) {
    }

    public void recordCodeCompletionEnded(Integer lineNumber, Integer columnNumber, String xpath, Integer elementOffset, String stem, String replacement) {
    }

    public void recordUnknownCommandKey(String enclosingFrameXpath, int cursorIndex, char key) {
    }

    public void recordShowErrorIndicator(int identifier) {
    }

    public void compile(Editor editor, CompileReason reason, CompileType type) {
    }

    @OnThread(value=Tag.Any)
    public void scheduleCompilation(boolean immediate, CompileReason reason, CompileType type) {
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.imageView.setImage(selected ? selectedReadmeImage : readmeImage);
    }

    public void showingInterface(boolean showingInterface) {
    }
}

