/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.debugger.DebuggerTestResult;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.role.UnitTestClassRole;
import bluej.testmgr.TestDisplayFrame;
import bluej.utility.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

public class TestRunnerThread
extends Thread {
    private final @OnThread(value=Tag.Unique) Iterator<ClassTarget> testIterator;
    private final PkgMgrFrame pmf;
    private final String methodName;
    private int state;
    private final Project project;

    @OnThread(value=Tag.Swing)
    public TestRunnerThread(PkgMgrFrame pmf, Iterator<ClassTarget> i) {
        this.pmf = pmf;
        this.project = pmf.getProject();
        this.methodName = null;
        this.testIterator = i;
        this.state = 0;
    }

    @OnThread(value=Tag.Swing)
    public TestRunnerThread(PkgMgrFrame pmf, ClassTarget ct, String methodName) {
        this.pmf = pmf;
        this.project = pmf.getProject();
        ArrayList<ClassTarget> l = new ArrayList<ClassTarget>(1);
        l.add(ct);
        this.testIterator = l.iterator();
        this.methodName = methodName;
        this.state = 0;
    }

    @Override
    @OnThread(value=Tag.Unique, ignoreParent=true)
    public void run() {
        while (this.testIterator.hasNext()) {
            List<String> allMethods;
            ClassTarget ct = this.testIterator.next();
            if (this.methodName == null) {
                CompletableFuture methodsFuture = new CompletableFuture();
                SwingUtilities.invokeLater(() -> this.startTestFindMethods(ct, methodsFuture));
                try {
                    allMethods = (List<String>)methodsFuture.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    Debug.reportError(e);
                    allMethods = Collections.emptyList();
                }
            } else {
                allMethods = Arrays.asList(this.methodName);
            }
            for (String methodName : allMethods) {
                DebuggerTestResult lastResult = this.project.getDebugger().runTestMethod(ct.getQualifiedName(), methodName);
                Platform.runLater(() -> this.showNextResult(lastResult));
            }
        }
        SwingUtilities.invokeLater(() -> {
            if (this.methodName == null) {
                this.pmf.endTestRun();
            }
        });
    }

    @OnThread(value=Tag.FXPlatform)
    private void showNextResult(DebuggerTestResult lastResult) {
        boolean quiet = this.methodName != null && lastResult.isSuccess();
        TestDisplayFrame.getTestDisplay().addResult(lastResult, quiet);
        SwingUtilities.invokeLater(() -> {
            if (quiet) {
                this.pmf.setStatus(this.methodName + " " + Config.getString("pkgmgr.test.succeeded"));
            }
            DataCollector.testResult(this.pmf.getPackage(), lastResult);
        });
    }

    @OnThread(value=Tag.Swing)
    private void startTestFindMethods(ClassTarget ct, CompletableFuture<List<String>> methodsFuture) {
        if (ct.isCompiled() && ct.isUnitTest() && !ct.isAbstract()) {
            UnitTestClassRole utcr = (UnitTestClassRole)ct.getRole();
            List<String> allMethods = utcr.startRunTest(this.pmf, ct, this);
            if (allMethods == null) {
                methodsFuture.complete(Collections.emptyList());
            } else {
                methodsFuture.complete(allMethods);
            }
        } else {
            methodsFuture.complete(Collections.emptyList());
        }
    }
}

