/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.DialogManager;
import bluej.utility.javafx.SwingNodeDialog;
import java.awt.FlowLayout;
import javafx.application.Platform;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ProjectPrintDialog
extends SwingNodeDialog {
    private boolean ok = false;
    private JCheckBox printSource;
    private JCheckBox printReadme;
    private JCheckBox printLineNumbers;
    private JCheckBox printHighlighting;
    private @OnThread(value=Tag.Any, requireSynchronized=true) boolean printSourceSelected;
    private @OnThread(value=Tag.Any, requireSynchronized=true) boolean printReadmeSelected;
    private @OnThread(value=Tag.Any, requireSynchronized=true) boolean printLineNumbersSelected;
    private @OnThread(value=Tag.Any, requireSynchronized=true) boolean printHighlightingSelected;

    public ProjectPrintDialog(PkgMgrFrame parent) {
        super(parent::getFXWindow);
        this.setTitle(Config.getString("pkgmgr.printDialog.title"));
        this.setModal(true);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        mainPanel.add(Box.createVerticalStrut(17));
        this.printSource = new JCheckBox(Config.getString("pkgmgr.printDialog.printSource"));
        mainPanel.add(this.printSource);
        if (parent.getPackage().isUnnamedPackage()) {
            this.printReadme = new JCheckBox(Config.getString("pkgmgr.printDialog.printReadme"));
            mainPanel.add(this.printReadme);
        }
        mainPanel.add(Box.createVerticalStrut(5));
        this.printLineNumbers = new JCheckBox(Config.getString("editor.printDialog.printLineNumbers"));
        this.printLineNumbers.setSelected(true);
        mainPanel.add(this.printLineNumbers);
        this.printHighlighting = new JCheckBox(Config.getString("editor.printDialog.printHighlighting"));
        mainPanel.add(this.printHighlighting);
        mainPanel.add(Box.createVerticalStrut(5));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        JButton okButton = BlueJTheme.getOkButton();
        okButton.addActionListener(event -> this.doOK());
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(event -> this.doCancel());
        DialogManager.addOKCancelButtons(buttonPanel, okButton, cancelButton);
        this.setDefaultButton(okButton);
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
        DialogManager.centreDialog(this);
        Platform.runLater(() -> this.setCloseIsButton(cancelButton));
    }

    public boolean display() {
        this.ok = false;
        this.setVisible(true);
        return this.ok;
    }

    public void doOK() {
        this.ok = this.printDiagram() || this.printSource() || this.printReadme();
        this.storeValues();
        this.setVisible(false);
    }

    public void doCancel() {
        this.ok = false;
        this.setVisible(false);
    }

    @OnThread(value=Tag.Any)
    public synchronized boolean printDiagram() {
        return false;
    }

    @OnThread(value=Tag.Any)
    public synchronized boolean printSource() {
        return this.printSourceSelected;
    }

    @OnThread(value=Tag.Any)
    public synchronized boolean printReadme() {
        return this.printReadmeSelected;
    }

    private synchronized void storeValues() {
        this.printSourceSelected = this.printSource.isSelected();
        this.printReadmeSelected = this.printReadme != null && this.printReadme.isSelected();
        this.printLineNumbersSelected = this.printLineNumbers.isSelected();
        this.printHighlightingSelected = this.printHighlighting.isSelected();
    }

    @OnThread(value=Tag.Any)
    public synchronized boolean printLineNumbers() {
        return this.printLineNumbersSelected;
    }

    @OnThread(value=Tag.Any)
    public synchronized boolean printHighlighting() {
        return this.printHighlightingSelected;
    }
}

