/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJEvent;
import bluej.Boot;
import bluej.Config;
import bluej.classmgr.BPClassLoader;
import bluej.classmgr.ClassMgrPrefPanel;
import bluej.collect.DataCollector;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerEvent;
import bluej.debugger.DebuggerListener;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerThread;
import bluej.debugmgr.ExecControls;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.inspector.ClassInspector;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.debugmgr.inspector.ObjectInspector;
import bluej.debugmgr.inspector.ResultInspector;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.editor.Editor;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.FrameShelfStorage;
import bluej.extensions.BProject;
import bluej.extensions.ExtensionBridge;
import bluej.extmgr.ExtensionsManager;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamSettingsController;
import bluej.groupwork.actions.TeamActionGroup;
import bluej.groupwork.ui.CommitAndPushFrame;
import bluej.groupwork.ui.CommitAndPushInterface;
import bluej.groupwork.ui.CommitCommentsFrame;
import bluej.groupwork.ui.StatusFrame;
import bluej.groupwork.ui.TeamSettingsDialog;
import bluej.groupwork.ui.UpdateFilesFrame;
import bluej.parser.entity.EntityResolver;
import bluej.pkgmgr.DocPathEntry;
import bluej.pkgmgr.DocuGenerator;
import bluej.pkgmgr.JavadocResolver;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PackageFile;
import bluej.pkgmgr.PackageFileFactory;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.ProjectEntityResolver;
import bluej.pkgmgr.ProjectJavadocResolver;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import bluej.prefmgr.PrefMgr;
import bluej.terminal.Terminal;
import bluej.testmgr.record.ClassInspectInvokerRecord;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.ImportScanner;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformSupplier;
import bluej.views.View;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.Interpolator;
import javafx.animation.ScaleTransition;
import javafx.application.Platform;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import threadchecker.OnThread;
import threadchecker.Tag;

public class Project
implements DebuggerListener,
InspectorManager {
    public static final int NEW_PACKAGE_DONE = 0;
    public static final int NEW_PACKAGE_EXIST = 1;
    public static final int NEW_PACKAGE_BAD_NAME = 2;
    public static final int NEW_PACKAGE_NO_PARENT = 3;
    public static final String projectLibDirName = "+libs";
    private static final String JDK_SOURCE_PATH_PROPERTY = "bluej.jdk.source";
    private static final String PROJECT_CHARSET_PROP = "project.charset";
    private static Map<File, Project> projects = new HashMap<File, Project>();
    private final File projectDir;
    private final @OnThread(value=Tag.Any) Package unnamedPackage;
    private final JavadocResolver javadocResolver;
    private Map<String, Package> packages;
    private final @OnThread(value=Tag.Any) Debugger debugger;
    private ExecControls execControls = null;
    private Terminal terminal = null;
    private DocuGenerator docuGenerator;
    private String initialPackageName = "";
    private @OnThread(value=Tag.FXPlatform) Map<Object, Inspector> inspectors;
    private @OnThread(value=Tag.Any, requireSynchronized=true) boolean inTestMode = false;
    private BPClassLoader currentClassLoader;
    private List<URL> libraryUrls;
    private TeamSettingsController teamSettingsController = null;
    private CommitAndPushInterface commitCommentsFrame = null;
    private UpdateFilesFrame updateFilesFrame = null;
    private StatusFrame statusFrame = null;
    private @OnThread(value=Tag.Any, requireSynchronized=true) Optional<Boolean> isSharedProject = Optional.empty();
    private TeamActionGroup teamActions;
    private List<DocPathEntry> sourcePath;
    private @OnThread(value=Tag.Any, requireSynchronized=true) Charset characterSet;
    private final @OnThread(value=Tag.FX) List<FXTabbedEditor> fXTabbedEditors = new ArrayList<FXTabbedEditor>();
    private final @OnThread(value=Tag.FX) List<Rectangle> fxCachedEditorSizes = new ArrayList<Rectangle>();
    private @OnThread(value=Tag.Any, requireSynchronized=true) Timer compilerTimer;
    private final @OnThread(value=Tag.Any) AtomicReference<CompileReason> latestCompileReason = new AtomicReference<Object>(null);
    private final @OnThread(value=Tag.Any) AtomicReference<CompileType> latestCompileType = new AtomicReference<Object>(null);
    private @OnThread(value=Tag.Any, requireSynchronized=true) Set<Package> scheduledPkgs = new HashSet<Package>();
    private @OnThread(value=Tag.Any, requireSynchronized=true) Set<ClassTarget> scheduledTargets = new HashSet<ClassTarget>();
    private BProject singleBProject;
    private boolean closing = false;
    private @OnThread(value=Tag.Any, requireSynchronized=true) ImportScanner importScanner;
    private boolean isDVCS = false;
    private final FrameShelfStorage shelfStorage;

    private Project(File projectDir) throws IOException {
        if (projectDir == null) {
            throw new NullPointerException();
        }
        Debug.log("Opening project: " + projectDir.toString());
        this.javadocResolver = new ProjectJavadocResolver(this);
        this.sourcePath = new ArrayList<DocPathEntry>();
        File javaHome = Boot.getInstance().getJavaHome();
        File jdkSourceZip = new File(javaHome, "src.zip");
        if (jdkSourceZip.isFile()) {
            this.sourcePath.add(new DocPathEntry(jdkSourceZip, ""));
        } else {
            File javaHomeParent = javaHome.getParentFile();
            jdkSourceZip = new File(javaHomeParent, "src.zip");
            if (jdkSourceZip.exists()) {
                this.sourcePath.add(new DocPathEntry(jdkSourceZip, ""));
            } else {
                jdkSourceZip = new File(javaHome, "src.jar");
                if (jdkSourceZip.exists()) {
                    this.sourcePath.add(new DocPathEntry(jdkSourceZip, "src"));
                }
            }
        }
        String jdkSourcePath = Config.getPropString(JDK_SOURCE_PATH_PROPERTY, null);
        if (jdkSourcePath != null) {
            this.sourcePath.add(new DocPathEntry(new File(jdkSourcePath), ""));
        }
        this.projectDir = projectDir;
        this.libraryUrls = this.getLibrariesClasspath();
        this.inspectors = new HashMap<Object, Inspector>();
        this.packages = new TreeMap<String, Package>();
        this.docuGenerator = new DocuGenerator(this);
        this.unnamedPackage = new Package(this);
        Properties props = this.unnamedPackage.getLastSavedProperties();
        this.setProjectProperties(props);
        this.packages.put("", this.unnamedPackage);
        new JFXPanel();
        Platform.setImplicitExit((boolean)false);
        this.shelfStorage = new FrameShelfStorage(this.projectDir);
        Platform.runLater(() -> this.createNewFXTabbedEditor());
        this.getPackage("").refreshPackage();
        this.debugger = Debugger.getDebuggerImpl(this.getProjectDir(), this.getTerminal());
        this.debugger.setUserLibraries(this.libraryUrls.toArray(new URL[this.libraryUrls.size()]));
        this.debugger.newClassLoader(this.getClassLoader());
        this.debugger.addDebuggerListener(this);
        this.debugger.launch();
        File ccfFile = new File(projectDir.getAbsoluteFile(), "team.defs");
        this.isSharedProject = Optional.of(ccfFile.isFile());
        this.isDVCS = false;
        if (this.isSharedProject.get().booleanValue()) {
            TeamSettingsController tsc = new TeamSettingsController(this);
            this.isSharedProject = Optional.of(TeamSettingsController.isValidVCSfound(projectDir));
            if (this.isSharedProject.get().booleanValue()) {
                this.isDVCS = tsc.isDVCS();
            }
        }
        this.teamActions = new TeamActionGroup(this.isSharedProject.get(), this.isDVCS);
    }

    @OnThread(value=Tag.Any)
    public static boolean isProject(String projectPath) {
        File startingDir;
        try {
            startingDir = Project.pathIntoStartingDirectory(projectPath);
        }
        catch (IOException ioe) {
            return false;
        }
        if (startingDir == null) {
            return false;
        }
        return Package.isPackage(startingDir);
    }

    public static Project openProject(String projectPath) {
        Project proj;
        File projectDir;
        String startingPackageName;
        File startingDir;
        try {
            startingDir = Project.pathIntoStartingDirectory(projectPath);
        }
        catch (IOException ioe) {
            Debug.message("could not resolve directory " + projectPath);
            return null;
        }
        if (startingDir == null) {
            return null;
        }
        if (Package.isPackage(startingDir)) {
            File lastDir = null;
            startingPackageName = "";
            for (File curDir = startingDir; curDir != null && Package.isPackage(curDir); curDir = curDir.getParentFile()) {
                if (lastDir != null) {
                    String lastdirName = lastDir.getName();
                    if (!JavaNames.isIdentifier(lastdirName)) break;
                    startingPackageName = "." + lastdirName + startingPackageName;
                }
                lastDir = curDir;
            }
            if (startingPackageName.length() > 0 && startingPackageName.charAt(0) == '.') {
                startingPackageName = startingPackageName.substring(1);
            }
            if ((projectDir = lastDir) == null) {
                projectDir = startingDir;
            }
        } else {
            return null;
        }
        boolean readOnly = false;
        if (Config.isModernWinOS()) {
            FileUtility.WriteCapabilities capabilities = FileUtility.getVistaWriteCapabilities(projectDir);
            switch (capabilities) {
                case VIRTUALIZED_WRITE: {
                    Utility.bringToFront(null);
                    Platform.runLater(() -> DialogManager.showMessageFX(null, "project-is-virtualized"));
                    break;
                }
                case READ_ONLY: {
                    readOnly = true;
                    break;
                }
                case NORMAL_WRITE: {
                    break;
                }
            }
        } else if (!projectDir.canWrite()) {
            readOnly = true;
        }
        String greenfootStartupProjectDir = new File(Config.getBlueJLibDir(), "greenfoot/startupProject").getAbsolutePath();
        boolean isGreenfootStartupProject = greenfootStartupProjectDir.equals(projectDir.getAbsolutePath());
        if (readOnly && !isGreenfootStartupProject) {
            Utility.bringToFront(null);
            SecondaryLoop loop = Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
            AtomicReference<File> projDir = new AtomicReference<File>(projectDir);
            Platform.runLater(() -> {
                DialogManager.showMessageFX(null, "project-is-readonly", new String[]{((File)projDir.get()).toString()});
                boolean done = false;
                while (!done) {
                    File newName = FileUtility.getSaveProjectFX(null, Config.getString("pkgmgr.saveAs.title"));
                    if (newName != null) {
                        int result = FileUtility.copyDirectory((File)projDir.get(), newName);
                        switch (result) {
                            case 0: {
                                projDir.set(newName);
                                done = true;
                                break;
                            }
                            case 4: {
                                DialogManager.showErrorFX(null, "directory-exists-file");
                                break;
                            }
                            case 5: {
                                DialogManager.showErrorFX(null, "directory-exists-non-empty");
                                break;
                            }
                            case 2: 
                            case 3: {
                                DialogManager.showErrorFX(null, "cannot-save-project");
                            }
                        }
                        continue;
                    }
                    done = true;
                }
                loop.exit();
            });
            loop.enter();
            projectDir = projDir.get();
        }
        if ((proj = projects.get(projectDir)) == null) {
            try {
                proj = new Project(projectDir);
                if (proj.isTeamProject() && !proj.getTeamSettingsController().isDVCS() && proj.getTeamSettingsController().getWorkingCopyVersion() != 1.6) {
                    Platform.runLater(() -> DialogManager.showMessageFX(null, "SVNWorkingCopyNot16"));
                }
                projects.put(projectDir, proj);
            }
            catch (IOException ioe) {
                return null;
            }
        }
        if (startingPackageName.equals("")) {
            Package sub;
            Package startingPackage = proj.getPackage("");
            while (startingPackage != null && (sub = startingPackage.getBoringSubPackage()) != null) {
                startingPackage = sub;
            }
            proj.initialPackageName = startingPackage.getQualifiedName();
        } else {
            proj.initialPackageName = startingPackageName;
        }
        ExtensionsManager.getInstance().projectOpening(proj);
        DataCollector.projectOpened(proj, ExtensionsManager.getInstance().getLoadedExtensions(proj));
        proj.getImportScanner().startScanning();
        return proj;
    }

    public static void cleanUp(Project project) {
        DataCollector.projectClosed(project);
        if (project.hasExecControls()) {
            project.getExecControls().hide();
        }
        if (project.terminal != null) {
            project.terminal.cleanup();
            project.terminal.dispose();
        }
        if (project.statusFrame != null) {
            project.statusFrame.dispose();
        }
        Platform.runLater(() -> project.removeAllInspectors());
        project.getDebugger().removeDebuggerListener(project);
        project.getDebugger().close(false);
        PrefMgr.addRecentProject(project.getProjectDir().getAbsolutePath());
        projects.remove(project.getProjectDir());
    }

    @OnThread(value=Tag.Any)
    public static boolean createNewProject(String projectPath) {
        if (projectPath != null) {
            File dir = new File(projectPath);
            if (dir.exists() && (!dir.isDirectory() || dir.list().length > 0)) {
                return false;
            }
            if (dir.exists() || dir.mkdir()) {
                File newreadmeFile = new File(dir, "README.TXT");
                PackageFile pkgFile = PackageFileFactory.getPackageFile(dir);
                try {
                    if (pkgFile.create()) {
                        Properties props = new Properties();
                        if (Config.isGreenfoot()) {
                            props.put("mainWindow.width", "850");
                            props.put("mainWindow.height", "600");
                            props.put("mainWindow.x", "40");
                            props.put("mainWindow.y", "40");
                        }
                        props.put(PROJECT_CHARSET_PROP, "UTF-8");
                        try {
                            pkgFile.save(props);
                            FileUtility.copyFile(Config.getTemplateFile("readme"), newreadmeFile);
                            return true;
                        }
                        catch (IOException ioe) {
                            Debug.message("I/O error while creating project.");
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        Debug.message("Unable to create project directory: " + projectPath);
        return false;
    }

    public static int getOpenProjectCount() {
        return projects.size();
    }

    public static Collection<Project> getProjects() {
        return projects.values();
    }

    public static Project getProject(File projectKey) {
        return projects.get(projectKey);
    }

    @OnThread(value=Tag.Any)
    private static File pathIntoStartingDirectory(String projectPath) throws IOException {
        File startingDir = new File(projectPath).getCanonicalFile();
        if (startingDir.isDirectory()) {
            return startingDir;
        }
        if (startingDir.isFile() && Package.isPackageFileName(startingDir.getName())) {
            return startingDir.getParentFile();
        }
        return null;
    }

    @OnThread(value=Tag.Any)
    private static final void attemptAddLibrary(List<URL> risul, File aFile) {
        if (aFile == null) {
            return;
        }
        if (!aFile.isFile() || !aFile.canRead()) {
            return;
        }
        String libname = aFile.getName().toLowerCase();
        if (!libname.endsWith(".jar") && !libname.endsWith(".zip")) {
            return;
        }
        try {
            risul.add(aFile.toURI().toURL());
        }
        catch (MalformedURLException mue) {
            Debug.reportError("Project.attemptAddLibrary() malformaed file=" + aFile);
        }
    }

    @OnThread(value=Tag.Any)
    public static final List<URL> getUserlibContent() {
        ArrayList<URL> risul = new ArrayList<URL>();
        String userLibSetting = Config.getPropString("bluej.userlibLocation", null);
        File userLibDir = userLibSetting == null ? new File(Boot.getBluejLibDir(), "userlib") : new File(userLibSetting);
        File[] files = userLibDir.listFiles();
        if (files == null) {
            return risul;
        }
        for (int index = 0; index < files.length; ++index) {
            Project.attemptAddLibrary(risul, files[index]);
        }
        return risul;
    }

    public synchronized Charset getProjectCharset() {
        return this.characterSet;
    }

    @OnThread(value=Tag.Any)
    public synchronized Properties getProjectProperties() {
        Properties p = new Properties();
        p.put(PROJECT_CHARSET_PROP, this.characterSet.name());
        return p;
    }

    private synchronized void setProjectProperties(Properties props) {
        String charsetName = props.getProperty(PROJECT_CHARSET_PROP);
        if (charsetName != null) {
            try {
                this.characterSet = Charset.forName(charsetName);
            }
            catch (IllegalCharsetNameException icne) {
                Debug.log("Illegal project character set name: " + charsetName);
            }
            catch (UnsupportedCharsetException ucse) {
                Debug.log("Unsupported project character set: " + charsetName);
            }
        }
        if (this.characterSet == null) {
            this.characterSet = Charset.defaultCharset();
            props.put(PROJECT_CHARSET_PROP, this.characterSet.name());
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void updateInspector(Inspector inspector) {
        inspector.update();
        inspector.show();
        inspector.bringToFront();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public ObjectInspector getInspectorInstance(DebuggerObject obj, String name, Package pkg, InvokerRecord ir, Window parent, Node animateFromCentre) {
        ObjectInspector inspector = (ObjectInspector)this.inspectors.get(obj);
        if (inspector == null) {
            inspector = new ObjectInspector(obj, this, name, pkg, ir, parent);
            this.inspectors.put(obj, inspector);
            if (animateFromCentre != null) {
                this.animateInspector(animateFromCentre, inspector, true);
            }
            inspector.show();
        } else {
            this.updateInspector(inspector);
        }
        if (!Config.isGreenfoot() && pkg != null) {
            ObjectInspector inspectorFinal = inspector;
            SwingUtilities.invokeLater(() -> {
                String benchName = null;
                PkgMgrFrame pmf = PkgMgrFrame.findFrame(pkg);
                if (pmf != null) {
                    for (ObjectWrapper ow : PkgMgrFrame.findFrame(pkg).getObjectBench().getObjects()) {
                        if (!ow.getObject().equals(obj)) continue;
                        benchName = ow.getName();
                    }
                }
                DataCollector.inspectorObjectShow(pkg, inspectorFinal, benchName, obj.getClassName(), name);
            });
        }
        return inspector;
    }

    @OnThread(value=Tag.FX)
    private void animateInspector(Node animateFromCentre, Inspector inspector, boolean fromBottom) {
        Parent root = inspector.getScene().getRoot();
        root.applyCss();
        root.layout();
        root.setScaleX(0.0);
        root.setScaleY(0.0);
        ScaleTransition t = new ScaleTransition(Duration.millis((double)600.0), (Node)root);
        t.setInterpolator(Interpolator.EASE_OUT);
        t.setToX(1.0);
        t.setToY(1.0);
        root.translateXProperty().bind((ObservableValue)inspector.getScene().widthProperty().multiply((ObservableNumberValue)root.scaleXProperty().multiply(0.5).add(-0.5)));
        if (fromBottom) {
            root.translateYProperty().bind((ObservableValue)inspector.getScene().heightProperty().multiply((ObservableNumberValue)root.scaleYProperty().multiply(-0.5).add(0.5)));
        } else {
            root.translateYProperty().bind((ObservableValue)inspector.getScene().heightProperty().multiply((ObservableNumberValue)root.scaleYProperty().multiply(0.5).add(-0.5)));
        }
        Scene afcScene = animateFromCentre.getScene();
        Point2D windowCoord = new Point2D(afcScene.getWindow().getX(), afcScene.getWindow().getY());
        Point2D sceneCoord = new Point2D(afcScene.getX(), afcScene.getY());
        Point2D nodeCoord = animateFromCentre.localToScene(animateFromCentre.getBoundsInLocal().getWidth() / 2.0, animateFromCentre.getBoundsInLocal().getHeight() / 2.0);
        inspector.setX(windowCoord.getX() + sceneCoord.getX() + nodeCoord.getX());
        inspector.setY(windowCoord.getY() + sceneCoord.getY() + nodeCoord.getY() + (fromBottom ? -root.prefHeight(-1.0) : 0.0));
        t.play();
    }

    @OnThread(value=Tag.FXPlatform)
    public Inspector getInspector(Object obj) {
        return this.inspectors.get(obj);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void removeInspector(DebuggerObject obj) {
        Inspector inspector = this.inspectors.remove(obj);
        SwingUtilities.invokeLater(() -> DataCollector.inspectorHide(this, inspector));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void removeInspector(DebuggerClass cls) {
        Inspector inspector = this.inspectors.remove(cls.getName());
        SwingUtilities.invokeLater(() -> DataCollector.inspectorHide(this, inspector));
    }

    @OnThread(value=Tag.FXPlatform)
    public void removeInspectorInstance(Object obj) {
        Inspector inspect = this.getInspector(obj);
        if (inspect != null) {
            inspect.doClose(false);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void removeAllInspectors() {
        for (Inspector inspector : this.inspectors.values()) {
            inspector.hide();
            SwingUtilities.invokeLater(() -> DataCollector.inspectorHide(this, inspector));
        }
        this.inspectors.clear();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public ClassInspector getClassInspectorInstance(DebuggerClass clss, Package pkg, Window parent, Node animateFromCentre) {
        ClassInspector inspector = (ClassInspector)this.inspectors.get(clss.getName());
        if (inspector == null) {
            ClassInspectInvokerRecord ir = new ClassInspectInvokerRecord(clss.getName());
            inspector = new ClassInspector(clss, this, pkg, ir, parent);
            this.inspectors.put(clss.getName(), inspector);
            if (animateFromCentre != null) {
                this.animateInspector(animateFromCentre, inspector, false);
            }
            inspector.show();
        } else {
            this.updateInspector(inspector);
        }
        ClassInspector inspectorFinal = inspector;
        SwingUtilities.invokeLater(() -> DataCollector.inspectorClassShow(pkg, inspectorFinal, clss.getName()));
        return inspector;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public ResultInspector getResultInspectorInstance(DebuggerObject obj, String name, Package pkg, InvokerRecord ir, ExpressionInformation info, Window parent) {
        ResultInspector inspector = new ResultInspector(obj, this, name, pkg, ir, info);
        this.inspectors.put(obj, inspector);
        inspector.initOwner(parent);
        inspector.centerOnOwner();
        inspector.show();
        inspector.bringToFront();
        return inspector;
    }

    @OnThread(value=Tag.FXPlatform)
    public void updateInspectors() {
        for (Inspector inspector : this.inspectors.values()) {
            inspector.update();
        }
    }

    @OnThread(value=Tag.Any)
    public String getProjectName() {
        return this.projectDir.getName();
    }

    @OnThread(value=Tag.Any)
    public File getProjectDir() {
        return this.projectDir;
    }

    public List<DocPathEntry> getSourcePath() {
        return this.sourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository() {
        boolean shared;
        Project project = this;
        synchronized (project) {
            shared = this.isSharedProject.orElse(false);
        }
        if (shared) {
            return this.getTeamSettingsController().getRepository(true);
        }
        return null;
    }

    @OnThread(value=Tag.Any)
    public String getUniqueId() {
        return String.valueOf(new String("BJID" + this.getProjectDir().getPath()).hashCode());
    }

    public String getInitialPackageName() {
        return this.initialPackageName;
    }

    @OnThread(value=Tag.Any)
    public Package getUnnamedPackage() {
        return this.unnamedPackage;
    }

    public Package getPackage(String qualifiedName) {
        Package existing = this.packages.get(qualifiedName);
        if (existing != null) {
            return existing;
        }
        if (qualifiedName.length() > 0) {
            Package pkg;
            try {
                Package parent = this.getPackage(JavaNames.getPrefix(qualifiedName));
                if (parent != null) {
                    pkg = new Package(this, JavaNames.getBase(qualifiedName), parent);
                    this.packages.put(qualifiedName, pkg);
                    pkg.refreshPackage();
                } else {
                    pkg = null;
                }
            }
            catch (IOException exc) {
                pkg = null;
            }
            return pkg;
        }
        throw new IllegalStateException("Project.getPackage()");
    }

    public final synchronized BProject getBProject() {
        if (this.singleBProject == null) {
            this.singleBProject = ExtensionBridge.newBProject((Project)this);
        }
        return this.singleBProject;
    }

    public Package getCachedPackage(String qualifiedName) {
        return this.packages.get(qualifiedName);
    }

    public void createPackageDirectory(String fullName) {
        StringTokenizer st = new StringTokenizer(fullName, ".");
        File newPkgDir = this.getProjectDir();
        while (st.hasMoreTokens()) {
            newPkgDir = new File(newPkgDir, st.nextToken());
        }
        if (newPkgDir.isDirectory() || newPkgDir.mkdirs()) {
            st = new StringTokenizer(fullName, ".");
            newPkgDir = this.getProjectDir();
            PackageFile pkgFile = PackageFileFactory.getPackageFile(newPkgDir);
            try {
                pkgFile.create();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            while (st.hasMoreTokens()) {
                newPkgDir = new File(newPkgDir, st.nextToken());
                this.prepareCreateDir(newPkgDir);
                pkgFile = PackageFileFactory.getPackageFile(newPkgDir);
                try {
                    pkgFile.create();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    public int newPackage(String qualifiedName) {
        if (qualifiedName == null) {
            return 2;
        }
        Package existing = this.packages.get(qualifiedName);
        if (existing != null) {
            return 1;
        }
        if (qualifiedName.length() < 1) {
            return 2;
        }
        try {
            Package parent = this.getPackage(JavaNames.getPrefix(qualifiedName));
            if (parent == null) {
                return 3;
            }
            this.createPackageDirectory(qualifiedName);
            Package pkg = new Package(this, JavaNames.getBase(qualifiedName), parent);
            this.packages.put(qualifiedName, pkg);
            pkg.refreshPackage();
        }
        catch (IOException exc) {
            return 2;
        }
        return 0;
    }

    private List<String> getPackageNames(Package rootPackage) {
        LinkedList<String> l = new LinkedList<String>();
        l.add(rootPackage.getQualifiedName());
        rootPackage.getChildren(true).forEach(p -> l.addAll(this.getPackageNames((Package)p)));
        return l;
    }

    public List<String> getPackageNames() {
        return this.getPackageNames(this.getPackage(""));
    }

    public String generateDocumentation() {
        return this.docuGenerator.generateProjectDocu();
    }

    public String getDocumentationFile(String filename) {
        return this.docuGenerator.getDocuPath(filename);
    }

    public void generateDocumentation(String filename) {
        this.docuGenerator.generateClassDocu(filename);
    }

    public void saveAll() {
        PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(this);
        if (frames == null) {
            return;
        }
        for (PkgMgrFrame frame : frames) {
            Platform.runLater(() -> frame.doSave());
            frame.setStatus(Config.getString("pkgmgr.packageSaved"));
        }
    }

    public void saveAllEditors() throws IOException {
        Iterator<Package> i = this.packages.values().iterator();
        IOException exception = null;
        while (i.hasNext()) {
            Package pkg = i.next();
            try {
                pkg.saveFilesInEditors();
            }
            catch (IOException ioe) {
                exception = ioe;
                Debug.reportError("Error while trying to save editor file:", ioe);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void reloadAll() {
        this.packages.values().forEach(Package::reload);
    }

    public void clearAllSelections() {
        this.packages.values().stream().map(Package::getEditor).forEach(PackageEditor::clearSelection);
    }

    public void selectTargetsInGraphs(List<Target> targets) {
        for (Target target : targets) {
            if (target == null) continue;
            PackageEditor packageEditor = target.getPackage().getEditor();
            Platform.runLater(() -> {
                packageEditor.addToSelection(target);
                packageEditor.repaint();
            });
        }
    }

    public Target getTarget(String targetId) {
        Package p;
        String packageName = "";
        int index = targetId.lastIndexOf(46);
        if (index > 0) {
            packageName = targetId.substring(0, index);
            targetId = targetId.substring(index + 1);
        }
        if ((p = this.getPackage(packageName)) == null) {
            return null;
        }
        Target target = p.getTarget(targetId);
        return target;
    }

    public void openEditorsForSelectedTargets() {
        List<Target> selectedTargets = this.getSelectedTargets();
        for (Target target : selectedTargets) {
            ClassTarget classTarget;
            Editor editor;
            if (!(target instanceof ClassTarget) || (editor = (classTarget = (ClassTarget)target).getEditor()) == null) continue;
            editor.setVisible(true);
        }
    }

    private List<Target> getSelectedTargets() {
        LinkedList<Target> selectedTargets = new LinkedList<Target>();
        List<String> packageNames = this.getPackageNames();
        for (String packageName : packageNames) {
            Package p = this.getPackage(packageName);
            selectedTargets.addAll(p.getSelectedTargets());
        }
        return selectedTargets;
    }

    public void restartVM() {
        this.getDebugger().close(true);
        this.vmClosed();
        PkgMgrFrame.displayMessage(this, Config.getString("pkgmgr.creatingVM"));
    }

    private void vmReady() {
        BlueJEvent.raiseEvent(2, null);
        this.packages.values().forEach(Package::reInitBreakpoints);
        PkgMgrFrame frame = PkgMgrFrame.findFrame(this.getUnnamedPackage());
        if (frame != null) {
            frame.bringToFront();
        }
    }

    private void vmClosed() {
        this.removeClassLoader();
        this.newRemoteClassLoader();
        this.libraryUrls = this.getLibrariesClasspath();
        this.debugger.setUserLibraries(this.libraryUrls.toArray(new URL[this.libraryUrls.size()]));
    }

    public void removeClassLoader() {
        if (this.currentClassLoader == null) {
            return;
        }
        this.clearObjectBenches();
        Platform.runLater(() -> this.removeAllInspectors());
        View.removeAll(this.currentClassLoader);
        if (!Config.isGreenfoot()) {
            new Thread(){

                @Override
                public void run() {
                    Project.this.getDebugger().disposeWindows();
                }
            }.start();
        }
        this.currentClassLoader = null;
    }

    public void clearObjectBenches() {
        PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(this);
        if (frames != null) {
            for (PkgMgrFrame frame : frames) {
                ObjectBench bench = frame.getObjectBench();
                Platform.runLater(() -> {
                    bench.removeAllObjects(this.getUniqueId());
                    frame.clearTextEval();
                });
            }
        }
    }

    public void newRemoteClassLoader() {
        this.getDebugger().newClassLoader(this.getClassLoader());
    }

    public void newRemoteClassLoaderLeavingBreakpoints() {
        this.getDebugger().newClassLoader(this.getClassLoader());
        this.packages.values().forEach(Package::reInitBreakpoints);
    }

    @OnThread(value=Tag.Any)
    public Debugger getDebugger() {
        return this.debugger;
    }

    public boolean hasExecControls() {
        return this.execControls != null;
    }

    public ExecControls getExecControls() {
        if (this.execControls == null) {
            this.execControls = new ExecControls(this, this.getDebugger());
        }
        return this.execControls;
    }

    public boolean hasTerminal() {
        return this.terminal != null;
    }

    public Terminal getTerminal() {
        if (this.terminal == null) {
            this.terminal = new Terminal(this);
        }
        return this.terminal;
    }

    public Class<?> loadClass(String className) {
        try {
            return this.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (SecurityException se) {
            return null;
        }
        catch (LinkageError le) {
            return null;
        }
    }

    @Override
    @OnThread(value=Tag.Any, ignoreParent=true)
    public synchronized @OnThread(value=Tag.Any, ignoreParent=true) boolean inTestMode() {
        return this.inTestMode;
    }

    public synchronized void setTestMode(boolean mode) {
        this.inTestMode = mode;
    }

    @OnThread(value=Tag.Any)
    protected List<URL> getPlusLibsContent() {
        ArrayList<URL> risul = new ArrayList<URL>();
        File libsDirectory = new File(this.projectDir, projectLibDirName);
        if (!libsDirectory.isDirectory() || !libsDirectory.canRead()) {
            return risul;
        }
        File[] libs = libsDirectory.listFiles();
        if (libs == null || libs.length < 1) {
            return risul;
        }
        for (int index = 0; index < libs.length; ++index) {
            Project.attemptAddLibrary(risul, libs[index]);
        }
        return risul;
    }

    public BPClassLoader getClassLoader() {
        if (this.currentClassLoader != null) {
            return this.currentClassLoader;
        }
        ArrayList<URL> pathList = new ArrayList<URL>();
        try {
            Collections.addAll(pathList, Boot.getInstance().getRuntimeUserClassPath());
            pathList.addAll(this.libraryUrls);
            pathList.add(this.getProjectDir().toURI().toURL());
        }
        catch (Exception exc) {
            Debug.reportError("Project.getClassLoader() exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        URL[] newUrls = pathList.toArray(new URL[pathList.size()]);
        this.currentClassLoader = new BPClassLoader(newUrls, Boot.getInstance().getBootClassLoader());
        return this.currentClassLoader;
    }

    private List<URL> getLibrariesClasspath() {
        ArrayList<URL> pathList = new ArrayList<URL>();
        pathList.addAll(ClassMgrPrefPanel.getUserConfigContent());
        pathList.addAll(Project.getUserlibContent());
        pathList.addAll(this.getPlusLibsContent());
        return pathList;
    }

    public EntityResolver getEntityResolver() {
        return new ProjectEntityResolver(this);
    }

    @OnThread(value=Tag.Any)
    public JavadocResolver getJavadocResolver() {
        return this.javadocResolver;
    }

    public String convertPathToPackageName(String pathname) {
        return JavaNames.convertFileToQualifiedName(this.getProjectDir(), new File(pathname));
    }

    public void removeStepMarks() {
        this.packages.values().forEach(Package::removeStepMarks);
    }

    @Override
    @OnThread(value=Tag.Any)
    public void processDebuggerEvent(final DebuggerEvent event, boolean skipUpdate) {
        if (skipUpdate) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (event.getID() == 1) {
                    PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(Project.this);
                    if (frames == null) {
                        return;
                    }
                    int newState = event.getNewState();
                    int oldState = event.getOldState();
                    for (int i = 0; i < frames.length; ++i) {
                        frames[i].setDebuggerState(newState);
                    }
                    if (oldState == 1 && newState == 2) {
                        Project.this.vmReady();
                    }
                    if (oldState == 2 && newState == 1) {
                        Project.this.removeStepMarks();
                        Project.this.vmClosed();
                    }
                    if (newState == 5) {
                        BlueJEvent.raiseEvent(1, null);
                    }
                    return;
                }
                DebuggerThread thr = event.getThread();
                if (thr == null) {
                    return;
                }
                String packageName = JavaNames.getPrefix(thr.getClass(0));
                Package pkg = Project.this.getPackage(packageName);
                if (pkg != null) {
                    switch (event.getID()) {
                        case 5: {
                            pkg.hitBreakpoint(thr);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            pkg.hitHalt(thr);
                        }
                    }
                }
                switch (event.getID()) {
                    case 2: {
                        DataCollector.debuggerHalt(Project.this, thr.getName(), ExecControls.getFilteredStack(thr.getStack()));
                        break;
                    }
                    case 4: {
                        DataCollector.debuggerStepInto(Project.this, thr.getName(), ExecControls.getFilteredStack(thr.getStack()));
                        break;
                    }
                    case 3: {
                        DataCollector.debuggerStepOver(Project.this, thr.getName(), ExecControls.getFilteredStack(thr.getStack()));
                        break;
                    }
                    case 5: {
                        DataCollector.debuggerHitBreakpoint(Project.this, thr.getName(), ExecControls.getFilteredStack(thr.getStack()));
                    }
                }
            }
        });
    }

    public void showSource(DebuggerThread thread, String className, String sourceName, int lineNumber) {
        String packageName = JavaNames.getPrefix(className);
        Package pkg = this.getPackage(packageName);
        if (pkg != null) {
            pkg.showSourcePosition(thread, sourceName, lineNumber);
        }
    }

    public String toString() {
        return "Project:" + this.getProjectName();
    }

    public void removePackage(String packageQualifiedName) {
        Package pkg = this.packages.get(packageQualifiedName);
        if (pkg != null) {
            pkg.getChildren(false).forEach(childPkg -> this.removePackage(childPkg.getQualifiedName()));
            this.packages.remove(packageQualifiedName);
        }
    }

    public TeamActionGroup getTeamActions() {
        return this.teamActions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public boolean isTeamProject() {
        Optional<Boolean> shared;
        Project project = this;
        synchronized (project) {
            shared = this.isSharedProject;
        }
        if (!shared.isPresent()) {
            File ccfFile = new File(this.projectDir.getAbsoluteFile(), "team.defs");
            if (ccfFile.isFile()) {
                return TeamSettingsController.isValidVCSfound(this.projectDir);
            }
            return false;
        }
        return shared.get();
    }

    public Set<File> getFilesInProject(boolean includePkgFiles, boolean includeDirs) {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        if (includeDirs) {
            files.add(this.projectDir);
        }
        this.traverseDirsForFiles(files, this.projectDir, includePkgFiles, includeDirs);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TeamSettingsController getTeamSettingsController() {
        boolean shared;
        Project project = this;
        synchronized (project) {
            shared = this.isSharedProject.orElse(false);
        }
        if (this.teamSettingsController == null && shared) {
            this.teamSettingsController = new TeamSettingsController(this);
        }
        return this.teamSettingsController;
    }

    public void setTeamSettingsController(TeamSettingsController tsc) {
        this.teamSettingsController = tsc;
        if (tsc != null) {
            tsc.setProject(this);
            tsc.writeToProject();
        }
        this.setProjectShared(tsc != null);
    }

    private void traverseDirsForFiles(Set<File> allFiles, File dir, boolean includePkgFiles, boolean includeDirs) {
        TeamSettingsController teamSettingsController = this.getTeamSettingsController();
        File[] files = dir.listFiles(teamSettingsController == null ? null : teamSettingsController.getFileFilter(includePkgFiles));
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                allFiles.add(files[i]);
                continue;
            }
            if (includeDirs) {
                allFiles.add(files[i]);
            }
            this.traverseDirsForFiles(allFiles, files[i], includePkgFiles, includeDirs);
        }
    }

    public TeamSettingsDialog getTeamSettingsDialog() {
        return this.getTeamSettingsController().getTeamSettingsDialog();
    }

    public CommitAndPushInterface getCommitCommentsDialog() {
        if (this.commitCommentsFrame == null) {
            this.commitCommentsFrame = this.teamSettingsController.isDVCS() ? new CommitAndPushFrame(this) : new CommitCommentsFrame(this);
        }
        return this.commitCommentsFrame;
    }

    public UpdateFilesFrame getUpdateDialog() {
        if (this.updateFilesFrame == null) {
            this.updateFilesFrame = new UpdateFilesFrame(this);
        }
        return this.updateFilesFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProjectShared(boolean shared) {
        Project project = this;
        synchronized (project) {
            this.isSharedProject = Optional.of(shared);
        }
        if (shared) {
            TeamSettingsController tsc = new TeamSettingsController(this);
            this.isDVCS = tsc.isDVCS();
        }
        this.teamActions.setTeamMode(PkgMgrFrame.findFrame(this.getUnnamedPackage()), shared, this.isDVCS);
        PkgMgrFrame[] frames = PkgMgrFrame.getAllProjectFrames(this);
        if (frames != null) {
            for (int i = 0; i < frames.length; ++i) {
                frames[i].updateSharedStatus(shared);
            }
        }
    }

    public String getPackageForFile(File f) {
        File projdir = this.getProjectDir();
        String packageName = "";
        File parentDir = f.getParentFile();
        while (!parentDir.equals(projdir)) {
            String parentName = parentDir.getName();
            if (!JavaNames.isIdentifier(parentName)) {
                return null;
            }
            packageName = packageName.equals("") ? parentName : parentName + "." + packageName;
            if ((parentDir = parentDir.getParentFile()) != null) continue;
            return null;
        }
        return packageName;
    }

    public StatusFrame getStatusWindow(FXPlatformSupplier<Window> parent) {
        if (this.statusFrame == null) {
            StatusFrame f = this.statusFrame = new StatusFrame(this);
            Platform.runLater(() -> f.setLocationRelativeTo((Window)parent.get()));
        }
        return this.statusFrame;
    }

    public boolean prepareDeleteDir(File dir) {
        TeamSettingsController tsc = this.getTeamSettingsController();
        if (tsc != null) {
            return tsc.prepareDeleteDir(dir);
        }
        return true;
    }

    public void prepareCreateDir(File dir) {
        TeamSettingsController tsc = this.getTeamSettingsController();
        if (tsc != null) {
            tsc.prepareCreateDir(dir);
        }
    }

    @OnThread(value=Tag.FX)
    public FXTabbedEditor getDefaultFXTabbedEditor() {
        return this.fXTabbedEditors.get(0);
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void setClosing(boolean closing) {
        this.closing = closing;
    }

    @OnThread(value=Tag.Any)
    public synchronized void scheduleCompilation(boolean immediate, CompileReason reason, CompileType type, Package pkg) {
        this.scheduleCompilation(immediate, reason, type, pkg, null);
    }

    @OnThread(value=Tag.Any)
    public synchronized void scheduleCompilation(boolean immediate, CompileReason reason, CompileType type, ClassTarget target) {
        this.scheduleCompilation(immediate, reason, type, null, target);
    }

    @OnThread(value=Tag.Any)
    private synchronized void scheduleCompilation(boolean immediate, CompileReason reason, CompileType type, Package pkg, ClassTarget target) {
        if (immediate) {
            if (this.compilerTimer != null) {
                if (pkg != null) {
                    this.scheduledPkgs.remove(pkg);
                }
                if (target != null) {
                    this.scheduledTargets.remove(target);
                }
                if (this.scheduledPkgs.isEmpty() && this.scheduledTargets.isEmpty()) {
                    this.compilerTimer.stop();
                }
            }
            if (pkg != null) {
                EventQueue.invokeLater(() -> pkg.compileOnceIdle(null, reason, type));
            } else if (target != null) {
                EventQueue.invokeLater(() -> target.getPackage().compileOnceIdle(target, reason, type));
            }
        } else {
            if (pkg != null) {
                this.scheduledPkgs.add(pkg);
            }
            if (target != null) {
                this.scheduledTargets.add(target);
            }
            this.latestCompileReason.set(reason);
            this.latestCompileType.set(type);
            if (this.compilerTimer != null) {
                this.compilerTimer.restart();
            } else {
                ActionListener listener = e -> {
                    Set<ClassTarget> targetsToCompile;
                    Set<Package> pkgsToCompile;
                    Iterator<ClassTarget> iterator = this;
                    synchronized (iterator) {
                        pkgsToCompile = this.scheduledPkgs;
                        this.scheduledPkgs = new HashSet<Package>();
                        targetsToCompile = this.scheduledTargets;
                        this.scheduledTargets = new HashSet<ClassTarget>();
                    }
                    for (Package p : pkgsToCompile) {
                        p.compileOnceIdle(null, this.latestCompileReason.get(), this.latestCompileType.get());
                    }
                    for (ClassTarget t : targetsToCompile) {
                        t.getPackage().compileOnceIdle(t, this.latestCompileReason.get(), this.latestCompileType.get());
                    }
                };
                this.compilerTimer = new Timer(1000, listener);
                this.compilerTimer.setRepeats(false);
                this.compilerTimer.start();
            }
        }
    }

    @OnThread(value=Tag.Any)
    public synchronized ImportScanner getImportScanner() {
        if (this.importScanner == null) {
            this.importScanner = new ImportScanner(this);
        }
        return this.importScanner;
    }

    @OnThread(value=Tag.FXPlatform)
    public FXTabbedEditor createNewFXTabbedEditor() {
        FXTabbedEditor ed = new FXTabbedEditor(this, this.recallFxPosition(this.fXTabbedEditors.size()));
        ed.initialise();
        this.fXTabbedEditors.add(ed);
        this.fXTabbedEditors.forEach(FXTabbedEditor::updateMoveMenus);
        return ed;
    }

    @OnThread(value=Tag.FX)
    public List<FXTabbedEditor> getAllFXTabbedEditorWindows() {
        return Collections.unmodifiableList(this.fXTabbedEditors);
    }

    @OnThread(value=Tag.FX)
    public void removeFXTabbedEditor(FXTabbedEditor fxTabbedEditor) {
        while (this.fxCachedEditorSizes.size() < this.fXTabbedEditors.size()) {
            this.fxCachedEditorSizes.add(0, null);
        }
        this.fxCachedEditorSizes.set(this.fXTabbedEditors.size() - 1, new Rectangle(fxTabbedEditor.getX(), fxTabbedEditor.getY(), fxTabbedEditor.getWidth(), fxTabbedEditor.getHeight()));
        if (this.fXTabbedEditors.size() > 1) {
            fxTabbedEditor.cleanup();
            this.fXTabbedEditors.remove(fxTabbedEditor);
        }
        this.fXTabbedEditors.forEach(FXTabbedEditor::updateMoveMenus);
    }

    @OnThread(value=Tag.FXPlatform)
    public void saveEditorLocations(Properties props) {
        int i;
        for (i = 0; i < this.fXTabbedEditors.size(); ++i) {
            this.saveEditorLocation(props, this.fXTabbedEditors.get(i), "editor.fx." + i);
        }
        for (i = this.fXTabbedEditors.size(); i < this.fxCachedEditorSizes.size(); ++i) {
            this.saveEditorLocation(props, this.fxCachedEditorSizes.get(i), "editor.fx." + i);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void saveEditorLocation(Properties props, FXTabbedEditor editor, String prefix) {
        props.put(prefix + ".x", String.valueOf(editor.getX()));
        props.put(prefix + ".y", String.valueOf(editor.getY()));
        props.put(prefix + ".width", String.valueOf(editor.getWidth()));
        props.put(prefix + ".height", String.valueOf(editor.getHeight()));
    }

    @OnThread(value=Tag.FXPlatform)
    private void saveEditorLocation(Properties props, Rectangle rect, String prefix) {
        if (rect == null) {
            return;
        }
        props.put(prefix + ".x", String.valueOf(rect.x));
        props.put(prefix + ".y", String.valueOf(rect.y));
        props.put(prefix + ".width", String.valueOf(rect.width));
        props.put(prefix + ".height", String.valueOf(rect.height));
    }

    public void setAllEditorStatus(String status) {
        Platform.runLater(() -> this.fXTabbedEditors.forEach(fte -> fte.setTitleStatus(status)));
    }

    @OnThread(value=Tag.Any)
    private Rectangle recallPosition(String prefix, List<Rectangle> cache, int index) {
        if (index < cache.size() && cache.get(index) != null) {
            return cache.get(index);
        }
        Properties props = this.unnamedPackage.getLastSavedProperties();
        prefix = prefix + "." + index;
        int x = Integer.parseInt(props.getProperty(prefix + ".x", "-1"));
        int y = Integer.parseInt(props.getProperty(prefix + ".y", "-1"));
        int width = Integer.parseInt(props.getProperty(prefix + ".width", "-1"));
        int height = Integer.parseInt(props.getProperty(prefix + ".height", "-1"));
        if (x >= 0 && y >= 0 && width > 100 && height > 100) {
            return new Rectangle(x, y, width, height);
        }
        return null;
    }

    @OnThread(value=Tag.FX)
    private Rectangle recallFxPosition(int index) {
        return this.recallPosition("editor.fx", this.fxCachedEditorSizes, index);
    }

    @OnThread(value=Tag.FX)
    public FrameShelfStorage getShelfStorage() {
        return this.shelfStorage;
    }
}

