/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.entity;

import bluej.debugger.gentype.Reflective;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.PackageEntity;
import bluej.parser.entity.PackageOrClass;
import bluej.parser.entity.TypeEntity;

public class ClassLoaderResolver
implements EntityResolver {
    private ClassLoader classLoader;

    public ClassLoaderResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public TypeEntity resolveQualifiedClass(String name) {
        try {
            Class<?> cl = this.classLoader.loadClass(name);
            return new TypeEntity(cl);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public PackageOrClass resolvePackageOrClass(String name, Reflective querySource) {
        return new PackageEntity(name, this);
    }

    @Override
    public JavaEntity getValueEntity(String name, Reflective querySource) {
        return this.resolvePackageOrClass(name, querySource);
    }
}

