/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.utility.Debug;
import java.io.Reader;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class DocumentReader
extends Reader {
    private Segment buffer = new Segment();
    private Document document;
    private int bufpos;
    private int docPosition;
    private int docLength;

    public DocumentReader(Document document) {
        this(document, 0);
    }

    public DocumentReader(Document document, int position) {
        this.buffer.setPartialReturn(true);
        this.document = document;
        this.docPosition = position;
        this.docLength = document.getLength();
        this.fillBuffer();
    }

    public DocumentReader(Document document, int position, int endpos) {
        this.buffer.setPartialReturn(true);
        this.document = document;
        this.docPosition = position;
        this.docLength = endpos;
        if (this.docLength > document.getLength()) {
            throw new IllegalArgumentException("Trying to construct DocumentReader to look up to " + endpos + " in a document of length: " + document.getLength());
        }
        this.fillBuffer();
    }

    @Override
    public void close() {
    }

    @Override
    public int read() {
        if (this.bufpos == this.buffer.getEndIndex()) {
            if (this.docPosition == this.docLength) {
                return -1;
            }
            this.fillBuffer();
        }
        return this.buffer.array[this.bufpos++];
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        int avail;
        int docAvail = Math.min(len, this.docLength - this.docPosition + this.buffer.getEndIndex() - this.bufpos);
        if (docAvail == 0) {
            return -1;
        }
        for (int remaining = len = Math.min(len, docAvail); remaining > 0; remaining -= avail) {
            avail = Math.min(this.buffer.getEndIndex() - this.bufpos, remaining);
            if (avail == 0) {
                this.fillBuffer();
                avail = Math.min(this.buffer.getEndIndex() - this.bufpos, remaining);
            }
            System.arraycopy(this.buffer.array, this.bufpos, cbuf, off, avail);
            off += avail;
            this.bufpos += avail;
        }
        return len;
    }

    private void fillBuffer() {
        int docAvail = this.docLength - this.docPosition;
        try {
            this.document.getText(this.docPosition, docAvail, this.buffer);
            this.docPosition += this.buffer.getEndIndex() - this.buffer.getBeginIndex();
            this.bufpos = this.buffer.getBeginIndex();
        }
        catch (BadLocationException e) {
            Debug.reportError("Len: " + this.docLength + " pos: " + this.docPosition + "Doc len: " + this.document.getLength(), e);
        }
    }
}

