/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.groupwork.Repository;
import bluej.groupwork.StatusHandle;
import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamViewFilter;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.UpdateFilter;
import bluej.groupwork.actions.UpdateAction;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.groupwork.ui.FileRenderer;
import bluej.pkgmgr.BlueJPackageFile;
import bluej.pkgmgr.Project;
import bluej.utility.DBox;
import bluej.utility.DBoxLayout;
import bluej.utility.DialogManager;
import bluej.utility.SwingWorker;
import bluej.utility.Utility;
import bluej.utility.javafx.SwingNodeDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import threadchecker.OnThread;
import threadchecker.Tag;

public class UpdateFilesFrame
extends SwingNodeDialog {
    private JList updateFiles;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private JButton updateButton;
    private JCheckBox includeLayoutCheckbox;
    private ActivityIndicator progressBar;
    private UpdateAction updateAction;
    private UpdateWorker updateWorker;
    private Project project;
    private Repository repository;
    private DefaultListModel updateListModel;
    private Set<TeamStatusInfo> changedLayoutFiles;
    private Set<File> forcedLayoutFiles;
    private boolean includeLayout = true;
    private static String noFilesToUpdate = Config.getString("team.noupdatefiles");
    private static String needUpdate = Config.getString("team.pullNeeded");
    private boolean pullWithNoChanges = false;

    public UpdateFilesFrame(Project proj) {
        this.project = proj;
        this.changedLayoutFiles = new HashSet<TeamStatusInfo>();
        this.forcedLayoutFiles = new HashSet<File>();
        this.createUI();
        DialogManager.centreDialog(this);
    }

    @Override
    public void setVisible(boolean show) {
        super.setVisible(show);
        if (show) {
            this.updateAction.setEnabled(false);
            this.includeLayoutCheckbox.setSelected(false);
            this.includeLayoutCheckbox.setEnabled(false);
            this.changedLayoutFiles.clear();
            this.forcedLayoutFiles.clear();
            this.updateListModel.removeAllElements();
            this.repository = this.project.getRepository();
            if (this.repository != null) {
                block5: {
                    try {
                        this.project.saveAllEditors();
                        this.project.saveAll();
                    }
                    catch (IOException ioe) {
                        String msg = DialogManager.getMessage("team-error-saving-project", new String[0]);
                        if (msg == null) break block5;
                        String msgFinal = msg = Utility.mergeStrings(msg, ioe.getLocalizedMessage());
                        Platform.runLater(() -> DialogManager.showErrorTextFX(this.asWindow(), msgFinal));
                    }
                }
                this.startProgress();
                this.updateWorker = new UpdateWorker();
                this.updateWorker.start();
            } else {
                super.setVisible(false);
            }
        }
    }

    protected void createUI() {
        this.setTitle(Config.getString("team.update.title"));
        this.updateListModel = new DefaultListModel();
        this.rememberPosition("bluej.updatedisplay");
        this.topPanel = new JPanel();
        JScrollPane updateFileScrollPane = new JScrollPane();
        this.topPanel.setLayout(new BorderLayout());
        JLabel updateFilesLabel = new JLabel(Config.getString("team.update.files"));
        updateFilesLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.topPanel.add((Component)updateFilesLabel, "North");
        this.updateFiles = new JList(this.updateListModel);
        if (this.project.getTeamSettingsController().isDVCS()) {
            this.updateFiles.setCellRenderer(new FileRenderer(this.project, true));
        } else {
            this.updateFiles.setCellRenderer(new FileRenderer(this.project));
        }
        this.updateFiles.setEnabled(false);
        updateFileScrollPane.setViewportView(this.updateFiles);
        this.topPanel.add((Component)updateFileScrollPane, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout());
        this.updateAction = new UpdateAction(this);
        this.updateButton = BlueJTheme.getOkButton();
        this.updateButton.setAction(this.updateAction);
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateFilesFrame.this.includeLayoutCheckbox.setEnabled(false);
            }
        });
        this.setDefaultButton(this.updateButton);
        JButton closeButton = BlueJTheme.getCancelButton();
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateFilesFrame.this.updateAction.cancel();
                UpdateFilesFrame.this.updateWorker.abort();
                UpdateFilesFrame.this.setVisible(false);
            }
        });
        Platform.runLater(() -> this.setCloseIsButton(closeButton));
        DBox buttonPanel = new DBox(DBoxLayout.X_AXIS, 0, 5, 0.5f);
        buttonPanel.setBorder(BlueJTheme.generalBorder);
        this.progressBar = new ActivityIndicator();
        this.progressBar.setRunning(false);
        DBox checkBoxPanel = new DBox(DBoxLayout.Y_AXIS, 0, 5, 0.5f);
        this.includeLayoutCheckbox = new JCheckBox(Config.getString("team.update.includelayout"));
        this.includeLayoutCheckbox.setEnabled(false);
        this.includeLayoutCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox layoutCheck = (JCheckBox)e.getSource();
                UpdateFilesFrame.this.includeLayout = layoutCheck.isSelected();
                UpdateFilesFrame.this.resetForcedFiles();
                if (UpdateFilesFrame.this.includeLayout) {
                    UpdateFilesFrame.this.addModifiedLayouts();
                    if (!UpdateFilesFrame.this.updateButton.isEnabled()) {
                        UpdateFilesFrame.this.updateAction.setEnabled(true);
                    }
                } else {
                    UpdateFilesFrame.this.removeModifiedLayouts();
                    if (UpdateFilesFrame.this.isUpdateListEmpty()) {
                        UpdateFilesFrame.this.updateAction.setEnabled(false);
                    }
                }
            }
        });
        checkBoxPanel.add(this.includeLayoutCheckbox);
        checkBoxPanel.add(buttonPanel);
        buttonPanel.add(this.progressBar);
        buttonPanel.add(this.updateButton);
        buttonPanel.add(closeButton);
        this.bottomPanel.add((Component)checkBoxPanel, "South");
        DBox mainPanel = new DBox(DBox.Y_AXIS, 0.5f);
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        mainPanel.add(this.topPanel);
        mainPanel.add(this.bottomPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
    }

    public void reset() {
        this.updateListModel.clear();
    }

    private void removeModifiedLayouts() {
        Iterator<TeamStatusInfo> it = this.changedLayoutFiles.iterator();
        while (it.hasNext()) {
            this.updateListModel.removeElement(it.next());
        }
        if (this.updateListModel.isEmpty()) {
            this.updateListModel.addElement(noFilesToUpdate);
        }
    }

    private boolean isUpdateListEmpty() {
        return this.updateListModel.isEmpty() || this.updateListModel.contains(noFilesToUpdate);
    }

    private void addModifiedLayouts() {
        if (this.updateListModel.contains(noFilesToUpdate)) {
            this.updateListModel.removeElement(noFilesToUpdate);
        }
    }

    public Set<File> getChangedLayoutFiles() {
        HashSet<File> files = new HashSet<File>();
        for (TeamStatusInfo info : this.changedLayoutFiles) {
            files.add(info.getFile());
        }
        return files;
    }

    public boolean includeLayout() {
        return this.includeLayoutCheckbox != null && this.includeLayoutCheckbox.isSelected();
    }

    public void startProgress() {
        this.progressBar.setRunning(true);
    }

    public void stopProgress() {
        this.progressBar.setRunning(false);
    }

    public Project getProject() {
        return this.project;
    }

    private void setLayoutChanged() {
        this.includeLayoutCheckbox.setEnabled(true);
        this.includeLayoutCheckbox.setSelected(this.includeLayout);
    }

    private void resetForcedFiles() {
        HashSet<File> forcedFiles = new HashSet<File>(this.forcedLayoutFiles);
        if (this.includeLayout) {
            for (TeamStatusInfo info : this.changedLayoutFiles) {
                forcedFiles.add(info.getFile());
            }
        }
        this.updateAction.setFilesToForceUpdate(forcedFiles);
    }

    class UpdateWorker
    extends SwingWorker
    implements StatusListener {
        List<TeamStatusInfo> response = new ArrayList<TeamStatusInfo>();
        TeamworkCommand command;
        TeamworkCommandResult result;
        private boolean aborted;
        private StatusHandle statusHandle;

        public UpdateWorker() {
            FileFilter filter = UpdateFilesFrame.this.project.getTeamSettingsController().getFileFilter(true);
            this.command = UpdateFilesFrame.this.repository.getStatus(this, filter, true);
        }

        @Override
        @OnThread(value=Tag.Any)
        public void gotStatus(TeamStatusInfo info) {
            this.response.add(info);
        }

        @Override
        @OnThread(value=Tag.Any)
        public void statusComplete(StatusHandle statusHandle) {
            UpdateFilesFrame.this.pullWithNoChanges = statusHandle.pullNeeded();
            this.statusHandle = statusHandle;
        }

        @Override
        @OnThread(value=Tag.Unique)
        public Object construct() {
            this.result = this.command.getResult();
            return this.response;
        }

        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        @Override
        public void finished() {
            UpdateFilesFrame.this.stopProgress();
            if (!this.aborted) {
                if (this.result.isError()) {
                    UpdateFilesFrame.this.dialogThenHide(() -> TeamUtils.handleServerResponseFX(this.result, UpdateFilesFrame.this.asWindow()));
                } else {
                    HashSet<File> filesToUpdate = new HashSet<File>();
                    HashSet<File> conflicts = new HashSet<File>();
                    HashSet<File> modifiedLayoutFiles = new HashSet<File>();
                    List<TeamStatusInfo> info = this.response;
                    this.getUpdateFileSet(info, filesToUpdate, conflicts, modifiedLayoutFiles);
                    if (conflicts.size() != 0) {
                        String filesList = "";
                        Iterator i = conflicts.iterator();
                        for (int j = 0; j < 10 && i.hasNext(); ++j) {
                            File conflictFile = (File)i.next();
                            filesList = filesList + "    " + conflictFile.getName() + "\n";
                        }
                        if (i.hasNext()) {
                            filesList = filesList + "    (and more - check status)";
                        }
                        String filesListFinal = filesList;
                        UpdateFilesFrame.this.dialogThenHide(() -> DialogManager.showMessageWithTextFX(UpdateFilesFrame.this.asWindow(), "team-unresolved-conflicts", filesListFinal));
                        return;
                    }
                    HashSet<File> updateFiles = new HashSet<File>();
                    for (File file : filesToUpdate) {
                        if (filesToUpdate.contains(file.getParentFile())) continue;
                        updateFiles.add(file);
                    }
                    Iterator i = UpdateFilesFrame.this.forcedLayoutFiles.iterator();
                    while (i.hasNext()) {
                        File file;
                        file = (File)i.next();
                        if (!filesToUpdate.contains(file.getParentFile())) continue;
                        i.remove();
                    }
                    UpdateFilesFrame.this.updateAction.setStatusHandle(this.statusHandle);
                    UpdateFilesFrame.this.updateAction.setFilesToUpdate(updateFiles);
                    UpdateFilesFrame.this.resetForcedFiles();
                    if (UpdateFilesFrame.this.includeLayout && !UpdateFilesFrame.this.changedLayoutFiles.isEmpty()) {
                        UpdateFilesFrame.this.addModifiedLayouts();
                    }
                    if (UpdateFilesFrame.this.updateListModel.isEmpty() && !UpdateFilesFrame.this.pullWithNoChanges) {
                        UpdateFilesFrame.this.updateListModel.addElement(noFilesToUpdate);
                    } else {
                        if (UpdateFilesFrame.this.project.getTeamSettingsController().isDVCS() && UpdateFilesFrame.this.pullWithNoChanges && UpdateFilesFrame.this.updateListModel.isEmpty()) {
                            UpdateFilesFrame.this.updateListModel.addElement(needUpdate);
                        }
                        UpdateFilesFrame.this.updateAction.setEnabled(true);
                    }
                }
            }
        }

        private void getUpdateFileSet(List<TeamStatusInfo> info, Set<File> filesToUpdate, Set<File> conflicts, Set<File> modifiedLayoutFiles) {
            UpdateFilter filter = new UpdateFilter();
            TeamViewFilter viewFilter = new TeamViewFilter();
            for (TeamStatusInfo statusInfo : info) {
                int status;
                int n = status = UpdateFilesFrame.this.project.getTeamSettingsController().isDVCS() ? statusInfo.getRemoteStatus() : statusInfo.getStatus();
                if (filter.accept(statusInfo)) {
                    if (!BlueJPackageFile.isPackageFileName(statusInfo.getFile().getName())) {
                        UpdateFilesFrame.this.updateListModel.addElement(statusInfo);
                        filesToUpdate.add(statusInfo.getFile());
                        continue;
                    }
                    if (!viewFilter.accept(statusInfo)) continue;
                    if (filter.updateAlways(statusInfo)) {
                        UpdateFilesFrame.this.updateListModel.addElement(statusInfo);
                        UpdateFilesFrame.this.forcedLayoutFiles.add(statusInfo.getFile());
                        continue;
                    }
                    modifiedLayoutFiles.add(statusInfo.getFile());
                    UpdateFilesFrame.this.changedLayoutFiles.add(statusInfo);
                    continue;
                }
                boolean conflict = status == 8;
                conflict |= status == 12;
                if (!(conflict |= status == 13)) continue;
                if (!BlueJPackageFile.isPackageFileName(statusInfo.getFile().getName())) {
                    conflicts.add(statusInfo.getFile());
                    continue;
                }
                modifiedLayoutFiles.add(statusInfo.getFile());
                UpdateFilesFrame.this.changedLayoutFiles.add(statusInfo);
            }
            if (!UpdateFilesFrame.this.changedLayoutFiles.isEmpty()) {
                UpdateFilesFrame.this.setLayoutChanged();
            }
        }
    }
}

