/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.groupwork.TeamStatusInfo;
import bluej.pkgmgr.Project;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class StatusMessageCellRenderer
extends DefaultTableCellRenderer {
    private static final Color UPTODATE = Color.BLACK;
    private static final Color NEEDSUPDATE;
    private static final Color NEEDSCHECKOUT;
    private static final Color REMOVED;
    private static final Color NEEDSMERGE;
    private static final Color NEEDSCOMMIT;
    private static final Color NEEDSADD;
    private static final Color DELETED;
    private static final Color CONFLICT;
    private static final int LOCAL = 0;
    private static final int REMOTE = 1;
    Project project;

    public StatusMessageCellRenderer(Project project) {
        this.project = project;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(jTable, object, isSelected, hasFocus, row, column);
        int remoteStatusColumn = this.getRemoteStatusColumnIndex(jTable);
        int status = this.getStatus(jTable, row, 0);
        int remoteStatus = this.getStatus(jTable, row, 1);
        this.setForeground(this.getStatusColour(status));
        String statusLabel = this.getStatusString(jTable, object, status, row, column);
        if (column == remoteStatusColumn) {
            statusLabel = this.getStatusString(jTable, object, remoteStatus, row, column);
        }
        this.setText(statusLabel);
        this.setForeground(this.getStatusColour(status));
        return this;
    }

    private int getStatus(JTable table, int row, int location) {
        int status = 0;
        int localStatusColumn = this.project.getTeamSettingsController().isDVCS() ? table.getColumnModel().getColumnIndex(Config.getString("team.status.status")) : table.getColumnModel().getColumnIndex(Config.getString("team.status"));
        int remoteStatusColumn = this.getRemoteStatusColumnIndex(table);
        Object val = location == 0 ? table.getModel().getValueAt(row, localStatusColumn) : table.getModel().getValueAt(row, remoteStatusColumn);
        if (val instanceof Integer) {
            status = (Integer)val;
        }
        return status;
    }

    private String getStatusString(JTable jtable, Object value, int statusValue, int row, int col) {
        String colName = jtable.getColumnName(col);
        if (colName.equals(Config.getString("team.status.resource")) || colName.equals(Config.getString("team.status.version"))) {
            return value.toString();
        }
        if (this.project.getTeamSettingsController().isDVCS()) {
            if (colName.equals(Config.getString("team.status.remoteStatus"))) {
                return TeamStatusInfo.getDCVSStatusString(statusValue, true);
            }
            return TeamStatusInfo.getDCVSStatusString(statusValue, false);
        }
        return TeamStatusInfo.getStatusString(statusValue);
    }

    private Color getStatusColour(int statusValue) {
        Color color = Color.BLACK;
        color = statusValue == 0 ? UPTODATE : (statusValue == 1 ? NEEDSCHECKOUT : (statusValue == 2 ? DELETED : (statusValue == 3 ? NEEDSUPDATE : (statusValue == 4 ? NEEDSCOMMIT : (statusValue == 5 ? NEEDSMERGE : (statusValue == 6 ? NEEDSADD : (statusValue == 7 ? REMOVED : CONFLICT)))))));
        return color;
    }

    private int getRemoteStatusColumnIndex(JTable jTable) {
        int result = -1;
        if (this.project.getTeamSettingsController().isDVCS()) {
            result = jTable.getColumnModel().getColumnIndex(Config.getString("team.status.remoteStatus"));
        }
        return result;
    }

    static {
        NEEDSCHECKOUT = NEEDSUPDATE = new Color(11, 57, 120);
        REMOVED = new Color(135, 150, 170);
        NEEDSMERGE = new Color(137, 13, 19);
        NEEDSADD = NEEDSCOMMIT = new Color(10, 85, 15);
        DELETED = new Color(122, 143, 123);
        CONFLICT = NEEDSMERGE;
    }
}

