/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.utility.SwingWorker;
import bluej.utility.javafx.FXPlatformSupplier;
import bluej.utility.javafx.SwingNodeDialog;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.stage.Window;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ModuleSelectDialog
extends SwingNodeDialog
implements ListSelectionListener {
    private Repository repository;
    private ActivityIndicator progressBar;
    private JTextField moduleField;
    private JButton okButton;
    private JList moduleList;
    private ModuleListerThread worker;
    private boolean wasOk;

    public ModuleSelectDialog(FXPlatformSupplier<Window> owner, Repository repository) {
        super(owner);
        this.setTitle(Config.getString("team.moduleselect.title"));
        this.setModal(true);
        this.repository = repository;
        this.buildUI();
        this.pack();
    }

    public String getModuleName() {
        if (this.wasOk) {
            return this.moduleField.getText();
        }
        return null;
    }

    private void startProgressBar() {
        this.progressBar.setRunning(true);
    }

    private void stopProgressBar() {
        this.progressBar.setRunning(false);
    }

    private void setModuleList(List<String> modules) {
        Object[] listData = modules.toArray();
        this.moduleList.setListData(listData);
    }

    private void buildUI() {
        JPanel contentPane = new JPanel();
        BoxLayout layout = new BoxLayout(contentPane, 1);
        contentPane.setLayout(layout);
        contentPane.setBorder(BlueJTheme.dialogBorder);
        this.setContentPane(contentPane);
        Box moduleBox = new Box(0);
        moduleBox.add(new JLabel(Config.getString("team.moduleselect.label")));
        moduleBox.add(Box.createHorizontalStrut(5));
        this.moduleField = new JTextField(20);
        this.moduleField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.resetOk();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.resetOk();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.resetOk();
            }

            public void resetOk() {
                ModuleSelectDialog.this.okButton.setEnabled(ModuleSelectDialog.this.moduleField.getText().length() != 0);
            }
        });
        moduleBox.add(this.moduleField);
        this.addXAligned(contentPane, moduleBox, 0.0f);
        contentPane.add(Box.createVerticalStrut(5));
        this.addXAligned(contentPane, new JSeparator(), 0.0f);
        contentPane.add(Box.createVerticalStrut(5));
        this.addXAligned(contentPane, new JLabel(Config.getString("team.moduleselect.available")), 0.0f);
        Box moduleListBox = new Box(0);
        this.moduleList = new JList();
        this.moduleList.setSelectionMode(0);
        this.moduleList.getSelectionModel().addListSelectionListener(this);
        this.moduleList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getButton() == 1 && e.getClickCount() == 2 && (index = ModuleSelectDialog.this.moduleList.locationToIndex(e.getPoint())) != -1) {
                    ModuleSelectDialog.this.wasOk = true;
                    ModuleSelectDialog.this.dispose();
                }
            }
        });
        this.moduleList.setAlignmentY(0.0f);
        JScrollPane moduleListSP = new JScrollPane(this.moduleList);
        moduleListSP.setAlignmentY(0.0f);
        moduleListBox.add(moduleListSP);
        moduleListBox.add(Box.createHorizontalStrut(5));
        final JButton listButton = new JButton(Config.getString("team.moduleselect.show"));
        listButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listButton.setEnabled(false);
                ModuleSelectDialog.this.startProgressBar();
                ModuleSelectDialog.this.worker = new ModuleListerThread();
                ModuleSelectDialog.this.worker.start();
            }
        });
        listButton.setAlignmentY(0.0f);
        moduleListBox.add(listButton);
        this.addXAligned(contentPane, moduleListBox, 0.0f);
        contentPane.add(Box.createVerticalStrut(17));
        Box buttonBox = new Box(0);
        this.progressBar = new ActivityIndicator();
        buttonBox.add(this.progressBar);
        buttonBox.add(Box.createHorizontalGlue());
        this.addXAligned(contentPane, buttonBox, 0.0f);
        buttonBox.add(Box.createHorizontalStrut(5));
        this.okButton = BlueJTheme.getOkButton();
        this.setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModuleSelectDialog.this.wasOk = true;
                ModuleSelectDialog.this.dispose();
            }
        });
        this.okButton.setEnabled(false);
        buttonBox.add(this.okButton);
        buttonBox.add(Box.createHorizontalStrut(5));
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ModuleSelectDialog.this.worker != null) {
                    ModuleSelectDialog.this.worker.cancel();
                }
                ModuleSelectDialog.this.dispose();
            }
        });
        buttonBox.add(cancelButton);
    }

    private void addXAligned(Container parent, JComponent child, float alignment) {
        child.setAlignmentX(alignment);
        parent.add(child);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int selected;
        if (!e.getValueIsAdjusting() && (selected = this.moduleList.getSelectedIndex()) != -1) {
            String module = this.moduleList.getModel().getElementAt(selected).toString();
            this.moduleField.setText(module);
        }
    }

    private class ModuleListerThread
    extends SwingWorker {
        private TeamworkCommand command;
        private TeamworkCommandResult result;
        private List<String> modules = new ArrayList<String>();

        public ModuleListerThread() {
            this.command = ModuleSelectDialog.this.repository.getModules(this.modules);
        }

        @Override
        @OnThread(value=Tag.Unique)
        public Object construct() {
            this.result = this.command.getResult();
            return this.result;
        }

        @Override
        public void finished() {
            ModuleSelectDialog.this.stopProgressBar();
            if (this.command != null) {
                if (this.result != null && !this.result.isError()) {
                    ModuleSelectDialog.this.setModuleList(this.modules);
                } else {
                    Platform.runLater(() -> TeamUtils.handleServerResponseFX(this.result, ModuleSelectDialog.this.asWindow()));
                }
            }
        }

        public void cancel() {
            if (this.command != null) {
                this.command.cancel();
                this.command = null;
            }
        }
    }
}

