/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.prefmgr.PrefMgr;
import java.awt.Dimension;
import java.awt.EventQueue;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.OverlayLayout;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ActivityIndicator
extends JComponent {
    private JProgressBar progressBar;
    private JLabel messageLabel;

    public ActivityIndicator() {
        this.setBorder(null);
        this.setLayout(new OverlayLayout(this));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(false);
        this.add(this.progressBar);
        this.messageLabel = new JLabel();
        this.messageLabel.setFont(PrefMgr.getStandardFont());
        this.messageLabel.setVisible(false);
        this.add(this.messageLabel);
    }

    @OnThread(value=Tag.Any)
    public void setRunning(boolean running) {
        EventQueue.invokeLater(() -> {
            this.messageLabel.setVisible(!running);
            this.progressBar.setVisible(running);
        });
    }

    @OnThread(value=Tag.Any)
    public void setMessage(String msg) {
        EventQueue.invokeLater(() -> {
            if (msg != null) {
                this.messageLabel.setText(msg);
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        return this.progressBar.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.progressBar.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.progressBar.getMaximumSize();
    }

    @Override
    public boolean isValidateRoot() {
        return true;
    }
}

