/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.svn;

import bluej.groupwork.LogHistoryListener;
import bluej.groupwork.Repository;
import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.svn.SvnCheckoutCommand;
import bluej.groupwork.svn.SvnCommand;
import bluej.groupwork.svn.SvnCommitAllCommand;
import bluej.groupwork.svn.SvnHistoryCommand;
import bluej.groupwork.svn.SvnModulesCommand;
import bluej.groupwork.svn.SvnShareCommand;
import bluej.groupwork.svn.SvnStatusCommand;
import bluej.utility.Debug;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.javahl.StatusCallback;

public class SvnRepository
implements Repository {
    private File projectPath;
    private String protocol;
    private String reposUrl;
    private SVNClientInterface client;
    private Object clientLock = new Object();

    public SvnRepository(File projectPath, String protocol, String reposUrl, SVNClientInterface client) {
        this.projectPath = projectPath;
        this.protocol = protocol;
        this.reposUrl = reposUrl;
        this.client = client;
    }

    @Override
    public boolean versionsDirectories() {
        return true;
    }

    @Override
    public void setPassword(TeamSettings newSettings) {
        this.client.password(newSettings.getPassword());
    }

    @Override
    public TeamworkCommand checkout(File projectPath) {
        return new SvnCheckoutCommand(this, projectPath);
    }

    @Override
    public TeamworkCommand commitAll(Set<File> newFiles, Set<File> binaryNewFiles, Set<File> deletedFiles, Set<File> files, String commitComment) {
        return new SvnCommitAllCommand(this, newFiles, binaryNewFiles, deletedFiles, files, commitComment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAllLocallyDeletedFiles(final Set<File> files) {
        Object object = this.clientLock;
        synchronized (object) {
            try {
                this.client.status(this.projectPath.getAbsolutePath(), 3, false, false, false, false, null, new StatusCallback(){

                    public void doStatus(Status status) {
                        File file = new File(status.getPath());
                        if (!file.exists()) {
                            files.add(file);
                        }
                    }
                });
            }
            catch (ClientException ce) {
                Debug.reportError("Subversion: ClientException when getting local status", ce);
            }
        }
    }

    @Override
    public TeamworkCommand getLogHistory(LogHistoryListener listener) {
        return new SvnHistoryCommand(this, listener);
    }

    @Override
    public FileFilter getMetadataFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.getName().equals(".svn");
            }
        };
    }

    @Override
    public TeamworkCommand getModules(List<String> modules) {
        return new SvnModulesCommand(this, modules);
    }

    @Override
    public TeamworkCommand getStatus(StatusListener listener, FileFilter filter, boolean includeRemote) {
        return new SvnStatusCommand(this, listener, filter, includeRemote);
    }

    @Override
    public void prepareCreateDir(final File dir) {
        try {
            this.client.status(dir.getAbsolutePath(), 0, false, true, true, false, null, new StatusCallback(){

                public void doStatus(Status stat) {
                    if (!stat.isManaged()) {
                        try {
                            SvnRepository.this.client.add(dir.getAbsolutePath(), 0, true, false, true);
                        }
                        catch (ClientException ce) {
                            Debug.message("Exception while doing svn add on directory: " + ce.getLocalizedMessage());
                        }
                    }
                }
            });
        }
        catch (ClientException ce) {
            Debug.message("Exception while doing svn status on new directory: " + ce.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareDeleteDir(File dir) {
        Object object = this.clientLock;
        synchronized (object) {
            try {
                this.client.remove(new String[]{dir.getAbsolutePath()}, "", true, false, Collections.emptyMap());
            }
            catch (ClientException ce) {
                Debug.message("Exception while doing svn remove on directory: " + ce.getLocalizedMessage());
            }
        }
        return false;
    }

    @Override
    public TeamworkCommand shareProject() {
        return new SvnShareCommand(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TeamworkCommandResult execCommand(SvnCommand command) {
        Object object = this.clientLock;
        synchronized (object) {
            return command.doCommand(this.client);
        }
    }

    public String getReposUrl() {
        return this.reposUrl;
    }

    public File getProjectPath() {
        return this.projectPath;
    }

    public SVNClientInterface getClient() {
        return this.client;
    }

    @Override
    public String getVCSType() {
        return "SVN";
    }

    @Override
    public String getVCSProtocol() {
        return this.protocol;
    }

    @Override
    public TeamworkCommand pushChanges() {
        throw new UnsupportedOperationException("Not supported");
    }
}

