/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.Config;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.UpdateListener;
import bluej.groupwork.UpdateResults;
import bluej.groupwork.git.GitCommand;
import bluej.groupwork.git.GitRepository;
import bluej.groupwork.git.GitUtillities;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitUpdateToCommand
extends GitCommand
implements UpdateResults {
    private final Set<File> files;
    private final Set<File> forceFiles;
    private final UpdateListener listener;
    private final List<File> conflicts = new ArrayList<File>();
    private final Set<File> binaryConflicts = new HashSet<File>();
    private List<DiffEntry> listOfDiffsLocal;
    private List<DiffEntry> listOfDiffsRemote;

    public GitUpdateToCommand(GitRepository repository, UpdateListener listener, Set<File> files, Set<File> forceFiles) {
        super(repository);
        this.files = files;
        this.forceFiles = forceFiles;
        this.listener = listener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TeamworkCommandResult getResult() {
        try (Git repo = Git.open((File)this.getRepository().getProjectPath());){
            File gitPath = this.getRepository().getProjectPath();
            MergeCommand merge = repo.merge();
            merge.setCommit(true);
            merge.setFastForward(MergeCommand.FastForwardMode.FF);
            merge.setStrategy((MergeStrategy)MergeStrategy.RECURSIVE);
            File packageBluejBackup = this.moveFile("package", "bluej");
            ObjectId headBeforeMerge = repo.getRepository().resolve("HEAD");
            ObjectId headOfRemoteBeforeMerge = repo.getRepository().resolve("origin/master");
            RevCommit forkPoint = GitUtillities.findForkPoint(repo.getRepository(), "origin/master", "HEAD");
            merge.include((AnyObjectId)repo.getRepository().resolve("origin/master"));
            MergeResult mergeResult = merge.call();
            switch (mergeResult.getMergeStatus()) {
                case FAST_FORWARD: {
                    if (packageBluejBackup == null) break;
                    if (!this.forceFiles.stream().anyMatch(file -> file.getName().equals("package.bluej"))) {
                        Files.move((File)packageBluejBackup, (File)new File(this.getRepository().getProjectPath(), "package.bluej"));
                        break;
                    }
                    packageBluejBackup.delete();
                    break;
                }
                case CONFLICTING: {
                    Map allConflicts = mergeResult.getConflicts();
                    allConflicts.keySet().stream().map(path -> new File(gitPath, (String)path)).forEach(f -> this.conflicts.add((File)f));
                    break;
                }
                case FAILED: {
                    Map allConflicts = mergeResult.getConflicts();
                    if (allConflicts == null) {
                        TeamworkCommandError teamworkCommandError = new TeamworkCommandError(Config.getString("team.error.needsPull"), Config.getString("team.error.needsPull"));
                        return teamworkCommandError;
                    }
                    allConflicts.keySet().stream().map(path -> new File(gitPath, (String)path)).forEach(f -> this.conflicts.add((File)f));
                    break;
                }
            }
            this.listOfDiffsLocal = GitUtillities.getDiffs(repo, headBeforeMerge.getName(), forkPoint);
            this.listOfDiffsRemote = GitUtillities.getDiffs(repo, headOfRemoteBeforeMerge.getName(), forkPoint);
            this.processChanges(repo, this.conflicts);
            if (this.conflicts.isEmpty()) {
                if (this.binaryConflicts.isEmpty()) return new TeamworkCommandResult();
            }
            this.listener.handleConflicts(this);
            return new TeamworkCommandResult();
        }
        catch (IOException ex) {
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
        catch (CheckoutConflictException ex) {
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
        catch (GitAPIException ex) {
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
    }

    @Override
    public List<File> getConflicts() {
        return this.conflicts;
    }

    @Override
    public Set<File> getBinaryConflicts() {
        return this.binaryConflicts;
    }

    @Override
    public void overrideFiles(Set<File> files) {
        for (File f : files) {
            DiffEntry remoteDiffItem = GitUtillities.getDiffFromList(new File(f.getName()), this.listOfDiffsRemote);
            if (remoteDiffItem != null && remoteDiffItem.getChangeType() == DiffEntry.ChangeType.DELETE) {
                f.delete();
                this.listener.fileRemoved(f);
                continue;
            }
            this.listener.fileUpdated(f);
        }
    }

    private void processChanges(Git repo, List<File> conflicts) {
        for (DiffEntry remoteDiffItem : this.listOfDiffsRemote) {
            File file = new File(this.getRepository().getProjectPath(), GitUtillities.getFileNameFromDiff(remoteDiffItem));
            DiffEntry localDiffItem = GitUtillities.getDiffFromList(remoteDiffItem, this.listOfDiffsLocal);
            switch (remoteDiffItem.getChangeType()) {
                case ADD: 
                case COPY: {
                    this.listener.fileAdded(file);
                    break;
                }
                case DELETE: {
                    if (localDiffItem != null && localDiffItem.getChangeType() == DiffEntry.ChangeType.MODIFY) {
                        conflicts.remove(file);
                        this.binaryConflicts.add(file);
                    }
                    if (!file.exists()) {
                        this.listener.fileRemoved(file);
                        break;
                    }
                    this.listener.fileUpdated(file);
                    break;
                }
                case MODIFY: {
                    this.listener.fileUpdated(file);
                }
            }
        }
    }

    private File moveFile(String fileName, String extension) throws IOException {
        File result = null;
        File projectPath = this.getRepository().getProjectPath();
        File[] matchingFiles = projectPath.listFiles((dir, name) -> name.startsWith(fileName) && name.endsWith(extension));
        if (matchingFiles.length == 1) {
            result = File.createTempFile(fileName, extension);
            Files.move((File)matchingFiles[0], (File)result);
        }
        return result;
    }
}

