/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.groupwork.Repository;
import bluej.groupwork.StatusHandle;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.UpdateListener;
import bluej.groupwork.git.GitCommitAllCommand;
import bluej.groupwork.git.GitPushChangesCommand;
import bluej.groupwork.git.GitRepository;
import bluej.groupwork.git.GitUpdateToCommand;
import java.io.File;
import java.util.Set;

public class GitStatusHandle
implements StatusHandle {
    private GitRepository repository;
    private final boolean pushNeeded;
    private final boolean pullNeeded;

    public GitStatusHandle(GitRepository repository, boolean pushNeeded, boolean pullNeeded) {
        this.repository = repository;
        this.pushNeeded = pushNeeded;
        this.pullNeeded = pullNeeded;
    }

    @Override
    public TeamworkCommand commitAll(Set<File> newFiles, Set<File> binaryNewFiles, Set<File> deletedFiles, Set<File> files, Set<TeamStatusInfo> forceFiles, String commitComment) {
        newFiles.addAll(binaryNewFiles);
        return new GitCommitAllCommand(this.repository, newFiles, deletedFiles, files, commitComment);
    }

    @Override
    public TeamworkCommand updateTo(UpdateListener listener, Set<File> files, Set<File> forceFiles) {
        return new GitUpdateToCommand(this.repository, listener, files, forceFiles);
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public TeamworkCommand pushAll(Set<File> filesToPush) {
        return new GitPushChangesCommand(this.repository);
    }

    @Override
    public boolean pushNeeded() {
        return this.pushNeeded;
    }

    @Override
    public boolean pullNeeded() {
        return this.pullNeeded;
    }
}

