/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.groupwork.HistoryInfo;
import bluej.groupwork.LogHistoryListener;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.git.GitCommand;
import bluej.groupwork.git.GitRepository;
import bluej.utility.Debug;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.treewalk.TreeWalk;

public class GitHistoryCommand
extends GitCommand {
    private final LogHistoryListener listener;

    public GitHistoryCommand(GitRepository repository, LogHistoryListener listener) {
        super(repository);
        this.listener = listener;
    }

    @Override
    public TeamworkCommandResult getResult() {
        try (Git repo = Git.open((File)this.getRepository().getProjectPath());){
            Iterable logs = repo.log().call();
            logs.forEach(rev -> {
                ArrayList<String> files = new ArrayList<String>();
                try (TreeWalk treeWalk = new TreeWalk(repo.getRepository());){
                    treeWalk.addTree((AnyObjectId)rev.getTree());
                    boolean hasNext = treeWalk.next();
                    while (hasNext) {
                        files.add(treeWalk.getPathString());
                        hasNext = treeWalk.next();
                    }
                }
                catch (IOException ex) {
                    Debug.reportError(ex.getMessage());
                }
                Date date = new Date((long)rev.getCommitTime() * 1000L);
                String dateString = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss").format(date);
                HistoryInfo info = new HistoryInfo(files.toArray(new String[files.size()]), "", dateString, rev.getAuthorIdent().getName(), rev.getFullMessage());
                this.listener.logInfoAvailable(info);
            });
        }
        catch (IOException | GitAPIException ex) {
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
        return new TeamworkCommandResult();
    }
}

