/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.groupwork.actions.CommitCommentAction;
import bluej.groupwork.actions.ImportAction;
import bluej.groupwork.actions.ShowLogAction;
import bluej.groupwork.actions.StatusAction;
import bluej.groupwork.actions.TeamSettingsAction;
import bluej.groupwork.actions.UpdateDialogAction;
import bluej.pkgmgr.PkgMgrFrame;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Swing)
public class TeamActionGroup {
    private final String commitLabel;
    private final boolean initialTeamMode;
    private final boolean initialIsDVCS;
    private StatusAction statusAction;
    private UpdateDialogAction updateAction;
    private TeamSettingsAction teamSettingsAction;
    private CommitCommentAction commitCommentAction;
    private ImportAction importAction;
    private ShowLogAction showLogAction;

    public TeamActionGroup(boolean teamMode) {
        this(teamMode, false);
    }

    public TeamActionGroup(boolean teamMode, boolean isDVCS) {
        String label = "team.commit";
        if (isDVCS) {
            label = "team.commitPush";
        }
        this.commitLabel = label;
        this.initialTeamMode = teamMode;
        this.initialIsDVCS = isDVCS;
    }

    private void createAll(PkgMgrFrame pmf) {
        if (this.statusAction == null) {
            this.statusAction = new StatusAction(pmf);
            this.updateAction = new UpdateDialogAction(pmf);
            this.teamSettingsAction = new TeamSettingsAction(pmf);
            this.commitCommentAction = new CommitCommentAction(pmf, this.commitLabel);
            this.importAction = new ImportAction(pmf);
            this.showLogAction = new ShowLogAction(pmf);
            this.setTeamMode(pmf, this.initialTeamMode, this.initialIsDVCS);
        }
    }

    public StatusAction getStatusAction(PkgMgrFrame pmf) {
        this.createAll(pmf);
        return this.statusAction;
    }

    public UpdateDialogAction getUpdateAction(PkgMgrFrame pmf) {
        this.createAll(pmf);
        return this.updateAction;
    }

    public TeamSettingsAction getTeamSettingsAction(PkgMgrFrame pmf) {
        this.createAll(pmf);
        return this.teamSettingsAction;
    }

    public CommitCommentAction getCommitCommentAction(PkgMgrFrame pmf) {
        this.createAll(pmf);
        return this.commitCommentAction;
    }

    public ImportAction getImportAction(PkgMgrFrame pmf) {
        this.createAll(pmf);
        return this.importAction;
    }

    public ShowLogAction getShowLogAction(PkgMgrFrame pmf) {
        this.createAll(pmf);
        return this.showLogAction;
    }

    public void setTeamMode(PkgMgrFrame pmf, boolean enabled, boolean isDCVS) {
        this.createAll(pmf);
        this.statusAction.setEnabled(enabled);
        this.updateAction.setEnabled(enabled);
        this.teamSettingsAction.setEnabled(enabled);
        this.showLogAction.setEnabled(enabled);
        String label = "team.commit";
        if (isDCVS) {
            label = "team.commitPush";
        }
        this.commitCommentAction.setName(Config.getString(label));
        this.commitCommentAction.setEnabled(enabled);
        this.importAction.setEnabled(!enabled);
    }

    public void setAllDisabled(PkgMgrFrame pmf) {
        this.createAll(pmf);
        this.statusAction.setEnabled(false);
        this.updateAction.setEnabled(false);
        this.teamSettingsAction.setEnabled(false);
        this.commitCommentAction.setEnabled(false);
        this.importAction.setEnabled(false);
        this.showLogAction.setEnabled(false);
    }
}

