/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommandResult;
import bluej.pkgmgr.PkgMgrFrame;
import java.awt.event.ActionEvent;
import javafx.stage.Window;
import javax.swing.AbstractAction;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class TeamAction
extends AbstractAction {
    private final PkgMgrFrame pkgMgrFrame;

    public TeamAction(PkgMgrFrame pmf, String name) {
        this(pmf, Config.getString(name), false);
    }

    public TeamAction(PkgMgrFrame pmf, String name, boolean showsDialog) {
        super(showsDialog ? Config.getString(name) + "..." : Config.getString(name));
        this.pkgMgrFrame = pmf;
        if (!Config.isMacOS()) {
            this.putValue("MnemonicKey", new Integer(Config.getMnemonicKey(name)));
        }
        if (Config.hasAcceleratorKey(name)) {
            this.putValue("AcceleratorKey", Config.getAcceleratorKey(name));
        }
    }

    @Override
    @OnThread(value=Tag.Swing)
    public void actionPerformed(ActionEvent e) {
        this.actionPerformed(this.pkgMgrFrame);
    }

    @OnThread(value=Tag.Swing)
    public abstract void actionPerformed(PkgMgrFrame var1);

    @OnThread(value=Tag.FXPlatform)
    protected void handleServerResponse(TeamworkCommandResult result) {
        TeamUtils.handleServerResponseFX(result, (Window)this.pkgMgrFrame.getFXWindow());
    }

    protected void startProgressBar() {
        this.pkgMgrFrame.startProgress();
    }

    protected void stopProgressBar() {
        this.pkgMgrFrame.stopProgress();
    }

    protected void setStatus(String statusMessage) {
        this.pkgMgrFrame.setStatus(statusMessage);
    }

    protected void clearStatus() {
        this.pkgMgrFrame.clearStatus();
    }

    @OnThread(value=Tag.Swing)
    public void setName(String name) {
        if (name != null) {
            this.putValue("Name", name);
        }
    }
}

