/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.groupwork.StatusHandle;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.ui.CommitAndPushInterface;
import bluej.pkgmgr.Project;
import bluej.utility.SwingWorker;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javafx.application.Platform;
import javax.swing.AbstractAction;
import threadchecker.OnThread;
import threadchecker.Tag;

public class PushAction
extends AbstractAction {
    private CommitAndPushInterface commitCommentsFrame;
    private Set<File> filesToPush;
    private PushWorker worker;
    private StatusHandle statusHandle;

    public PushAction(CommitAndPushInterface frame) {
        super(Config.getString("team.push"));
        this.commitCommentsFrame = frame;
        this.filesToPush = new HashSet<File>();
    }

    public void setFilesToPush(Set<File> filesToPush) {
        this.filesToPush = filesToPush;
    }

    public Set<File> getFilesToPush() {
        return this.filesToPush;
    }

    public void cancel() {
        this.setEnabled(true);
        if (this.worker != null) {
            this.worker.abort();
            this.worker = null;
        }
    }

    @OnThread(value=Tag.Any)
    public void setStatusHandle(StatusHandle statusHandle) {
        this.statusHandle = statusHandle;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Project project = this.commitCommentsFrame.getProject();
        if (project != null) {
            this.commitCommentsFrame.startProgress();
            this.commitCommentsFrame.displayMessage(Config.getString("team.push.statusMessage"));
            this.setEnabled(false);
            this.worker = new PushWorker(project);
            this.worker.start();
        }
    }

    private class PushWorker
    extends SwingWorker {
        private TeamworkCommand command;
        private TeamworkCommandResult result = null;
        private final boolean hasPassword;
        private boolean aborted;

        @OnThread(value=Tag.Swing)
        public PushWorker(Project project) {
            this.command = PushAction.this.statusHandle.pushAll(PushAction.this.filesToPush);
            if (!project.getTeamSettingsController().hasPasswordString()) {
                if (project.getTeamSettingsDialog().doTeamSettings() == 1) {
                    PushAction.this.commitCommentsFrame.setVisible(true);
                    this.hasPassword = false;
                    return;
                }
                PushAction.this.statusHandle.getRepository().setPassword(PushAction.this.commitCommentsFrame.getProject().getTeamSettingsController().getTeamSettingsDialog().getSettings());
            }
            this.hasPassword = true;
        }

        @Override
        public Object construct() {
            if (!this.hasPassword) {
                this.abort();
                return null;
            }
            this.result = this.command.getResult();
            return this.result;
        }

        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        @Override
        public void finished() {
            Project project = PushAction.this.commitCommentsFrame.getProject();
            if (!this.aborted) {
                PushAction.this.commitCommentsFrame.stopProgress();
                if (!this.result.isError() && !this.result.wasAborted()) {
                    DataCollector.teamCommitProject(project, PushAction.this.statusHandle.getRepository(), PushAction.this.filesToPush);
                    EventQueue.invokeLater(() -> PushAction.this.commitCommentsFrame.displayMessage(Config.getString("team.push.statusDone")));
                }
            }
            Platform.runLater(() -> TeamUtils.handleServerResponseFX(this.result, PushAction.this.commitCommentsFrame.asWindow()));
            if (!this.aborted) {
                PushAction.this.setEnabled(true);
                if (project.getTeamSettingsController().isDVCS()) {
                    PushAction.this.commitCommentsFrame.setVisible(true);
                } else {
                    PushAction.this.commitCommentsFrame.setVisible(false);
                }
            }
        }
    }
}

