/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork;

import bluej.Config;
import java.io.File;

public class TeamStatusInfo {
    private File file;
    private String localVersion;
    private String remoteVersion;
    private int status;
    private int remoteStatus;
    public static final int STATUS_UPTODATE = 0;
    public static final int STATUS_NEEDSCHECKOUT = 1;
    public static final int STATUS_DELETED = 2;
    public static final int STATUS_NEEDSUPDATE = 3;
    public static final int STATUS_NEEDSCOMMIT = 4;
    public static final int STATUS_NEEDSMERGE = 5;
    public static final int STATUS_NEEDSADD = 6;
    public static final int STATUS_REMOVED = 7;
    public static final int STATUS_UNRESOLVED = 8;
    public static final int STATUS_HASCONFLICTS = 9;
    public static final int STATUS_WEIRD = 10;
    public static final int STATUS_CONFLICT_ADD = 12;
    public static final int STATUS_CONFLICT_LMRD = 13;
    public static final int STATUS_CONFLICT_LDRM = 14;
    public static final int STATUS_RENAMED = 15;
    public static final int STATUS_BLANK = 11;
    public static final int STATUS_NEEDS_PUSH = 16;
    public static final int REMOTE_STATUS_UPTODATE = 0;
    public static final int REMOTE_STATUS_MODIFIED = 3;
    public static final int REMOTE_STATUS_RENAMED = 15;
    public static final String[] statusStrings = new String[]{"team.statusinfo.upToDate", "team.statusinfo.needsCheckout", "team.statusinfo.deleted", "team.statusinfo.needsUpdate", "team.statusinfo.needsCommit", "team.statusinfo.needsMerge", "team.statusinfo.needsAdd", "team.statusinfo.removed", "team.statusinfo.unresolved", "team.statusinfo.hasConflicts", "team.statusinfo.weird", "", "team.statusinfo.conflictAdd", "team.statusinfo.conflictLMRD", "team.statusinfo.conflictLDRM", "team.statusinfo.renamed", "team.statusinfo.dcvs.needsPush"};
    public static final String[] dcvsStatusStrings = new String[]{"", "", "team.statusinfo.dcvs.local.deleted", "", "team.statusinfo.dcvs.local.modified", "team.statusinfo.needsMerge", "team.statusinfo.dcvs.local.new", "", "team.statusinfo.unresolved", "team.statusinfo.hasConflicts", "team.statusinfo.weird", "", "team.statusinfo.conflictAdd", "team.statusinfo.conflictLMRD", "team.statusinfo.conflictLDRM", "team.statusinfo.renamed", ""};
    public static final String[] dcvsRemoteStatusStrings = new String[]{"", "team.statusinfo.dcvs.remote.needs.pull", "team.statusinfo.dcvs.remote.deleted", "team.statusinfo.dcvs.remote.needs.pull", "team.statusinfo.dcvs.remote.modified", "team.statusinfo.needsMerge", "team.statusinfo.dcvs.remote.new", "team.statusinfo.dcvs.remote.needs.pull", "team.statusinfo.unresolved", "team.statusinfo.hasConflicts", "team.statusinfo.weird", "", "team.statusinfo.conflictAdd", "team.statusinfo.conflictLMRD", "team.statusinfo.conflictLDRM", "team.statusinfo.renamed", "team.statusinfo.dcvs.needsPush"};

    public TeamStatusInfo() {
        this(new File(""), "", "", 11, 11);
    }

    public TeamStatusInfo(File file, String localVersion, String remoteVersion, int status) {
        this.file = file;
        this.localVersion = localVersion;
        this.remoteVersion = remoteVersion;
        this.status = status;
        this.remoteStatus = 0;
    }

    public TeamStatusInfo(File file, String localVersion, String remoteVersion, int status, int remoteStatus) {
        this(file, localVersion, remoteVersion, status);
        this.remoteStatus = remoteStatus;
    }

    public File getFile() {
        return this.file;
    }

    public String getLocalVersion() {
        return this.localVersion;
    }

    public String getRepositoryVersion() {
        return this.remoteVersion;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int s) {
        this.status = s;
    }

    public int getRemoteStatus() {
        return this.remoteStatus;
    }

    public void setRemoteStatus(int s) {
        this.remoteStatus = s;
    }

    public String toString() {
        return this.getFile().getName();
    }

    public static String getStatusString(int status) {
        if (status == 11) {
            return "";
        }
        return Config.getString(statusStrings[status]);
    }

    public static String getDCVSStatusString(int status, boolean remote) {
        if (status == 11) {
            return "";
        }
        if (remote) {
            return Config.getString(dcvsRemoteStatusStrings[status]);
        }
        return Config.getString(dcvsStatusStrings[status]);
    }
}

