/*
 * Decompiled with CFR 0.152.
 */
package bluej.extmgr;

import bluej.extmgr.ExtensionMenu;
import bluej.extmgr.ExtensionWrapper;
import bluej.extmgr.ExtensionsManager;
import bluej.pkgmgr.Project;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXPlatformSupplier;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public final class FXMenuManager {
    private final ExtensionsManager extMgr;
    private final SeparatorMenuItem menuSeparator;
    private final @OnThread(value=Tag.Any) ContextMenu popupMenu;
    private final @OnThread(value=Tag.Any) Menu menu;
    private @OnThread(value=Tag.Any, requireSynchronized=true) ExtensionMenu menuGenerator;

    @OnThread(value=Tag.Any)
    public synchronized void setMenuGenerator(ExtensionMenu menuGenerator) {
        this.menuGenerator = menuGenerator;
    }

    public FXMenuManager(ContextMenu aPopupMenu, ExtensionsManager extMgr, ExtensionMenu menuGenerator) {
        this.extMgr = extMgr;
        this.menuGenerator = menuGenerator;
        this.menuSeparator = new SeparatorMenuItem();
        this.popupMenu = aPopupMenu;
        this.popupMenu.setOnShowing(this::menuWillBecomeVisible);
        this.menu = null;
    }

    public FXMenuManager(Menu aMenu, ExtensionsManager extMgr, ExtensionMenu menuGenerator) {
        this.extMgr = extMgr;
        this.menuGenerator = menuGenerator;
        this.menuSeparator = new SeparatorMenuItem();
        this.menu = aMenu;
        this.menu.setOnShowing(this::menuWillBecomeVisible);
        this.popupMenu = null;
    }

    @OnThread(value=Tag.Swing)
    public synchronized void addExtensionMenu(Project onThisProject) {
        LinkedList<JMenuItem> menuItems = this.extMgr.getMenuItems(this.menuGenerator, onThisProject);
        FXPlatformRunnable addItems = this.popupMenu != null ? JavaFXUtil.swingMenuItemsToContextMenu(this.popupMenu, menuItems, this, (swingItem, fxItem) -> {
            fxItem.getProperties().put((Object)"bluej.extmgr.ExtensionWrapper", swingItem.getClientProperty("bluej.extmgr.ExtensionWrapper"));
            fxItem.getProperties().put((Object)"bluej.extmgr.JMenuItem", swingItem);
        }) : this.supplierToRunnable(JavaFXUtil.swingMenuToFX(menuItems, this, () -> this.menu, (a, b) -> {}));
        Platform.runLater(() -> {
            ObservableList<MenuItem> items = this.getItems();
            ArrayList<MenuItem> oldPopupItems = new ArrayList<MenuItem>((Collection<MenuItem>)items);
            for (MenuItem aComponent : oldPopupItems) {
                ExtensionWrapper aWrapper = (ExtensionWrapper)aComponent.getProperties().get((Object)"bluej.extmgr.ExtensionWrapper");
                if (aWrapper == null) continue;
                items.remove((Object)aComponent);
            }
            items.remove((Object)this.menuSeparator);
            if (!menuItems.isEmpty()) {
                items.add((Object)this.menuSeparator);
                addItems.run();
            }
        });
    }

    @OnThread(value=Tag.Any)
    private FXPlatformRunnable supplierToRunnable(FXPlatformSupplier<Menu> menuFXSupplier) {
        return () -> menuFXSupplier.get();
    }

    private ObservableList<MenuItem> getItems() {
        if (this.popupMenu != null) {
            return this.popupMenu.getItems();
        }
        return this.menu.getItems();
    }

    private void menuWillBecomeVisible(Event event) {
        int itemsCount = 0;
        ObservableList<MenuItem> items = this.getItems();
        ArrayList<MenuItem> popupMenuItems = new ArrayList<MenuItem>((Collection<MenuItem>)items);
        for (MenuItem aComponent : popupMenuItems) {
            ExtensionWrapper aWrapper = (ExtensionWrapper)aComponent.getProperties().get((Object)"bluej.extmgr.ExtensionWrapper");
            if (aWrapper == null) continue;
            JMenuItem swingItem = (JMenuItem)aComponent.getProperties().get((Object)"bluej.extmgr.JMenuItem");
            SwingUtilities.invokeLater(() -> {
                if (!aWrapper.isValid()) {
                    Platform.runLater(() -> items.remove((Object)aComponent));
                } else {
                    FXMenuManager fXMenuManager = this;
                    synchronized (fXMenuManager) {
                        aWrapper.safePostMenuItem(this.menuGenerator, swingItem);
                    }
                }
            });
            ++itemsCount;
        }
        if (itemsCount <= 0) {
            items.remove((Object)this.menuSeparator);
        }
    }
}

