/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.utility.JavaUtils;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;

public abstract class JdiUtils {
    private static JdiUtils jutils = null;
    private static final String nullLabel = "null";

    public static JdiUtils getJdiUtils() {
        if (jutils != null) {
            return jutils;
        }
        try {
            Class<?> J15Class = Class.forName("bluej.debugger.jdi.JdiUtils15");
            jutils = (JdiUtils)J15Class.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return jutils;
    }

    public abstract boolean hasGenericSig(ObjectReference var1);

    public abstract String genericSignature(Field var1);

    public abstract String genericSignature(ReferenceType var1);

    public abstract String genericSignature(LocalVariable var1);

    public abstract boolean isEnum(ClassType var1);

    public String getValueString(Value val) {
        if (val == null) {
            return nullLabel;
        }
        if (val instanceof StringReference) {
            return "\"" + JavaUtils.escapeString(((StringReference)val).value()) + "\"";
        }
        if (val.type() instanceof ClassType && this.isEnum((ClassType)val.type())) {
            ClassType type = (ClassType)val.type();
            Field nameField = type.fieldByName("name");
            String name = ((StringReference)((ObjectReference)val).getValue(nameField)).value();
            return name;
        }
        if (val instanceof ObjectReference) {
            return "<object reference>";
        }
        if (val instanceof CharValue) {
            return "'" + JavaUtils.escapeString(val.toString()) + "'";
        }
        return val.toString();
    }
}

