/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.ConstructorReflective;
import bluej.debugger.gentype.FieldReflective;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.MethodReflective;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Reflective {
    public abstract String getName();

    public String getSimpleName() {
        return this.getName();
    }

    public abstract List<GenTypeDeclTpar> getTypeParams();

    public abstract List<Reflective> getSuperTypesR();

    public abstract List<GenTypeClass> getSuperTypes();

    public abstract Reflective getArrayOf();

    public abstract boolean isAssignableFrom(Reflective var1);

    public abstract boolean isInterface();

    public GenTypeClass superTypeByName(String rawName) {
        List<GenTypeClass> superTypes = this.getSuperTypes();
        for (GenTypeClass next : superTypes) {
            if (!next.classloaderName().equals(rawName)) continue;
            return next;
        }
        return null;
    }

    public abstract Reflective getRelativeClass(String var1);

    public Reflective getOuterClass() {
        int dotIndex;
        int dollarIndex = this.getName().lastIndexOf(36);
        if (dollarIndex != -1 && (dotIndex = this.getName().indexOf(46, dollarIndex)) == -1) {
            String outerName = this.getName().substring(0, dollarIndex);
            return this.getRelativeClass(outerName);
        }
        return null;
    }

    public abstract boolean isStatic();

    public abstract boolean isPublic();

    public abstract Map<String, Set<MethodReflective>> getDeclaredMethods();

    public abstract List<ConstructorReflective> getDeclaredConstructors();

    public abstract Map<String, FieldReflective> getDeclaredFields();

    public abstract Reflective getInnerClass(String var1);
}

