/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.compiler.CompileInputFile;
import bluej.compiler.CompileObserver;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.compiler.Diagnostic;
import bluej.compiler.EDTCompileObserver;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import threadchecker.OnThread;
import threadchecker.Tag;

public final class EventqueueCompileObserverAdapter
implements CompileObserver,
Runnable {
    private EDTCompileObserver link;
    private int command;
    private static final int COMMAND_START = 0;
    private static final int COMMAND_DIAG = 1;
    private static final int COMMAND_END = 2;
    private CompileInputFile[] sources;
    private boolean successful;
    private CompileReason reason;
    private CompileType type;
    private Diagnostic diagnostic;

    public EventqueueCompileObserverAdapter(EDTCompileObserver link) {
        this.link = link;
    }

    private void runOnEventQueue() {
        try {
            EventQueue.invokeAndWait(this);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite);
        }
    }

    @Override
    public synchronized void compilerMessage(Diagnostic diagnostic, CompileType type) {
        this.command = 1;
        this.diagnostic = diagnostic;
        this.type = type;
        this.runOnEventQueue();
    }

    @Override
    public synchronized void startCompile(CompileInputFile[] csources, CompileReason reason, CompileType type) {
        this.command = 0;
        this.sources = csources;
        this.reason = reason;
        this.type = type;
        this.runOnEventQueue();
    }

    @Override
    public synchronized void endCompile(CompileInputFile[] sources, boolean successful, CompileType type) {
        this.command = 2;
        this.sources = sources;
        this.successful = successful;
        this.type = type;
        this.runOnEventQueue();
    }

    @Override
    @OnThread(value=Tag.Swing, ignoreParent=true)
    public void run() {
        switch (this.command) {
            case 0: {
                this.link.startCompile(this.sources, this.reason, this.type);
                break;
            }
            case 1: {
                this.link.compilerMessage(this.diagnostic, this.type);
                break;
            }
            case 2: {
                this.link.endCompile(this.sources, this.successful, this.type);
            }
        }
    }
}

