/*
 * Decompiled with CFR 0.152.
 */
package bluej.collect;

import bluej.Boot;
import bluej.Config;
import bluej.collect.DataCollectionDialog;
import bluej.collect.DataCollectorImpl;
import bluej.collect.DataSubmitter;
import bluej.collect.DiagnosticWithShown;
import bluej.collect.GreenfootInterfaceEvent;
import bluej.collect.StrideEditReason;
import bluej.compiler.CompileInputFile;
import bluej.compiler.CompileReason;
import bluej.debugger.DebuggerTestResult;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.SourceLocation;
import bluej.debugmgr.inspector.ClassInspector;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.ObjectInspector;
import bluej.extensions.SourceType;
import bluej.extmgr.ExtensionWrapper;
import bluej.groupwork.Repository;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import java.io.File;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Swing)
public class DataCollector {
    private static final String PROPERTY_UUID = "blackbox.uuid";
    private static final String PROPERTY_EXPERIMENT = "blackbox.experiment";
    private static final String PROPERTY_PARTICIPANT = "blackbox.participant";
    private static final String OPT_OUT = "optout";
    private static @OnThread(value=Tag.Any, requireSynchronized=true) boolean recordingThisSession;
    private static @OnThread(value=Tag.Any, requireSynchronized=true) String sessionUuid;
    private static @OnThread(value=Tag.Any, requireSynchronized=true) String uuid;
    private static @OnThread(value=Tag.Any, requireSynchronized=true) String experimentIdentifier;
    private static @OnThread(value=Tag.Any, requireSynchronized=true) String participantIdentifier;
    private static final BitSet shownErrorMessages;
    private static final BitSet shownErrorIndicators;
    private static final BitSet createdErrors;

    @OnThread(value=Tag.Any)
    private static synchronized boolean dontSend() {
        return Config.isGreenfoot() && !Boot.isTrialRecording() || !recordingThisSession;
    }

    @OnThread(value=Tag.FXPlatform)
    private static synchronized void startSession() {
        uuid = Config.getPropString(PROPERTY_UUID, null);
        if (!OPT_OUT.equals(uuid) && !DataCollector.uuidValidForRecording()) {
            DataCollector.changeOptInOut(Boot.isTrialRecording());
        }
        if (recordingThisSession = false) {
            sessionUuid = UUID.randomUUID().toString();
        }
        experimentIdentifier = Config.getPropString(PROPERTY_EXPERIMENT, null);
        participantIdentifier = Config.getPropString(PROPERTY_PARTICIPANT, null);
    }

    @OnThread(value=Tag.Any)
    private static synchronized boolean uuidValidForRecording() {
        return uuid != null && !OPT_OUT.equals(uuid) && uuid.length() >= 32;
    }

    @OnThread(value=Tag.FXPlatform)
    public static synchronized void changeOptInOut(boolean forceOptIn) {
        boolean optedIn;
        if (forceOptIn) {
            optedIn = true;
        } else {
            DataCollectionDialog dlg = new DataCollectionDialog();
            optedIn = dlg.showAndWait().orElse(false);
        }
        if (optedIn) {
            if (!DataCollector.uuidValidForRecording()) {
                uuid = UUID.randomUUID().toString();
            }
        } else {
            uuid = OPT_OUT;
            recordingThisSession = false;
        }
        Config.putPropString(PROPERTY_UUID, uuid);
    }

    public static synchronized String getUserID() {
        return uuid;
    }

    @OnThread(value=Tag.Any)
    public static synchronized String getExperimentIdentifier() {
        return experimentIdentifier;
    }

    @OnThread(value=Tag.Any)
    public static synchronized String getParticipantIdentifier() {
        return participantIdentifier;
    }

    @OnThread(value=Tag.Any)
    public static synchronized String getSessionUuid() {
        return sessionUuid;
    }

    @OnThread(value=Tag.Any)
    public static synchronized String getOptInOutStatus() {
        if (recordingThisSession) {
            return Config.getString("collect.status.optedin");
        }
        if (DataCollector.uuidValidForRecording()) {
            return Config.getString("collect.status.nextsession");
        }
        return Config.getString("collect.status.optedout");
    }

    public static synchronized void setExperimentIdentifier(String experimentIdentifier) {
        DataCollector.experimentIdentifier = experimentIdentifier;
        Config.putPropString(PROPERTY_EXPERIMENT, experimentIdentifier);
    }

    public static synchronized void setParticipantIdentifier(String participantIdentifier) {
        DataCollector.participantIdentifier = participantIdentifier;
        Config.putPropString(PROPERTY_PARTICIPANT, participantIdentifier);
    }

    @OnThread(value=Tag.FXPlatform)
    public static void bluejOpened(String osVersion, String javaVersion, String bluejVersion, String interfaceLanguage, List<ExtensionWrapper> extensions) {
        if (Config.isGreenfoot() && !Boot.isTrialRecording()) {
            return;
        }
        DataCollector.startSession();
        if (DataCollector.dontSend()) {
            return;
        }
        SwingUtilities.invokeLater(() -> DataCollectorImpl.bluejOpened(osVersion, javaVersion, bluejVersion, interfaceLanguage, extensions));
    }

    public static void bluejClosed() {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.bluejClosed();
    }

    public static void compiled(Project proj, Package pkg, CompileInputFile[] sources, List<DiagnosticWithShown> diagnostics, boolean success, CompileReason reason, SourceType inputType) {
        if (DataCollector.dontSend()) {
            return;
        }
        diagnostics.forEach(dws -> {
            if (dws.wasShownToUser()) {
                shownErrorIndicators.set(dws.getDiagnostic().getIdentifier());
            } else if (shownErrorIndicators.get(dws.getDiagnostic().getIdentifier())) {
                dws.markShownToUser();
            }
            createdErrors.set(dws.getDiagnostic().getIdentifier());
        });
        DataCollectorImpl.compiled(proj, pkg, sources, diagnostics, success, reason, inputType);
    }

    public static void debuggerTerminate(Project project) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.debuggerTerminate(project);
    }

    public static void debuggerChangeVisible(Project project, boolean newVis) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.debuggerChangeVisible(project, newVis);
    }

    public static void debuggerContinue(Project project, String threadName) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.debuggerContinue(project, threadName);
    }

    public static void debuggerHalt(Project project, String threadName, SourceLocation[] stack) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.debuggerHalt(project, threadName, stack);
    }

    public static void debuggerStepInto(Project project, String threadName, SourceLocation[] stack) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.debuggerStepInto(project, threadName, stack);
    }

    public static void debuggerStepOver(Project project, String threadName, SourceLocation[] stack) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.debuggerStepOver(project, threadName, stack);
    }

    public static void debuggerHitBreakpoint(Project project, String threadName, SourceLocation[] stack) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.debuggerHitBreakpoint(project, threadName, stack);
    }

    public static void invokeCompileError(Package pkg, String code, String compilationError) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.invokeCompileError(pkg, code, compilationError);
    }

    public static void invokeMethodSuccess(Package pkg, String code, String objName, String typeName, int testIdentifier, int invocationIdentifier) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.invokeMethodSuccess(pkg, code, objName, typeName, testIdentifier, invocationIdentifier);
    }

    public static void invokeMethodException(Package pkg, String code, ExceptionDescription ed) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.invokeMethodException(pkg, code, ed);
    }

    public static void invokeMethodTerminated(Package pkg, String code) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.invokeMethodTerminated(pkg, code);
    }

    public static void assertTestMethod(Package pkg, int testIdentifier, int invocationIdentifier, String assertion, String param1, String param2) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.assertTestMethod(pkg, testIdentifier, invocationIdentifier, assertion, param1, param2);
    }

    public static void removeObject(Package pkg, String name) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.removeObject(pkg, name);
    }

    public static void codePadSuccess(Package pkg, String command, String output) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.codePadSuccess(pkg, command, output);
    }

    public static void codePadError(Package pkg, String command, String error) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.codePadError(pkg, command, error);
    }

    public static void codePadException(Package pkg, String command, String exception) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.codePadException(pkg, command, exception);
    }

    public static void teamCommitProject(Project project, Repository repo, Set<File> committedFiles) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.teamCommitProject(project, repo, committedFiles);
    }

    public static void teamShareProject(Project project, Repository repo) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.teamShareProject(project, repo);
    }

    public static void addClass(Package pkg, ClassTarget ct) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.addClass(pkg, ct);
    }

    public static void teamUpdateProject(Project project, Repository repo, Set<File> updatedFiles) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.teamUpdateProject(project, repo, updatedFiles);
    }

    public static void teamHistoryProject(Project project, Repository repo) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.teamHistoryProject(project, repo);
    }

    public static void teamStatusProject(Project project, Repository repo, Map<File, String> status) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.teamStatusProject(project, repo, status);
    }

    public static void debuggerBreakpointToggle(Package pkg, File sourceFile, int lineNumber, boolean newState) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.debuggerBreakpointToggle(pkg, sourceFile, lineNumber, newState);
    }

    public static void renamedClass(Package pkg, File oldSourceFile, File newSourceFile) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.renamedClass(pkg, oldSourceFile, newSourceFile);
    }

    public static void removeClass(Package pkg, File sourceFile) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.removeClass(pkg, sourceFile);
    }

    public static void openClass(Package pkg, File sourceFile) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.openClass(pkg, sourceFile);
    }

    public static void closeClass(Package pkg, File sourceFile) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.closeClass(pkg, sourceFile);
    }

    public static void selectClass(Package pkg, File sourceFile) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.selectClass(pkg, sourceFile);
    }

    public static void convertStrideToJava(Package pkg, File oldSourceFile, File newSourceFile) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.convertStrideToJava(pkg, oldSourceFile, newSourceFile);
    }

    public static void edit(Package pkg, File path, String source, boolean includeOneLineEdits, StrideEditReason reason) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.edit(pkg, path, source, includeOneLineEdits, reason);
    }

    public static void packageOpened(Package pkg) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.packageOpened(pkg);
    }

    public static void packageClosed(Package pkg) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.packageClosed(pkg);
    }

    public static void benchGet(Package pkg, String benchName, String typeName, int testIdentifier) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.benchGet(pkg, benchName, typeName, testIdentifier);
    }

    public static void endTestMethod(Package pkg, int testIdentifier) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.endTestMethod(pkg, testIdentifier);
    }

    public static void cancelTestMethod(Package pkg, int testIdentifier) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.cancelTestMethod(pkg, testIdentifier);
    }

    public static void startTestMethod(Package pkg, int testIdentifier, File sourceFile, String testName) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.startTestMethod(pkg, testIdentifier, sourceFile, testName);
    }

    public static void restartVM(Project project) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.restartVM(project);
    }

    public static void testResult(Package pkg, DebuggerTestResult lastResult) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.testResult(pkg, lastResult);
    }

    public static void projectOpened(Project proj, List<ExtensionWrapper> projectExtensions) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.projectOpened(proj, projectExtensions);
    }

    public static void projectClosed(Project proj) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.projectClosed(proj);
    }

    public static void inspectorObjectShow(Package pkg, ObjectInspector inspector, String benchName, String className, String displayName) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.inspectorObjectShow(pkg, inspector, benchName, className, displayName);
    }

    public static void inspectorHide(Project project, Inspector inspector) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.inspectorHide(project, inspector);
    }

    public static void inspectorClassShow(Package pkg, ClassInspector inspector, String className) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.inspectorClassShow(pkg, inspector, className);
    }

    public static void showErrorIndicator(Package pkg, int errorIdentifier) {
        if (DataCollector.dontSend()) {
            return;
        }
        if (shownErrorIndicators.get(errorIdentifier)) {
            return;
        }
        if (createdErrors.get(errorIdentifier)) {
            DataCollectorImpl.showErrorIndicator(pkg, errorIdentifier);
        }
        shownErrorIndicators.set(errorIdentifier);
    }

    public static void showErrorMessage(Package pkg, int errorIdentifier, List<String> quickFixes) {
        if (DataCollector.dontSend()) {
            return;
        }
        if (shownErrorMessages.get(errorIdentifier)) {
            return;
        }
        shownErrorMessages.set(errorIdentifier);
        DataCollectorImpl.showErrorMessage(pkg, errorIdentifier, quickFixes);
    }

    public static void fixExecuted(Package aPackage, int errorIdentifier, int fixIndex) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.fixExecuted(aPackage, errorIdentifier, fixIndex);
    }

    public static void recordGreenfootEvent(Project project, GreenfootInterfaceEvent event) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.greenfootEvent(project, project.getPackage(""), event);
    }

    public static void codeCompletionStarted(ClassTarget ct, Integer lineNumber, Integer columnNumber, String xpath, Integer subIndex, String stem) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.codeCompletionStarted(ct.getPackage().getProject(), ct.getPackage(), lineNumber, columnNumber, xpath, subIndex, stem);
    }

    public static void codeCompletionEnded(ClassTarget ct, Integer lineNumber, Integer columnNumber, String xpath, Integer subIndex, String stem, String replacement) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.codeCompletionEnded(ct.getPackage().getProject(), ct.getPackage(), lineNumber, columnNumber, xpath, subIndex, stem, replacement);
    }

    public static void unknownFrameCommandKey(ClassTarget ct, String enclosingFrameXpath, int cursorIndex, char key) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.unknownFrameCommandKey(ct.getPackage().getProject(), ct.getPackage(), enclosingFrameXpath, cursorIndex, key);
    }

    public static boolean hasGivenUp() {
        return DataSubmitter.hasGivenUp();
    }

    public static void fixtureToObjectBench(Package pkg, File sourceFile, List<NamedTyped> objects) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.fixtureToObjectBench(pkg, sourceFile, objects);
    }

    public static void objectBenchToFixture(Package pkg, File sourceFile, List<String> benchNames) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.objectBenchToFixture(pkg, sourceFile, benchNames);
    }

    public static void showHideTerminal(Project project, boolean show) {
        if (DataCollector.dontSend()) {
            return;
        }
        DataCollectorImpl.showHideTerminal(project, show);
    }

    static {
        shownErrorMessages = new BitSet();
        shownErrorIndicators = new BitSet();
        createdErrors = new BitSet();
    }

    public static class NamedTyped {
        private String name;
        private String type;

        public NamedTyped(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }
}

