/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.extensions.BClassTarget;
import bluej.extensions.BPackage;
import bluej.extensions.BProject;
import bluej.extensions.ExtensionException;
import bluej.extensions.ExtensionUnloadedException;
import bluej.extensions.Identifier;
import bluej.extensions.MenuGenerator;
import bluej.extensions.PreferenceGenerator;
import bluej.extensions.event.ApplicationEvent;
import bluej.extensions.event.ApplicationListener;
import bluej.extensions.event.ClassEvent;
import bluej.extensions.event.ClassListener;
import bluej.extensions.event.ClassListener2;
import bluej.extensions.event.ClassTargetEvent;
import bluej.extensions.event.ClassTargetListener;
import bluej.extensions.event.CompileEvent;
import bluej.extensions.event.CompileListener;
import bluej.extensions.event.DependencyEvent;
import bluej.extensions.event.DependencyListener;
import bluej.extensions.event.ExtensionEvent;
import bluej.extensions.event.ExtensionEventListener;
import bluej.extensions.event.InvocationEvent;
import bluej.extensions.event.InvocationListener;
import bluej.extensions.event.PackageEvent;
import bluej.extensions.event.PackageListener;
import bluej.extensions.painter.ExtensionClassTargetPainter;
import bluej.extmgr.ExtensionMenu;
import bluej.extmgr.ExtensionPrefManager;
import bluej.extmgr.ExtensionWrapper;
import bluej.pkgmgr.Layer;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JMenuItem;

public final class BlueJ {
    public static final int SE_PROJECT = 0;
    public static final int ME_PROJECT = 1;
    private final ExtensionWrapper myWrapper;
    private final ExtensionPrefManager prefManager;
    private PreferenceGenerator currentPrefGen = null;
    private MenuGenerator currentMenuGen = null;
    private ExtensionClassTargetPainter currentClassTargetPainter;
    private Properties localLabels;
    private ArrayList<ExtensionEventListener> eventListeners;
    private ArrayList<ApplicationListener> applicationListeners;
    private ArrayList<PackageListener> packageListeners;
    private ArrayList<CompileListener> compileListeners;
    private ArrayList<InvocationListener> invocationListeners;
    private ArrayList<ClassListener> classListeners;
    private List<DependencyListener> dependencyListeners;
    private List<ClassTargetListener> classTargetListeners;

    BlueJ(ExtensionWrapper aWrapper, ExtensionPrefManager aPrefManager) {
        this.myWrapper = aWrapper;
        this.prefManager = aPrefManager;
        this.eventListeners = new ArrayList();
        this.applicationListeners = new ArrayList();
        this.packageListeners = new ArrayList();
        this.compileListeners = new ArrayList();
        this.invocationListeners = new ArrayList();
        this.classListeners = new ArrayList();
        this.dependencyListeners = new ArrayList<DependencyListener>();
        this.classTargetListeners = new ArrayList<ClassTargetListener>();
        this.localLabels = this.myWrapper.getLabelProperties();
    }

    public final BProject openProject(File directory) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        if (directory == null) {
            return null;
        }
        Project openProj = Project.openProject((String)directory.getAbsolutePath());
        if (openProj == null) {
            return null;
        }
        Package pkg = openProj.getCachedPackage(openProj.getInitialPackageName());
        if (pkg == null) {
            return null;
        }
        Identifier aProject = new Identifier(openProj, pkg);
        try {
            aProject.getPackageFrame();
        }
        catch (ExtensionException extensionException) {
            // empty catch block
        }
        return openProj.getBProject();
    }

    public BProject newProject(File directory, int projectType) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        String pathString = directory.getAbsolutePath();
        if (!pathString.endsWith(File.separator)) {
            pathString = pathString + File.separator;
        }
        if (!Project.createNewProject((String)pathString)) {
            return null;
        }
        return this.openProject(directory);
    }

    public BProject newProject(File directory) {
        return this.newProject(directory, 0);
    }

    public BProject[] getOpenProjects() {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        Collection projects = Project.getProjects();
        BProject[] result = new BProject[projects.size()];
        Iterator iter = projects.iterator();
        int index = 0;
        while (iter.hasNext()) {
            Project prj = (Project)iter.next();
            result[index] = prj.getBProject();
            ++index;
        }
        return result;
    }

    public BPackage getCurrentPackage() {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        PkgMgrFrame pmf = PkgMgrFrame.getMostRecent();
        if (pmf == null) {
            return null;
        }
        Package pkg = pmf.getPackage();
        if (pkg == null) {
            return null;
        }
        return pkg.getBPackage();
    }

    public Frame getCurrentFrame() {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        return PkgMgrFrame.getMostRecent().getWindow();
    }

    public void setMenuGenerator(MenuGenerator menuGen) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        this.currentMenuGen = menuGen;
    }

    public MenuGenerator getMenuGenerator() {
        return this.currentMenuGen;
    }

    public void setPreferenceGenerator(PreferenceGenerator prefGen) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        this.currentPrefGen = prefGen;
        this.prefManager.panelRevalidate();
    }

    public PreferenceGenerator getPreferenceGenerator() {
        return this.currentPrefGen;
    }

    public void setClassTargetPainter(ExtensionClassTargetPainter classTargetPainter) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        this.currentClassTargetPainter = classTargetPainter;
    }

    public ExtensionClassTargetPainter getClassTargetPainter() {
        return this.currentClassTargetPainter;
    }

    public File getSystemLibDir() {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        return Config.getBlueJLibDir();
    }

    public File getUserConfigDir() {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        return Config.getUserConfigDir();
    }

    public String getDataCollectionUniqueID() {
        return DataCollector.getUserID();
    }

    public String getBlueJPropertyString(String property, String def) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        return Config.getPropString((String)property, (String)def);
    }

    public String getExtensionPropertyString(String property, String def) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        String thisKey = this.myWrapper.getSettingsString(property);
        return Config.getPropString((String)thisKey, (String)def);
    }

    public void setExtensionPropertyString(String property, String value) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        String thisKey = this.myWrapper.getSettingsString(property);
        if (value != null) {
            Config.putPropString((String)thisKey, (String)value);
        } else {
            Config.removeProperty((String)thisKey);
        }
    }

    public String getLabel(String key) {
        if (!this.myWrapper.isValid()) {
            throw new ExtensionUnloadedException();
        }
        if (this.localLabels == null) {
            return Config.getString((String)key, (String)key);
        }
        String aLabel = this.localLabels.getProperty(key, null);
        if (aLabel != null) {
            return aLabel;
        }
        return Config.getString((String)key, (String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtensionEventListener(ExtensionEventListener listener) {
        if (listener != null) {
            ArrayList<ExtensionEventListener> arrayList = this.eventListeners;
            synchronized (arrayList) {
                this.eventListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtensionEventListener(ExtensionEventListener listener) {
        if (listener != null) {
            ArrayList<ExtensionEventListener> arrayList = this.eventListeners;
            synchronized (arrayList) {
                this.eventListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationListener(ApplicationListener listener) {
        if (listener != null) {
            ArrayList<ApplicationListener> arrayList = this.applicationListeners;
            synchronized (arrayList) {
                this.applicationListeners.add(listener);
            }
            if (DataCollector.hasGivenUp()) {
                listener.dataSubmissionFailed(new ApplicationEvent(2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationListener(ApplicationListener listener) {
        if (listener != null) {
            ArrayList<ApplicationListener> arrayList = this.applicationListeners;
            synchronized (arrayList) {
                this.applicationListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackageListener(PackageListener listener) {
        if (listener != null) {
            ArrayList<PackageListener> arrayList = this.packageListeners;
            synchronized (arrayList) {
                this.packageListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePackageListener(PackageListener listener) {
        if (listener != null) {
            ArrayList<PackageListener> arrayList = this.packageListeners;
            synchronized (arrayList) {
                this.packageListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompileListener(CompileListener listener) {
        if (listener != null) {
            ArrayList<CompileListener> arrayList = this.compileListeners;
            synchronized (arrayList) {
                this.compileListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompileListener(CompileListener listener) {
        if (listener != null) {
            ArrayList<CompileListener> arrayList = this.compileListeners;
            synchronized (arrayList) {
                this.compileListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvocationListener(InvocationListener listener) {
        if (listener != null) {
            ArrayList<InvocationListener> arrayList = this.invocationListeners;
            synchronized (arrayList) {
                this.invocationListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvocationListener(InvocationListener listener) {
        if (listener != null) {
            ArrayList<InvocationListener> arrayList = this.invocationListeners;
            synchronized (arrayList) {
                this.invocationListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassListener(ClassListener listener) {
        if (listener != null) {
            ArrayList<ClassListener> arrayList = this.classListeners;
            synchronized (arrayList) {
                this.classListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassListener(ClassListener listener) {
        if (listener != null) {
            ArrayList<ClassListener> arrayList = this.classListeners;
            synchronized (arrayList) {
                this.classListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependencyListener(DependencyListener listener) {
        if (listener != null) {
            List<DependencyListener> list = this.dependencyListeners;
            synchronized (list) {
                this.dependencyListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDependencyListener(DependencyListener listener) {
        if (listener != null) {
            List<DependencyListener> list = this.dependencyListeners;
            synchronized (list) {
                this.dependencyListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassTargetListener(ClassTargetListener listener) {
        if (listener != null) {
            List<ClassTargetListener> list = this.classTargetListeners;
            synchronized (list) {
                this.classTargetListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassTargetListener(ClassTargetListener listener) {
        if (listener != null) {
            List<ClassTargetListener> list = this.classTargetListeners;
            synchronized (list) {
                this.classTargetListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateExtensionEvent(ExtensionEvent event) {
        ExtensionEventListener[] listeners;
        ArrayList<ExtensionEventListener> arrayList = this.eventListeners;
        synchronized (arrayList) {
            listeners = this.eventListeners.toArray(new ExtensionEventListener[this.eventListeners.size()]);
        }
        for (int i = 0; i < listeners.length; ++i) {
            ExtensionEventListener eventListener = listeners[i];
            eventListener.eventOccurred(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateApplicationEvent(ApplicationEvent event) {
        ApplicationListener[] listeners;
        ArrayList<ApplicationListener> arrayList = this.applicationListeners;
        synchronized (arrayList) {
            listeners = this.applicationListeners.toArray(new ApplicationListener[this.applicationListeners.size()]);
        }
        for (int i = 0; i < listeners.length; ++i) {
            ApplicationListener eventListener = listeners[i];
            if (event.getEvent() == 1) {
                eventListener.blueJReady(event);
                continue;
            }
            if (event.getEvent() != 2) continue;
            eventListener.dataSubmissionFailed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegatePackageEvent(PackageEvent event) {
        PackageListener[] listeners;
        ArrayList<PackageListener> arrayList = this.packageListeners;
        synchronized (arrayList) {
            listeners = this.packageListeners.toArray(new PackageListener[this.packageListeners.size()]);
        }
        int thisEvent = event.getEvent();
        for (int i = 0; i < listeners.length; ++i) {
            PackageListener eventListener = listeners[i];
            if (thisEvent == 1) {
                eventListener.packageOpened(event);
            }
            if (thisEvent != 2) continue;
            eventListener.packageClosing(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateCompileEvent(CompileEvent event) {
        CompileListener[] listeners;
        ArrayList<CompileListener> arrayList = this.compileListeners;
        synchronized (arrayList) {
            listeners = this.compileListeners.toArray(new CompileListener[this.compileListeners.size()]);
        }
        int thisEvent = event.getEvent();
        for (int i = 0; i < listeners.length; ++i) {
            CompileListener eventListener = listeners[i];
            if (thisEvent == 1) {
                eventListener.compileStarted(event);
            }
            if (thisEvent == 3) {
                eventListener.compileError(event);
            }
            if (thisEvent == 2) {
                eventListener.compileWarning(event);
            }
            if (thisEvent == 5) {
                eventListener.compileFailed(event);
            }
            if (thisEvent != 4) continue;
            eventListener.compileSucceeded(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateInvocationEvent(InvocationEvent event) {
        InvocationListener[] listeners;
        ArrayList<InvocationListener> arrayList = this.invocationListeners;
        synchronized (arrayList) {
            listeners = this.invocationListeners.toArray(new InvocationListener[this.invocationListeners.size()]);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].invocationFinished(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateClassEvent(ClassEvent event) {
        ClassListener[] listeners;
        ArrayList<ClassListener> arrayList = this.classListeners;
        synchronized (arrayList) {
            listeners = this.classListeners.toArray(new ClassListener[this.classListeners.size()]);
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (event.getEventId() == 2) {
                if (!(listeners[i] instanceof ClassListener2)) continue;
                ((ClassListener2)listeners[i]).classRemoved(event);
                continue;
            }
            listeners[i].classStateChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateDependencyEvent(DependencyEvent event) {
        ArrayList<DependencyListener> listeners = new ArrayList<DependencyListener>();
        List<DependencyListener> list = this.dependencyListeners;
        synchronized (list) {
            listeners.addAll(this.dependencyListeners);
        }
        for (DependencyListener dependencyListener : listeners) {
            switch (event.getEventType()) {
                case DEPENDENCY_ADDED: {
                    dependencyListener.dependencyAdded(event);
                    break;
                }
                case DEPENDENCY_REMOVED: {
                    dependencyListener.dependencyRemoved(event);
                    break;
                }
                case DEPENDENCY_HIDDEN: 
                case DEPENDENCY_SHOWN: {
                    dependencyListener.dependencyVisibilityChanged(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateClassTargetEvent(ClassTargetEvent event) {
        ArrayList<ClassTargetListener> listeners = new ArrayList<ClassTargetListener>();
        List<ClassTargetListener> list = this.classTargetListeners;
        synchronized (list) {
            listeners.addAll(this.classTargetListeners);
        }
        for (ClassTargetListener classTargetListener : listeners) {
            classTargetListener.classTargetVisibilityChanged(event);
        }
    }

    void delegateEvent(ExtensionEvent event) {
        this.delegateExtensionEvent(event);
        if (event instanceof ApplicationEvent) {
            this.delegateApplicationEvent((ApplicationEvent)event);
        } else if (event instanceof PackageEvent) {
            this.delegatePackageEvent((PackageEvent)event);
        } else if (event instanceof CompileEvent) {
            this.delegateCompileEvent((CompileEvent)event);
        } else if (event instanceof InvocationEvent) {
            this.delegateInvocationEvent((InvocationEvent)event);
        } else if (event instanceof ClassEvent) {
            this.delegateClassEvent((ClassEvent)event);
        } else if (event instanceof DependencyEvent) {
            this.delegateDependencyEvent((DependencyEvent)event);
        } else if (event instanceof ClassTargetEvent) {
            this.delegateClassTargetEvent((ClassTargetEvent)event);
        }
    }

    JMenuItem getMenuItem(ExtensionMenu attachedObject) {
        if (this.currentMenuGen == null || attachedObject == null) {
            return null;
        }
        return attachedObject.getMenuItem(this.currentMenuGen);
    }

    void postMenuItem(ExtensionMenu attachedObject, JMenuItem onThisItem) {
        if (this.currentMenuGen != null && attachedObject != null) {
            attachedObject.postMenuItem(this.currentMenuGen, onThisItem);
        }
    }

    void drawExtensionClassTarget(Layer layer, BClassTarget bClassTarget, Graphics2D graphics, int width, int height) {
        if (this.currentClassTargetPainter != null) {
            switch (layer) {
                case BACKGROUND: {
                    this.currentClassTargetPainter.drawClassTargetBackground(bClassTarget, graphics, width, height);
                    break;
                }
                case FOREGROUND: {
                    this.currentClassTargetPainter.drawClassTargetForeground(bClassTarget, graphics, width, height);
                }
            }
        }
    }
}

