/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.compiler.JobQueue;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.BClass;
import bluej.extensions.BClassTarget;
import bluej.extensions.BDependency;
import bluej.extensions.BObject;
import bluej.extensions.BProject;
import bluej.extensions.CompilationNotStartedException;
import bluej.extensions.ExtensionException;
import bluej.extensions.Identifier;
import bluej.extensions.MissingJavaFileException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.extensions.SourceType;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.DependentTarget;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.Target;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public class BPackage {
    private Identifier packageId;

    @OnThread(value=Tag.Any)
    BPackage(Identifier aPackageId) {
        this.packageId = aPackageId;
    }

    public void remove() throws ProjectNotOpenException, PackageNotFoundException {
        Package bluejPkg = this.packageId.getBluejPackage();
        Package parentPkg = bluejPkg.getParent();
        PackageTarget pkgTarget = (PackageTarget)parentPkg.getTarget(bluejPkg.getBaseName());
        pkgTarget.removeImmediate();
    }

    public BProject getProject() throws ProjectNotOpenException {
        Project bluejProject = this.packageId.getBluejProject();
        return bluejProject.getBProject();
    }

    public String getName() throws ProjectNotOpenException, PackageNotFoundException {
        Package bluejPkg = this.packageId.getBluejPackage();
        return bluejPkg.getQualifiedName();
    }

    public void reload() throws ProjectNotOpenException, PackageNotFoundException {
        Package bluejPkg = this.packageId.getBluejPackage();
        bluejPkg.reload();
    }

    public BClass newClass(String className) throws ProjectNotOpenException, PackageNotFoundException, MissingJavaFileException {
        return this.newClass(className, SourceType.Java);
    }

    public BClass newClass(String className, SourceType sourceType) throws ProjectNotOpenException, PackageNotFoundException, MissingJavaFileException {
        Package bluejPkg = this.packageId.getBluejPackage();
        PkgMgrFrame bluejFrame = this.packageId.getPackageFrame();
        File classJavaFile = new File(bluejPkg.getPath(), className + "." + sourceType.getExtension());
        if (!classJavaFile.canWrite()) {
            throw new MissingJavaFileException(classJavaFile.toString());
        }
        bluejFrame.createNewClass(className, null, sourceType, true, -1.0, -1.0);
        return this.getBClass(className);
    }

    @Deprecated
    public Frame getFrame() throws ProjectNotOpenException, PackageNotFoundException {
        return this.packageId.getPackageFrame().getWindow();
    }

    public BClass getBClass(String name) throws ProjectNotOpenException, PackageNotFoundException {
        this.packageId.getBluejProject();
        Package bluejPkg = this.packageId.getBluejPackage();
        Target aTarget = bluejPkg.getTarget(name);
        if (aTarget == null) {
            return null;
        }
        if (!(aTarget instanceof ClassTarget)) {
            return null;
        }
        ClassTarget classTarget = (ClassTarget)aTarget;
        return classTarget.getBClass();
    }

    public BClass[] getClasses() throws ProjectNotOpenException, PackageNotFoundException {
        this.packageId.getBluejProject();
        Package bluejPkg = this.packageId.getBluejPackage();
        ArrayList classTargets = bluejPkg.getClassTargets();
        BClass[] classes = new BClass[classTargets.size()];
        for (int index = 0; index < classTargets.size(); ++index) {
            ClassTarget target = (ClassTarget)classTargets.get(index);
            classes[index] = target.getBClass();
        }
        return classes;
    }

    public BObject getObject(String instanceName) throws ProjectNotOpenException, PackageNotFoundException {
        if (instanceName == null) {
            return null;
        }
        this.packageId.getBluejPackage();
        PkgMgrFrame pmf = this.packageId.getPackageFrame();
        List objects = pmf.getObjectBench().getObjects();
        for (ObjectWrapper wrapper : objects) {
            if (!instanceName.equals(wrapper.getName())) continue;
            return wrapper.getBObject();
        }
        return null;
    }

    public BObject[] getObjects() throws ProjectNotOpenException, PackageNotFoundException {
        this.packageId.getBluejPackage();
        PkgMgrFrame pmf = this.packageId.getPackageFrame();
        List objectWrappers = pmf.getObjectBench().getObjects();
        BObject[] objects = new BObject[objectWrappers.size()];
        int index = 0;
        for (ObjectWrapper wrapper : objectWrappers) {
            objects[index] = wrapper.getBObject();
            ++index;
        }
        return objects;
    }

    public void compile(boolean waitCompileEnd) throws ProjectNotOpenException, PackageNotFoundException, CompilationNotStartedException {
        Package bluejPkg = this.packageId.getBluejPackage();
        if (!bluejPkg.isDebuggerIdle()) {
            throw new CompilationNotStartedException("BlueJ is currently executing Java code");
        }
        bluejPkg.compile(CompileReason.EXTENSION, CompileType.EXTENSION);
        if (waitCompileEnd) {
            JobQueue.getJobQueue().waitForEmptyQueue();
        }
    }

    public void compileAll(boolean waitCompileEnd) throws ProjectNotOpenException, PackageNotFoundException, CompilationNotStartedException {
        Package bluejPkg = this.packageId.getBluejPackage();
        if (!bluejPkg.isDebuggerIdle()) {
            throw new CompilationNotStartedException("BlueJ is currently executing Java code");
        }
        bluejPkg.rebuild();
        if (waitCompileEnd) {
            JobQueue.getJobQueue().waitForEmptyQueue();
        }
    }

    public BClass[] getCurrentClasses() throws ProjectNotOpenException, PackageNotFoundException {
        Package bluejPkg = this.packageId.getBluejPackage();
        List targets = bluejPkg.getSelectedTargets();
        ArrayList<BClass> aList = new ArrayList<BClass>();
        for (Target t : targets) {
            if (!(t instanceof ClassTarget)) continue;
            ClassTarget target = (ClassTarget)t;
            aList.add(target.getBClass());
        }
        return aList.toArray(new BClass[aList.size()]);
    }

    public BObject[] getCurrentObjects() throws ProjectNotOpenException, PackageNotFoundException {
        PkgMgrFrame bluejFrame = this.packageId.getPackageFrame();
        ObjectBench aBench = bluejFrame.getObjectBench();
        if (aBench == null) {
            return new BObject[0];
        }
        ArrayList<BObject> aList = new ArrayList<BObject>();
        ObjectWrapper aWrapper = aBench.getSelectedObject();
        if (aWrapper != null) {
            aList.add(aWrapper.getBObject());
        }
        return aList.toArray(new BObject[aList.size()]);
    }

    public File getDir() throws ProjectNotOpenException, PackageNotFoundException {
        Package aPkg = this.packageId.getBluejPackage();
        return aPkg.getPath();
    }

    public BDependency getDependency(BClassTarget from, BClassTarget to, BDependency.Type type) throws ProjectNotOpenException, PackageNotFoundException {
        Package bluejPackage = this.packageId.getBluejPackage();
        Dependency dependency = bluejPackage.getEditor().getDependency((DependentTarget)from.getClassTarget(), (DependentTarget)to.getClassTarget(), type);
        return dependency != null ? dependency.getBDependency() : null;
    }

    public String toString() {
        try {
            Package bluejPkg = this.packageId.getBluejPackage();
            return "BPackage: " + bluejPkg.getQualifiedName();
        }
        catch (ExtensionException exc) {
            return "BPackage: INVALID";
        }
    }

    public void scheduleCompilation(boolean immediate) throws ProjectNotOpenException, PackageNotFoundException {
        Package bjPkg = this.packageId.getBluejPackage();
        Project bjProject = bjPkg.getProject();
        bjProject.scheduleCompilation(immediate, CompileReason.EXTENSION, CompileType.EXTENSION, bjPkg);
    }

    PkgMgrFrame getPkgMgrFrame() throws ProjectNotOpenException, PackageNotFoundException {
        return this.packageId.getPackageFrame();
    }
}

