/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.Config;
import bluej.editor.stride.FXTab;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.TabMenuManager;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.web.WebView;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
public class WebTab
extends FXTab {
    private final WebView browser = new WebView();
    private FXTabbedEditor parent;
    private final TabMenuManager menuManager;

    @OnThread(value=Tag.FXPlatform)
    public WebTab(String url) {
        super(false);
        this.browser.getEngine().load(url);
        this.setGraphic(this.getWebIcon());
        this.setContent((Node)this.browser);
        this.textProperty().bind((ObservableValue)this.browser.getEngine().titleProperty());
        this.menuManager = new TabMenuManager(this){
            final List<Menu> menus;
            {
                this.menus = Collections.singletonList(JavaFXUtil.makeMenu((String)Config.getString((String)"frame.webmenu.title"), (MenuItem[])new MenuItem[]{this.mainMoveMenu, JavaFXUtil.makeMenuItem((String)Config.getString((String)"frame.webmenu.open.external"), () -> Utility.openWebBrowser((String)WebTab.this.browser.getEngine().getLocation()), (KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})), JavaFXUtil.makeMenuItem((String)Config.getString((String)"frame.classmenu.close"), () -> this.tab.getParent().close(this.tab), (KeyCombination)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}))}));
            }

            @Override
            List<Menu> getMenus() {
                this.updateMoveMenus();
                return this.menus;
            }
        };
    }

    private Node getWebIcon() {
        Label j = new Label("W");
        JavaFXUtil.addStyleClass((Styleable)j, (String[])new String[]{"icon-label"});
        return j;
    }

    @Override
    void focusWhenShown() {
    }

    @Override
    List<Menu> getMenus() {
        return this.menuManager.getMenus();
    }

    @Override
    String getWebAddress() {
        return this.browser.getEngine().getLocation();
    }

    @Override
    void initialiseFX() {
    }

    @Override
    void setParent(FXTabbedEditor parent, boolean partOfMove) {
        this.parent = parent;
    }

    @Override
    FXTabbedEditor getParent() {
        return this.parent;
    }

    @Override
    ObservableStringValue windowTitleProperty() {
        return this.textProperty();
    }

    @Override
    public void notifySelected() {
    }

    @Override
    public void notifyUnselected() {
    }
}

