/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.editor.stride.FrameShelf;
import bluej.stride.framedjava.frames.GreenfootFrameUtil;
import bluej.stride.generic.Frame;
import bluej.utility.Debug;
import bluej.utility.Utility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import javafx.collections.ListChangeListener;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;
import threadchecker.OnThread;
import threadchecker.Tag;

public class FrameShelfStorage {
    private final IdentityHashMap<FrameShelf, ListChangeListener<Frame>> shelves = new IdentityHashMap();
    private Element contentXML;
    private final File shelfFilename;
    private boolean updatingShelves = false;

    @OnThread(value=Tag.Any)
    public FrameShelfStorage(File projectDir) {
        this.shelfFilename = new File(projectDir, "shelf.xml");
        try {
            Document xml = new Builder().build(this.shelfFilename);
            this.contentXML = xml.getRootElement();
            if (!this.contentXML.getLocalName().equals("frames")) {
                throw new IOException("XML top-level element not \"frames\" as expected");
            }
        }
        catch (IOException | ParsingException e) {
            this.contentXML = new Element("frames");
        }
    }

    public void registerShelf(FrameShelf shelfInterface) {
        ListChangeListener listener = c -> this.pullFrom(shelfInterface);
        this.shelves.put(shelfInterface, (ListChangeListener<Frame>)listener);
        shelfInterface.setContent(this.contentXML);
        shelfInterface.getContent().addListener(listener);
    }

    public void deregisterShelf(FrameShelf shelfInterface) {
        shelfInterface.getContent().removeListener(this.shelves.remove(shelfInterface));
    }

    private void pullFrom(FrameShelf changed) {
        if (this.updatingShelves) {
            return;
        }
        this.contentXML = GreenfootFrameUtil.getXmlElementForMultipleFrames(changed.getContent());
        this.updatingShelves = true;
        this.shelves.forEach((shelf, listener) -> {
            if (shelf != changed) {
                shelf.setContent(this.contentXML);
            }
        });
        this.save();
        this.updatingShelves = false;
    }

    private void save() {
        try (FileOutputStream os = new FileOutputStream(this.shelfFilename);){
            Utility.serialiseCodeTo((Element)this.contentXML, (OutputStream)os);
        }
        catch (IOException e) {
            Debug.reportError((String)"Cannot save shelf contents", (Throwable)e);
        }
    }
}

