/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.Main;
import bluej.editor.stride.FXTab;
import bluej.editor.stride.FrameCatalogue;
import bluej.editor.stride.FrameEditorTab;
import bluej.editor.stride.FrameSelection;
import bluej.editor.stride.FrameShelf;
import bluej.editor.stride.MoeFXTab;
import bluej.editor.stride.WebTab;
import bluej.editor.stride.WindowOverlayPane;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCursor;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXSupplier;
import bluej.utility.javafx.JavaFXUtil;
import java.awt.AWTKeyStroke;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.control.MenuBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Scale;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
public class FXTabbedEditor {
    private final SimpleBooleanProperty showingCatalogue = new SimpleBooleanProperty(true);
    private final Project project;
    private final ArrayList<Frame> dragSourceFrames = new ArrayList();
    private final SimpleDoubleProperty mouseDragXProperty = new SimpleDoubleProperty();
    private final SimpleDoubleProperty mouseDragYProperty = new SimpleDoubleProperty();
    private Rectangle startSize;
    private Stage stage;
    private Scene scene;
    private TabPane tabPane;
    private Pane dragPane;
    private Pane dragCursorPane;
    private WindowOverlayPane overlayPane;
    private FrameCatalogue cataloguePane;
    private MenuBar menuBar;
    private Tab hoverTab;
    private FXPlatformRunnable hoverTabTask;
    private ImageView dragIcon = null;
    private @OnThread(value=Tag.Any) String projectTitle;
    private final @OnThread(value=Tag.Any) AtomicBoolean stageShowingSwing = new AtomicBoolean(false);
    private StringProperty titleStatus = new SimpleStringProperty("");
    private BorderPane collapsibleCatalogueScrollPane;
    private FrameShelf shelf;
    private boolean dragFromShelf;
    private @OnThread(value=Tag.FXPlatform) FXPlatformRunnable cancelWiggle;

    @OnThread(value=Tag.Any)
    public FXTabbedEditor(Project project, Rectangle startSize) {
        this.project = project;
        this.startSize = startSize;
    }

    @OnThread(value=Tag.Swing)
    public static void disableCtrlTabTraversal(JComponent component) {
        KeyStroke ctrlTab = KeyStroke.getKeyStroke("ctrl TAB");
        KeyStroke ctrlShiftTab = KeyStroke.getKeyStroke("ctrl shift TAB");
        HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(component.getFocusTraversalKeys(0));
        forwardKeys.remove(ctrlTab);
        component.setFocusTraversalKeys(0, forwardKeys);
        HashSet<AWTKeyStroke> backwardKeys = new HashSet<AWTKeyStroke>(component.getFocusTraversalKeys(1));
        backwardKeys.remove(ctrlShiftTab);
        component.setFocusTraversalKeys(1, backwardKeys);
    }

    static boolean isUselessDrag(FrameCursor dragTarget, List<Frame> dragging, boolean copying) {
        return !copying && (dragging.contains(dragTarget.getFrameAfter()) || dragging.contains(dragTarget.getFrameBefore()));
    }

    @OnThread(value=Tag.FXPlatform)
    public void initialise() {
        this.projectTitle = this.project.getProjectName();
        this.stage = new Stage();
        BlueJTheme.setWindowIconFX((Stage)this.stage);
        JavaFXUtil.addChangeListener((ObservableValue)this.stage.showingProperty(), this.stageShowingSwing::set);
        this.initialiseFX();
    }

    @OnThread(value=Tag.FXPlatform)
    private void initialiseFX() {
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(Main.getStoredContextClassLoader());
        }
        Config.loadFXFonts();
        this.tabPane = new TabPane();
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
        this.menuBar = new MenuBar();
        JavaFXUtil.addStyleClass((Styleable)this.menuBar, (String[])new String[]{"editor-menubar"});
        this.menuBar.setUseSystemMenuBar(true);
        this.dragPane = new Pane();
        this.dragPane.setMouseTransparent(true);
        this.dragCursorPane = new Pane();
        this.dragCursorPane.setMouseTransparent(true);
        this.cataloguePane = new FrameCatalogue();
        BorderPane menuAndTabPane = new BorderPane();
        menuAndTabPane.setTop((Node)this.menuBar);
        this.overlayPane = new WindowOverlayPane();
        menuAndTabPane.setCenter((Node)new StackPane(new Node[]{this.tabPane}));
        this.shelf = new FrameShelf(this, this.project.getShelfStorage());
        ScrollPane catalogueScrollPane = new ScrollPane((Node)this.cataloguePane){

            public void requestFocus() {
            }
        };
        catalogueScrollPane.setMaxWidth(220.0);
        catalogueScrollPane.setMinWidth(0.0);
        catalogueScrollPane.setFitToWidth(true);
        catalogueScrollPane.setFocusTraversable(false);
        catalogueScrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        catalogueScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        JavaFXUtil.addStyleClass((Styleable)catalogueScrollPane, (String[])new String[]{"catalogue-scroll"});
        BorderPane catalogueBackground = new BorderPane();
        JavaFXUtil.addStyleClass((Styleable)catalogueBackground, (String[])new String[]{"catalogue-background"});
        Label title = new Label(Config.getString((String)"frame.catalogue.title"));
        BorderPane.setAlignment((Node)title, (Pos)Pos.BOTTOM_RIGHT);
        catalogueBackground.setBottom((Node)title);
        StackPane catalogueScrollPaneStacked = new StackPane(new Node[]{catalogueBackground, catalogueScrollPane});
        this.collapsibleCatalogueScrollPane = new BorderPane();
        this.collapsibleCatalogueScrollPane.setCenter((Node)catalogueScrollPaneStacked);
        catalogueScrollPaneStacked.setMinWidth(0.0);
        CollapseControl collapseControl = new CollapseControl((Region)catalogueScrollPaneStacked, (FXConsumer<Boolean>)((FXConsumer)showing -> catalogueScrollPane.setVbarPolicy(showing != false ? ScrollPane.ScrollBarPolicy.AS_NEEDED : ScrollPane.ScrollBarPolicy.NEVER)));
        JavaFXUtil.addChangeListener((ObservableValue)this.showingCatalogue, expanded -> PrefMgr.setFlag((String)"bluej.editor.stride.sidebarShowing", (boolean)expanded));
        JavaFXUtil.runAfterCurrent(() -> this.showingCatalogue.set(PrefMgr.getFlag((String)"bluej.editor.stride.sidebarShowing")));
        this.collapsibleCatalogueScrollPane.setLeft((Node)collapseControl);
        JavaFXUtil.addStyleClass((Styleable)this.collapsibleCatalogueScrollPane, (String[])new String[]{"catalogue-scroll-collapsible"});
        menuAndTabPane.setRight((Node)this.collapsibleCatalogueScrollPane);
        this.scene = new Scene((Parent)new StackPane(new Node[]{menuAndTabPane, this.dragPane, this.dragCursorPane, this.overlayPane.getNode()}), 800.0, 700.0);
        this.stage.setScene(this.scene);
        Config.addEditorStylesheets((Scene)this.scene);
        this.tabPane.getStyleClass().add((Object)"tabbed-editor");
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((a, prevSel, selTab) -> {
            if (selTab != null) {
                this.updateMenusForTab((FXTab)((Object)selTab));
            }
            if (prevSel != null && prevSel != selTab) {
                ((FXTab)((Object)prevSel)).notifyUnselected();
            }
            if (selTab != null && this.stage.isFocused()) {
                ((FXTab)((Object)selTab)).notifySelected();
            }
            if (selTab != null && ((FXTab)((Object)selTab)).shouldShowCatalogue()) {
                this.collapsibleCatalogueScrollPane.setVisible(true);
                this.collapsibleCatalogueScrollPane.setManaged(true);
            } else {
                this.collapsibleCatalogueScrollPane.setVisible(false);
                this.collapsibleCatalogueScrollPane.setManaged(false);
            }
            if (this.isWindowVisible() && !(selTab instanceof FrameEditorTab)) {
                JavaFXUtil.runPlatformLater(() -> this.scheduleUpdateCatalogue(null, null, CodeCompletionState.NOT_POSSIBLE, false, Frame.View.NORMAL, Collections.emptyList(), Collections.emptyList()));
            }
        });
        this.tabPane.getTabs().addListener(e -> {
            if (this.tabPane.getTabs().isEmpty()) {
                this.startSize = new Rectangle((int)this.stage.getX(), (int)this.stage.getY(), (int)this.stage.getWidth(), (int)this.stage.getHeight());
                this.stage.close();
                this.project.removeFXTabbedEditor(this);
            }
        });
        this.stage.setOnHidden(e -> {
            ArrayList tabs = new ArrayList(this.tabPane.getTabs());
            tabs.forEach(t -> this.close((FXTab)((Object)((Object)t))));
        });
        JavaFXUtil.addChangeListener((ObservableValue)this.stage.focusedProperty(), focused -> {
            if (focused.booleanValue()) {
                ((FXTab)((Object)((Object)this.tabPane.getSelectionModel().getSelectedItem()))).notifySelected();
            } else {
                ((FXTab)((Object)((Object)this.tabPane.getSelectionModel().getSelectedItem()))).notifyUnselected();
            }
        });
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.stage.iconifiedProperty(), minimised -> {
            if (minimised.booleanValue()) {
                ((FXTab)((Object)((Object)this.tabPane.getSelectionModel().getSelectedItem()))).notifyUnselected();
            }
        });
        JavaFXUtil.addChangeListener((ObservableValue)this.tabPane.focusedProperty(), focused -> {
            if (focused.booleanValue()) {
                FXTab tab = (FXTab)((Object)((Object)this.tabPane.getSelectionModel().getSelectedItem()));
                tab.focusWhenShown();
            }
        });
        this.tabPane.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (!e.isShortcutDown()) {
                return;
            }
            int tab = this.tabPane.getSelectionModel().getSelectedIndex();
            switch (e.getCode()) {
                case DIGIT1: {
                    tab = 0;
                    break;
                }
                case DIGIT2: {
                    tab = 1;
                    break;
                }
                case DIGIT3: {
                    tab = 2;
                    break;
                }
                case DIGIT4: {
                    tab = 3;
                    break;
                }
                case DIGIT5: {
                    tab = 4;
                    break;
                }
                case DIGIT6: {
                    tab = 5;
                    break;
                }
                case DIGIT7: {
                    tab = 6;
                    break;
                }
                case DIGIT8: {
                    tab = 7;
                    break;
                }
                case DIGIT9: {
                    tab = 8;
                    break;
                }
                case TAB: {
                    if (e.isShiftDown()) {
                        if (--tab >= 0) break;
                        tab = this.tabPane.getTabs().size() - 1;
                        break;
                    }
                    tab = (tab + 1) % this.tabPane.getTabs().size();
                    break;
                }
                default: {
                    return;
                }
            }
            if (tab < this.tabPane.getTabs().size()) {
                this.tabPane.getSelectionModel().select(this.tabPane.getTabs().get(tab));
            }
            e.consume();
        });
        Config.loadFXFonts();
        this.stage.titleProperty().bind((ObservableValue)Bindings.concat((Object[])new Object[]{JavaFXUtil.apply((ObservableValue)this.tabPane.getSelectionModel().selectedItemProperty(), t -> ((FXTab)((Object)t)).windowTitleProperty(), (Object)"Unknown"), " - ", this.projectTitle, this.titleStatus}));
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.stage.widthProperty(), w -> {
            if (Config.isWinOS() && this.tabPane.getSelectionModel().getSelectedItem() instanceof MoeFXTab) {
                this.scheduleWindowWiggle();
            }
        });
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.stage.heightProperty(), h -> {
            if (Config.isWinOS() && this.tabPane.getSelectionModel().getSelectedItem() instanceof MoeFXTab) {
                this.scheduleWindowWiggle();
            }
        });
    }

    private void updateMenusForTab(FXTab selTab) {
        this.menuBar.getMenus().setAll(selTab.getMenus());
    }

    public BooleanProperty catalogueShowingProperty() {
        return this.showingCatalogue;
    }

    @OnThread(value=Tag.FXPlatform)
    public void addTab(FXTab panel, boolean visible, boolean toFront) {
        this.addTab(panel, visible, toFront, false);
    }

    @OnThread(value=Tag.FXPlatform)
    public void addTab(FXTab panel, boolean visible, boolean toFront, boolean partOfMove) {
        panel.setParent(this, partOfMove);
        panel.initialiseFX();
        if (!this.tabPane.getTabs().contains((Object)panel)) {
            this.tabPane.getTabs().add((Object)panel);
            if (panel instanceof MoeFXTab && !this.stage.isMaximized() && !this.stage.isIconified() && Config.isWinOS()) {
                this.scheduleWindowWiggle();
            }
            if (toFront) {
                this.setWindowVisible(visible, panel);
                this.bringToFront(panel);
                Platform.runLater(panel::focusWhenShown);
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void scheduleWindowWiggle() {
        if (this.cancelWiggle != null) {
            this.cancelWiggle.run();
        }
        this.cancelWiggle = JavaFXUtil.runAfter((Duration)Duration.seconds((double)0.5), () -> {
            if (!this.stage.isMaximized() && !this.stage.isIconified()) {
                double x = this.stage.getX();
                this.stage.setX(x + 1.0);
                JavaFXUtil.runAfterCurrent(() -> this.stage.setX(x));
            }
        });
    }

    @OnThread(value=Tag.FXPlatform)
    public void openJavaCoreDocTab(String qualifiedClassName) {
        this.openJavaCoreDocTab(qualifiedClassName, "");
    }

    @OnThread(value=Tag.FXPlatform)
    public void openJavaCoreDocTab(String qualifiedClassName, String suffix) {
        String target = Utility.getDocURL((String)qualifiedClassName, (String)suffix);
        this.openWebViewTab(target);
    }

    @OnThread(value=Tag.FXPlatform)
    public void openGreenfootDocTab(String qualifiedClassName) {
        this.openGreenfootDocTab(qualifiedClassName, "");
    }

    @OnThread(value=Tag.FXPlatform)
    public void openGreenfootDocTab(String qualifiedClassName, String suffix) {
        try {
            String target = Utility.getGreenfootApiDocURL((String)(qualifiedClassName.replace('.', '/') + ".html"));
            this.openWebViewTab(target + suffix);
        }
        catch (IOException e) {
            Debug.reportError((Throwable)e);
        }
    }

    public void setWindowVisible(boolean visible, Tab tab) {
        if (visible) {
            if (!this.stage.isShowing()) {
                if (this.startSize != null) {
                    this.stage.setX(this.startSize.getX());
                    this.stage.setY(this.startSize.getY());
                    this.stage.setWidth(this.startSize.getWidth());
                    this.stage.setHeight(this.startSize.getHeight());
                }
                this.stage.show();
            }
            if (!this.tabPane.getTabs().contains((Object)tab)) {
                this.tabPane.getTabs().add((Object)tab);
            }
        } else {
            this.tabPane.getTabs().remove((Object)tab);
        }
    }

    public boolean isWindowVisible() {
        return this.stage.isShowing();
    }

    @OnThread(value=Tag.Swing)
    public boolean isWindowVisibleSwing() {
        return this.stageShowingSwing.get();
    }

    public void bringToFront(Tab tab) {
        this.stage.setIconified(false);
        Utility.bringToFrontFX((Stage)this.stage);
        this.tabPane.getSelectionModel().select((Object)tab);
    }

    @OnThread(value=Tag.Any)
    public Project getProject() {
        return this.project;
    }

    public void close(FXTab tab) {
        this.close(tab, false);
    }

    private void close(FXTab tab, boolean partOfMove) {
        this.tabPane.getTabs().remove((Object)tab);
        tab.setParent(null, partOfMove);
    }

    @OnThread(value=Tag.FXPlatform)
    public void openWebViewTab(String url) {
        try {
            URI target = new URI(url);
            for (FXTab tab : this.getFXTabs()) {
                URI tabURI;
                if (tab.getWebAddress() == null || !(tabURI = new URI(tab.getWebAddress())).equals(target)) continue;
                this.bringToFront(tab);
                return;
            }
        }
        catch (URISyntaxException e) {
            Debug.reportError((String)("Error in URI when opening web view tab: \"" + url + "\""));
        }
        this.addTab(new WebTab(url), true, true);
    }

    public ObservableList<Tab> tabsProperty() {
        return this.tabPane.getTabs();
    }

    public Pane getDragPane() {
        return this.dragPane;
    }

    public Pane getDragCursorPane() {
        return this.dragCursorPane;
    }

    public void frameDragBegin(List<Frame> srcFrames, boolean fromShelf, double mouseSceneX, double mouseSceneY) {
        if (this.dragIcon != null || !this.dragSourceFrames.isEmpty()) {
            throw new IllegalStateException("Drag begun while drag in progress");
        }
        this.dragSourceFrames.clear();
        this.dragSourceFrames.addAll(srcFrames);
        Image img = Frame.takeShot(this.dragSourceFrames, null);
        if (this.dragSourceFrames.stream().allMatch(Frame::canDrag) && img != null) {
            ImageView icon = new ImageView(img);
            icon.setEffect((Effect)new DropShadow(7.0, 2.0, 2.0, Color.BLACK));
            for (Frame src : this.dragSourceFrames) {
                src.setDragSourceEffect(true);
            }
            double srcSceneX = this.dragSourceFrames.get(0).getNode().localToScene(0.0, 0.0).getX();
            double srcSceneY = this.dragSourceFrames.get(0).getNode().localToScene(0.0, 0.0).getY();
            icon.layoutXProperty().bind((ObservableValue)this.mouseDragXProperty.subtract(mouseSceneX - srcSceneX));
            icon.layoutYProperty().bind((ObservableValue)this.mouseDragYProperty.subtract(mouseSceneY - srcSceneY));
            this.getDragPane().getChildren().add((Object)icon);
            this.dragIcon = icon;
            this.dragFromShelf = fromShelf;
            this.scene.setCursor(Cursor.CLOSED_HAND);
        } else {
            this.dragSourceFrames.clear();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void draggedTo(double sceneX, double sceneY, JavaFXUtil.DragType dragType) {
        if (!this.dragSourceFrames.isEmpty()) {
            Point2D p = this.dragPane.sceneToLocal(sceneX, sceneY);
            this.mouseDragXProperty.set(p.getX());
            this.mouseDragYProperty.set(p.getY());
            this.checkHoverDuringDrag(sceneX, sceneY, dragType);
            if (this.tabPane.getSelectionModel().getSelectedItem() instanceof FrameEditorTab) {
                ((FrameEditorTab)((Object)this.tabPane.getSelectionModel().getSelectedItem())).draggedToTab(this.dragSourceFrames, sceneX, sceneY, this.calcDragCopy(dragType, false));
            }
            this.shelf.draggedTo(this.dragSourceFrames, sceneX, sceneY, this.calcDragCopy(dragType, true));
        }
    }

    private boolean calcDragCopy(JavaFXUtil.DragType dragType, boolean toShelf) {
        switch (dragType) {
            case FORCE_MOVING: {
                return false;
            }
            case FORCE_COPYING: {
                return true;
            }
        }
        if (this.dragFromShelf && toShelf) {
            return false;
        }
        return this.dragFromShelf && !toShelf;
    }

    public boolean isDragging() {
        return !this.dragSourceFrames.isEmpty();
    }

    @OnThread(value=Tag.FXPlatform)
    private void checkHoverDuringDrag(double sceneX, double sceneY, JavaFXUtil.DragType dragType) {
        for (Tab t : this.tabPane.getTabs()) {
            Bounds b = t.getGraphic().localToScene(t.getGraphic().getBoundsInLocal());
            if (!b.contains(sceneX, sceneY) || this.hoverTab == t || !(t instanceof FrameEditorTab)) continue;
            this.hoverTab = t;
            if (this.hoverTabTask != null) {
                this.hoverTabTask.run();
            }
            this.hoverTabTask = JavaFXUtil.runAfter((Duration)Duration.millis((double)500.0), () -> {
                ((FrameEditorTab)((Object)((Object)this.tabPane.getSelectionModel().getSelectedItem()))).draggedToAnotherTab();
                this.tabPane.getSelectionModel().select((Object)t);
                this.draggedTo(sceneX, sceneY, dragType);
            });
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void frameDragEnd(JavaFXUtil.DragType dragType) {
        if (this.hoverTabTask != null) {
            this.hoverTabTask.run();
        }
        this.hoverTab = null;
        if (!this.dragSourceFrames.isEmpty()) {
            this.getDragPane().getChildren().remove((Object)this.dragIcon);
            this.dragIcon = null;
            this.dragSourceFrames.forEach(f -> f.setDragSourceEffect(false));
            if (this.tabPane.getSelectionModel().getSelectedItem() instanceof FrameEditorTab) {
                ((FrameEditorTab)((Object)this.tabPane.getSelectionModel().getSelectedItem())).dragEndTab(this.dragSourceFrames, this.dragFromShelf, this.calcDragCopy(dragType, false));
            }
            this.shelf.dragEnd(this.dragSourceFrames, this.dragFromShelf, this.calcDragCopy(dragType, true));
            this.dragSourceFrames.clear();
            this.scene.setCursor(Cursor.DEFAULT);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void scheduleUpdateCatalogue(FrameEditorTab editor, FrameCursor c, CodeCompletionState codeCompletion, boolean selection, Frame.View viewMode, List<ExtensionDescription> altExtensions, List<FrameCatalogue.Hint> hints) {
        this.cataloguePane.scheduleUpdateCatalogue(editor, (FrameCursor)(viewMode == Frame.View.NORMAL ? c : null), codeCompletion, selection, viewMode, altExtensions, hints);
    }

    public WindowOverlayPane getOverlayPane() {
        return this.overlayPane;
    }

    public boolean hasOneTab() {
        return this.tabPane.getTabs().size() == 1;
    }

    public boolean containsTab(Tab tab) {
        return this.tabPane.getTabs().contains((Object)tab);
    }

    public StringExpression titleProperty() {
        return this.stage.titleProperty();
    }

    private List<FXTab> getFXTabs() {
        return Utility.mapList((Collection)this.tabPane.getTabs(), t -> (FXTab)((Object)t));
    }

    @OnThread(value=Tag.Swing)
    public void setPosition(int x, int y) {
        Platform.runLater(() -> {
            this.stage.setX((double)x);
            this.stage.setY((double)y);
        });
    }

    @OnThread(value=Tag.Swing)
    public void setSize(int width, int height) {
        Platform.runLater(() -> {
            this.stage.setWidth((double)width);
            this.stage.setHeight((double)height);
        });
    }

    public void setTitleStatus(String status) {
        this.titleStatus.set((Object)status);
    }

    public Window getWindow() {
        return this.stage;
    }

    public static void setupFrameDrag(Frame f, boolean isShelf, FXSupplier<FXTabbedEditor> parent, FXSupplier<Boolean> canDrag, FXSupplier<FrameSelection> selection) {
        f.getNode().setOnDragDetected(event -> {
            double mouseSceneX = event.getSceneX();
            double mouseSceneY = event.getSceneY();
            if (((Boolean)canDrag.get()).booleanValue()) {
                if (((FrameSelection)selection.get()).contains(f)) {
                    ((FXTabbedEditor)parent.get()).frameDragBegin(((FrameSelection)selection.get()).getSelected(), isShelf, mouseSceneX, mouseSceneY);
                } else {
                    ((FXTabbedEditor)parent.get()).frameDragBegin(Arrays.asList(f), isShelf, mouseSceneX, mouseSceneY);
                }
            }
            event.consume();
        });
        f.getNode().setOnMouseDragged(event -> {
            ((FXTabbedEditor)parent.get()).draggedTo(event.getSceneX(), event.getSceneY(), JavaFXUtil.getDragModifiers((MouseEvent)event));
            event.consume();
        });
        f.getNode().setOnMouseReleased(event -> {
            if (!((FXTabbedEditor)parent.get()).isDragging()) {
                return;
            }
            ((FXTabbedEditor)parent.get()).draggedTo(event.getSceneX(), event.getSceneY(), JavaFXUtil.getDragModifiers((MouseEvent)event));
            ((FXTabbedEditor)parent.get()).frameDragEnd(JavaFXUtil.getDragModifiers((MouseEvent)event));
            event.consume();
        });
    }

    public void cleanup() {
        this.shelf.cleanup();
    }

    @OnThread(value=Tag.FXPlatform)
    public void moveToNewLater(FXTab tab) {
        FXTabbedEditor newWindow = this.project.createNewFXTabbedEditor();
        this.moveTabTo(tab, newWindow);
    }

    @OnThread(value=Tag.FXPlatform)
    public void moveTabTo(FXTab tab, FXTabbedEditor destination) {
        this.close(tab, true);
        destination.addTab(tab, true, true, true);
    }

    public void updateMoveMenus() {
        this.tabPane.getTabs().forEach(t -> this.updateMenusForTab((FXTab)((Object)t)));
    }

    @OnThread(value=Tag.FX)
    public int getX() {
        return (int)this.stage.getX();
    }

    @OnThread(value=Tag.FX)
    public int getY() {
        return (int)this.stage.getY();
    }

    @OnThread(value=Tag.FX)
    public int getWidth() {
        return (int)this.stage.getWidth();
    }

    @OnThread(value=Tag.FX)
    public int getHeight() {
        return (int)this.stage.getHeight();
    }

    private class CollapseControl
    extends BorderPane {
        private final Duration EXPAND_COLLAPSE_DURATION = Duration.millis((double)200.0);
        private final Scale scale;
        private FXPlatformRunnable cancelHover;

        public CollapseControl(Region collapse, final FXConsumer<Boolean> listener) {
            JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"catalogue-collapse"});
            Canvas control = new Canvas(8.0, 12.0);
            GraphicsContext gc = control.getGraphicsContext2D();
            gc.setFill((Paint)Color.DARKGRAY);
            gc.fillPolygon(new double[]{1.0, control.getWidth() - 1.0, 1.0, 1.0}, new double[]{1.0, 6.0, 11.0, 1.0}, 4);
            this.setCenter((Node)control);
            this.setFocusTraversable(false);
            this.setMinWidth(10.0);
            this.scale = new Scale(1.0, 1.0, control.getWidth() / 2.0, control.getHeight() / 2.0);
            control.getTransforms().add((Object)this.scale);
            SimpleDoubleProperty shrinkExpand = new SimpleDoubleProperty(1.0);
            collapse.maxWidthProperty().bind((ObservableValue)shrinkExpand.multiply(collapse.getMaxWidth()));
            collapse.prefWidthProperty().bind((ObservableValue)collapse.maxWidthProperty());
            this.setOnMouseClicked(e -> FXTabbedEditor.this.showingCatalogue.set(!FXTabbedEditor.this.showingCatalogue.get()));
            JavaFXUtil.addChangeListener((ObservableValue)FXTabbedEditor.this.showingCatalogue, (FXConsumer)new FXConsumer<Boolean>((DoubleProperty)shrinkExpand){
                private Timeline animation = null;
                final /* synthetic */ DoubleProperty val$shrinkExpand;
                {
                    this.val$shrinkExpand = doubleProperty;
                }

                public void accept(Boolean nowExpanded) {
                    listener.accept((Object)nowExpanded);
                    this.animate(nowExpanded);
                }

                private void animate(boolean expand) {
                    if (this.animation != null) {
                        this.animation.stop();
                        this.animation = null;
                    }
                    this.animation = new Timeline(new KeyFrame[]{new KeyFrame(CollapseControl.this.EXPAND_COLLAPSE_DURATION, new KeyValue[]{new KeyValue((WritableValue)this.val$shrinkExpand, (Object)(expand ? 1.0 : 0.0), Interpolator.EASE_OUT), new KeyValue((WritableValue)CollapseControl.this.scale.xProperty(), (Object)(expand ? 1.0 : -1.0))})});
                    this.animation.play();
                }
            });
            this.setOnMouseEntered(e -> {
                if (this.cancelHover != null) {
                    this.cancelHover.run();
                }
                this.cancelHover = JavaFXUtil.runAfter((Duration)Duration.millis((double)200.0), () -> JavaFXUtil.setPseudoclass((String)"bj-hover-long", (boolean)true, (Node[])new Node[]{this}));
            });
            this.setOnMouseExited(e -> {
                if (this.cancelHover != null) {
                    this.cancelHover.run();
                    this.cancelHover = null;
                }
                JavaFXUtil.setPseudoclass((String)"bj-hover-long", (boolean)false, (Node[])new Node[]{this});
            });
        }
    }

    public static enum CodeCompletionState {
        NOT_POSSIBLE,
        SHOWING,
        POSSIBLE;

    }
}

