/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.slots.EditableSlot;
import bluej.utility.Utility;
import java.util.Collections;
import java.util.Map;
import threadchecker.OnThread;
import threadchecker.Tag;

class CursorOrSlot {
    private final EditableSlot slot;
    private final FrameCursor cursor;

    public CursorOrSlot(EditableSlot slot) {
        if (slot == null) {
            throw new NullPointerException();
        }
        this.slot = slot;
        this.cursor = null;
    }

    public CursorOrSlot(FrameCursor cursor) {
        if (cursor == null) {
            throw new NullPointerException();
        }
        this.slot = null;
        this.cursor = cursor;
    }

    public boolean isInsideCanvas(FrameCanvas canvas) {
        FrameCanvas ourCanvas = this.cursor != null ? this.cursor.getParentCanvas() : (FrameCanvas)Utility.orNull((Object)this.slot.getParentFrame(), Frame::getParentCanvas);
        return ourCanvas == canvas;
    }

    public Frame getParentFrame() {
        if (this.slot != null) {
            return this.slot.getParentFrame();
        }
        return this.cursor.getParentCanvas().getParent().getFrame();
    }

    @OnThread(value=Tag.FXPlatform)
    public Map<EditableSlot.TopLevelMenu, EditableSlot.MenuItems> getMenuItems(boolean contextMenu) {
        return this.slot != null ? this.slot.getMenuItems(contextMenu) : Collections.singletonMap(EditableSlot.TopLevelMenu.EDIT, this.cursor.getMenuItems(false));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CursorOrSlot that = (CursorOrSlot)o;
        if (this.cursor != null ? !this.cursor.equals(that.cursor) : that.cursor != null) {
            return false;
        }
        return !(this.slot != null ? !this.slot.equals(that.slot) : that.slot != null);
    }

    public int hashCode() {
        int result = this.slot != null ? this.slot.hashCode() : 0;
        result = 31 * result + (this.cursor != null ? this.cursor.hashCode() : 0);
        return result;
    }

    public boolean matchesSlot(EditableSlot s) {
        return this.slot == s;
    }

    public FrameCursor getCursor() {
        return this.cursor;
    }

    public RecallableFocus getRecallableFocus() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return this.slot;
    }
}

