/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.BlueJSyntaxView;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.prefmgr.PrefMgr;
import bluej.utility.javafx.JavaFXUtil;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Slider;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.StringConverter;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
public class ScopeHighlightingPrefDisplay {
    public static final int MIN = 0;
    public static final int MAX = 20;
    Slider slider;
    Pane colorPanel;
    Rectangle greenPanelArea;
    Rectangle yellowPanelArea;
    Rectangle pinkPanelArea;
    Rectangle bluePanelArea;
    Color greenArea = ScopeHighlightingPrefDisplay.toFX(BlueJSyntaxView.GREEN_BASE);
    Color pinkArea = ScopeHighlightingPrefDisplay.toFX(BlueJSyntaxView.PINK_BASE);
    Color yellowArea = ScopeHighlightingPrefDisplay.toFX(BlueJSyntaxView.YELLOW_BASE);
    Color blueArea = ScopeHighlightingPrefDisplay.toFX(BlueJSyntaxView.BLUE_BASE);
    Color greenBorder = ScopeHighlightingPrefDisplay.toFX(BlueJSyntaxView.GREEN_OUTER_BASE);
    Color pinkBorder = ScopeHighlightingPrefDisplay.toFX(BlueJSyntaxView.PINK_OUTER_BASE);
    Color yellowBorder = ScopeHighlightingPrefDisplay.toFX(BlueJSyntaxView.YELLOW_OUTER_BASE);
    Color blueBorder = ScopeHighlightingPrefDisplay.toFX(BlueJSyntaxView.BLUE_OUTER_BASE);
    Color greenSetting;
    Color greenSettingBorder;
    Color yellowSetting;
    Color yellowSettingBorder;
    Color pinkSetting;
    Color pinkSettingBorder;
    Color blueSetting;
    Color blueSettingBorder;
    Color bg;

    public ScopeHighlightingPrefDisplay() {
        MoeSyntaxDocument.getColors();
        this.slider = new Slider(0.0, 20.0, (double)PrefMgr.getScopeHighlightStrength());
        this.slider.setMajorTickUnit(20.0);
        this.slider.setShowTickLabels(true);
        this.slider.setShowTickMarks(true);
        this.slider.setLabelFormatter((StringConverter)new StringConverter<Double>(){

            public String toString(Double d) {
                if (d == 0.0) {
                    return Config.getString((String)"prefmgr.edit.highlightLighter");
                }
                if (d == 20.0) {
                    return Config.getString((String)"prefmgr.edit.highlightDarker");
                }
                return "";
            }

            public Double fromString(String string) {
                return null;
            }
        });
        JavaFXUtil.addChangeListener((ObservableValue)this.slider.valueProperty(), v -> this.setPaletteValues());
        this.colorPanel = new VBox();
        JavaFXUtil.addStyleClass((Styleable)this.colorPanel, (String[])new String[]{"prefmgr-scope-colour-container"});
        VBox inner = (VBox)JavaFXUtil.withStyleClass((Styleable)new VBox(), (String[])new String[]{"prefmgr-scope-colour-rectangles"});
        this.greenPanelArea = this.makeRectangle();
        this.yellowPanelArea = this.makeRectangle();
        this.pinkPanelArea = this.makeRectangle();
        this.bluePanelArea = this.makeRectangle();
        this.setPaletteValues();
        inner.getChildren().add((Object)this.greenPanelArea);
        inner.getChildren().add((Object)this.yellowPanelArea);
        inner.getChildren().add((Object)this.pinkPanelArea);
        inner.getChildren().add((Object)this.bluePanelArea);
        this.colorPanel.getChildren().add((Object)inner);
    }

    private Rectangle makeRectangle() {
        return new Rectangle(100.0, 20.0);
    }

    protected Node getHighlightStrengthSlider() {
        return this.slider;
    }

    protected Node getColourPalette() {
        return this.colorPanel;
    }

    protected int getStrengthValue() {
        return (int)Math.round(this.slider.getValue());
    }

    private Color getReducedColor(Color c) {
        return ScopeHighlightingPrefDisplay.toFX(BlueJSyntaxView.getReducedColor((int)(255.0 * c.getRed()), (int)(255.0 * c.getGreen()), (int)(255.0 * c.getBlue()), this.getStrengthValue()));
    }

    protected void setGreenPalette() {
        this.greenSetting = this.getReducedColor(this.greenArea);
        this.greenPanelArea.setFill((Paint)this.greenSetting);
        this.greenSettingBorder = this.getReducedColor(this.greenBorder);
        this.greenPanelArea.setStroke((Paint)this.greenSettingBorder);
    }

    protected void setYellowPalette() {
        this.yellowSetting = this.getReducedColor(this.yellowArea);
        this.yellowPanelArea.setFill((Paint)this.yellowSetting);
        this.yellowSettingBorder = this.getReducedColor(this.yellowBorder);
        this.yellowPanelArea.setStroke((Paint)this.yellowSettingBorder);
    }

    protected void setPinkPalette() {
        this.pinkSetting = this.getReducedColor(this.pinkArea);
        this.pinkPanelArea.setFill((Paint)this.pinkSetting);
        this.pinkSettingBorder = this.getReducedColor(this.pinkBorder);
        this.pinkPanelArea.setStroke((Paint)this.pinkSettingBorder);
    }

    protected void setBluePalette() {
        this.blueSetting = this.getReducedColor(this.blueArea);
        this.bluePanelArea.setFill((Paint)this.blueSetting);
        this.blueSettingBorder = this.getReducedColor(this.blueBorder);
        this.bluePanelArea.setStroke((Paint)this.blueSettingBorder);
    }

    private void setPaletteValues() {
        this.setGreenPalette();
        this.setYellowPalette();
        this.setBluePalette();
        this.setPinkPalette();
    }

    private static Color toFX(java.awt.Color awtColor) {
        int r = awtColor.getRed();
        int g = awtColor.getGreen();
        int b = awtColor.getBlue();
        int a = awtColor.getAlpha();
        double opacity = (double)a / 255.0;
        return Color.rgb((int)r, (int)g, (int)b, (double)opacity);
    }
}

