/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.Config;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.compiler.Diagnostic;
import bluej.debugger.DebuggerThread;
import bluej.editor.EditorWatcher;
import bluej.editor.TextEditor;
import bluej.editor.moe.AdvancedHighlightPainter;
import bluej.editor.moe.CodeCompletionDisplay;
import bluej.editor.moe.EditorDividerPanel;
import bluej.editor.moe.FindPanel;
import bluej.editor.moe.GoToLineDialog;
import bluej.editor.moe.Info;
import bluej.editor.moe.MoeActions;
import bluej.editor.moe.MoeBorderHighlighterPainter;
import bluej.editor.moe.MoeCaret;
import bluej.editor.moe.MoeEditorPane;
import bluej.editor.moe.MoeEditorParameters;
import bluej.editor.moe.MoeErrorManager;
import bluej.editor.moe.MoeHighlighter;
import bluej.editor.moe.MoeIndent;
import bluej.editor.moe.MoePrinter;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.editor.moe.MoeSyntaxEditorKit;
import bluej.editor.moe.MoeUndoManager;
import bluej.editor.moe.NaviView;
import bluej.editor.moe.NullCaret;
import bluej.editor.moe.ParserMessageHandler;
import bluej.editor.moe.PrintDialog;
import bluej.editor.moe.ReadmeEditorKit;
import bluej.editor.moe.ReparseRunner;
import bluej.editor.moe.ReplacePanel;
import bluej.editor.moe.StatusLabel;
import bluej.editor.moe.TextUtilities;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.FrameEditor;
import bluej.editor.stride.MoeFXTab;
import bluej.extensions.SourceType;
import bluej.extensions.editor.Editor;
import bluej.parser.AssistContent;
import bluej.parser.CodeSuggestions;
import bluej.parser.ParseUtils;
import bluej.parser.SourceLocation;
import bluej.parser.entity.EntityResolver;
import bluej.parser.lexer.LocatableToken;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedCUNode;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.RBTreeNode;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Selection;
import bluej.pkgmgr.JavadocResolver;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.prefmgr.PrefMgr;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.utility.DBox;
import bluej.utility.DBoxLayout;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformSupplier;
import bluej.utility.javafx.FXSupplier;
import bluej.utility.javafx.JavaFXUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.RoundRectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import threadchecker.OnThread;
import threadchecker.Tag;

public final class MoeEditor
extends JPanel
implements TextEditor,
BlueJEventListener,
HyperlinkListener,
DocumentListener,
MouseListener,
MouseMotionListener {
    static final int version = 320;
    static final String versionString = "3.2.0";
    static final Color cursorColor = new Color(255, 0, 100);
    static final Color infoColor = new Color(240, 240, 240);
    static final Color lightGrey = new Color(224, 224, 224);
    static final Color selectionColour = Config.getSelectionColour();
    static final Color envOpColour = Config.ENV_COLOUR;
    static final String LabelSuffix = "Label";
    static final String ActionSuffix = "Action";
    static final String TooltipSuffix = "Tooltip";
    static final String AcceleratorSuffix = "Accelerator";
    static final String COMPILED = "compiled";
    private static final String CRASHFILE_SUFFIX = "#";
    private static final String BACKUP_SUFFIX = "~";
    private static final int NAVIVIEW_WIDTH = 90;
    private static final Color highlightBorderColor = new Color(212, 172, 45);
    private static final int printFontSize = Config.getPropInteger((String)"bluej.fontsize.printText", (int)10);
    private static final Font printFont = new Font("Monospaced", 0, printFontSize);
    private static final AdvancedHighlightPainter searchHighlightPainter = new MoeBorderHighlighterPainter(highlightBorderColor, Config.getHighlightColour(), Config.getHighlightColour2(), Config.getSelectionColour2(), Config.getSelectionColour());
    private static boolean matchBrackets = false;
    private static ArrayList<String> editActions;
    private static ArrayList<String> readMeActions;
    private final String implementationString = Config.getString((String)"editor.implementationLabel");
    private final String interfaceString = Config.getString((String)"editor.interfaceLabel");
    private final FXSupplier<FXTabbedEditor> defaultFXTabbedEditor;
    private @OnThread(value=Tag.Any) FXTabbedEditor fxTabbedEditor;
    private @OnThread(value=Tag.FX) MoeFXTab fxTab;
    public MoeUndoManager undoManager;
    private final EditorWatcher watcher;
    private final Properties resources;
    private AbstractDocument document;
    private MoeSyntaxDocument sourceDocument;
    private HTMLDocument htmlDocument;
    private MoeActions actions;
    private JEditorPane currentTextPane;
    private JEditorPane sourcePane;
    private JEditorPane htmlPane;
    private MoeCaret moeCaret;
    private Info info;
    private JPanel statusArea;
    private StatusLabel saveState;
    private JComboBox<String> interfaceToggle;
    private @OnThread(value=Tag.FXPlatform) GoToLineDialog goToLineDialog;
    private FindPanel finder;
    private ReplacePanel replacer;
    private JScrollPane scrollPane;
    private NaviView naviView;
    private EditorDividerPanel dividerPanel;
    private JComponent toolbar;
    private JMenuBar menubar;
    private final JMenuItem undoMenuItem;
    private final JMenuItem redoMenuItem;
    private final JButton undoButton;
    private final JButton redoButton;
    private JPopupMenu popup;
    private String filename;
    private long lastModified;
    private String windowTitle;
    private String docFilename;
    private Charset characterSet;
    private final boolean sourceIsCode;
    private boolean viewingHTML;
    private int currentStepPos;
    private boolean mayHaveBreakpoints;
    private boolean ignoreChanges = false;
    private boolean tabsAreExpanded = false;
    private MoePrinter printer;
    private PrintDialog printDialog;
    private final TextInsertNotifier doTextInsert = new TextInsertNotifier();
    private final JavadocResolver javadocResolver;
    private ReparseRunner reparseRunner;
    private final List<Object> sourceSearchHighlightTags = new ArrayList<Object>();
    private final List<Object> htmlSearchHighlightTags = new ArrayList<Object>();
    private final HashMap<String, Object> propertyMap = new HashMap();
    private int oldCaretLineNumber = -1;
    private ErrorDisplay errorDisplay;
    private boolean madeChangeOnCurrentLine = false;
    private final MoeErrorManager errorManager = new MoeErrorManager(this, enable -> {});
    private Timer mouseHover;
    private int mouseCaretPos = -1;
    private final Runnable callbackOnOpen;
    private final @OnThread(value=Tag.FX) List<Menu> fxMenus = new ArrayList<Menu>();

    public MoeEditor(MoeEditorParameters parameters, FXSupplier<FXTabbedEditor> getDefaultEditor) {
        super(new BorderLayout(6, 6));
        this.defaultFXTabbedEditor = getDefaultEditor;
        String fxWindowTitle = parameters.getTitle();
        Platform.runLater(() -> {
            this.fxTabbedEditor = (FXTabbedEditor)getDefaultEditor.get();
            this.fxTab = new MoeFXTab(this, fxWindowTitle);
        });
        this.watcher = parameters.getWatcher();
        this.resources = parameters.getResources();
        this.javadocResolver = parameters.getJavadocResolver();
        this.filename = null;
        this.windowTitle = parameters.getTitle();
        this.sourceIsCode = parameters.isCode();
        this.viewingHTML = false;
        this.currentStepPos = -1;
        this.mayHaveBreakpoints = false;
        matchBrackets = PrefMgr.getFlag((String)"bluej.editor.matchBrackets");
        this.undoManager = new MoeUndoManager(this);
        this.initWindow(parameters.getProjectResolver());
        if (this.watcher != null) {
            this.watcher.scheduleCompilation(false, CompileReason.LOADED, CompileType.ERROR_CHECK_ONLY);
        }
        this.callbackOnOpen = parameters.getCallbackOnOpen();
        this.undoMenuItem = this.findMenuItem("undo");
        this.redoMenuItem = this.findMenuItem("redo");
        this.undoButton = this.findToolbarButton("undo");
        this.redoButton = this.findToolbarButton("redo");
    }

    @OnThread(value=Tag.Any)
    public static PageFormat getPageFormat(PrinterJob job) {
        return job.validatePage(PkgMgrFrame.getPageFormat());
    }

    public static void pageSetup() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pageFormat = job.pageDialog(PkgMgrFrame.getPageFormat());
        PkgMgrFrame.setPageFormat((PageFormat)pageFormat);
    }

    private static int findSubstring(String text, String sub, boolean ignoreCase, boolean backwards) {
        boolean itsOver;
        int pos;
        int strlen = text.length();
        int sublen = sub.length();
        if (sublen == 0) {
            return -1;
        }
        boolean found = false;
        int n = pos = backwards ? strlen - sublen : 0;
        boolean bl = backwards ? pos < 0 : (itsOver = pos + sublen > strlen);
        while (!found && !itsOver) {
            found = text.regionMatches(ignoreCase, pos, sub, 0, sublen);
            if (found) {
                return pos;
            }
            if (found) continue;
            int n2 = pos = backwards ? pos - 1 : pos + 1;
            itsOver = backwards ? pos < 0 : pos + sublen > strlen;
        }
        return -1;
    }

    private static int findSubstring(String text, String sub, boolean ignoreCase, boolean backwards, int foundPos) {
        boolean itsOver;
        int strlen = text.length();
        int sublen = sub.length();
        if (sublen == 0) {
            return -1;
        }
        boolean found = false;
        int pos = foundPos;
        boolean bl = backwards ? pos < 0 : (itsOver = pos + sublen > strlen);
        while (!found && !itsOver) {
            found = text.regionMatches(ignoreCase, pos, sub, 0, sublen);
            if (found) {
                return pos;
            }
            if (found) continue;
            int n = pos = backwards ? pos - 1 : pos + 1;
            itsOver = backwards ? pos < 0 : pos + sublen > strlen;
        }
        return -1;
    }

    private static boolean isEditAction(String text) {
        ArrayList<String> actions = MoeEditor.getEditActions();
        return actions.contains(text);
    }

    private static boolean isNonReadmeAction(String actionName) {
        ArrayList<String> flaggedActions = MoeEditor.getNonReadmeActions();
        return flaggedActions.contains(actionName);
    }

    private static ArrayList<String> getNonReadmeActions() {
        if (readMeActions == null) {
            readMeActions = new ArrayList();
            readMeActions.add("compile");
            readMeActions.add("autoindent");
            readMeActions.add("insert-method");
            readMeActions.add("add-javadoc");
            readMeActions.add("toggle-interface-view");
        }
        return readMeActions;
    }

    private static ArrayList<String> getEditActions() {
        if (editActions == null) {
            editActions = new ArrayList();
            editActions.add("save");
            editActions.add("reload");
            editActions.add("print");
            editActions.add("page-setup");
            editActions.add("compile");
            editActions.add("cut-to-clipboard");
            editActions.add("indent-block");
            editActions.add("deindent-block");
            editActions.add("comment-block");
            editActions.add("uncomment-block");
            editActions.add("insert-method");
            editActions.add("add-javadoc");
            editActions.add("replace");
            editActions.add("go-to-line");
            editActions.add("paste-from-clipboard");
            editActions.add("toggle-breakpoint");
            editActions.add("autoindent");
        }
        return editActions;
    }

    public static boolean matchBrackets() {
        return matchBrackets;
    }

    private static KeyStroke chooseKey(KeyStroke[] keys) {
        if (keys.length == 1) {
            return keys[0];
        }
        KeyStroke key = keys[0];
        for (int i = 1; i < keys.length; ++i) {
            if (keys[i].getKeyCode() < 65 || keys[i].getKeyCode() > 90) continue;
            key = keys[i];
        }
        return key;
    }

    private static void removeSelection(JEditorPane textPane) {
        if (textPane != null) {
            textPane.setSelectionEnd(textPane.getSelectionStart());
        }
    }

    private static String smartFormat(String original, String replacement) {
        if (original == null || replacement == null) {
            return replacement;
        }
        if (!MoeEditor.isLowerCase(replacement) || !MoeEditor.isLowerCase(original)) {
            return replacement;
        }
        if (MoeEditor.isUpperCase(original)) {
            return replacement.toUpperCase();
        }
        if (MoeEditor.isTitleCase(original)) {
            return Character.toTitleCase(replacement.charAt(0)) + replacement.substring(1);
        }
        return replacement;
    }

    public static boolean isLowerCase(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isLowerCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isUpperCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isTitleCase(String s) {
        if (s.length() < 2) {
            return false;
        }
        return Character.isUpperCase(s.charAt(0)) && Character.isLowerCase(s.charAt(1));
    }

    @Override
    public boolean showFile(String filename, Charset charset, boolean compiled, String docFilename) {
        this.filename = filename;
        this.docFilename = docFilename;
        this.characterSet = charset;
        boolean loaded = false;
        if (filename != null) {
            try {
                String crashFilename = filename + CRASHFILE_SUFFIX;
                String backupFilename = crashFilename + "backup";
                File crashFile = new File(crashFilename);
                if (crashFile.exists()) {
                    File backupFile = new File(backupFilename);
                    backupFile.delete();
                    crashFile.renameTo(backupFile);
                    Platform.runLater(() -> DialogManager.showMessageFX((javafx.stage.Window)this.fxTabbedEditor.getWindow(), (String)"editor-crashed"));
                }
                FileInputStream inputStream = new FileInputStream(filename);
                InputStreamReader reader = new InputStreamReader((InputStream)inputStream, charset);
                this.sourcePane.read(reader, null);
                try {
                    ((Reader)reader).close();
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                File file = new File(filename);
                this.lastModified = file.lastModified();
                this.sourcePane.addMouseListener(this);
                this.sourcePane.addMouseMotionListener(this);
                this.sourceDocument = (MoeSyntaxDocument)((Object)this.sourcePane.getDocument());
                this.naviView.setDocument((Document)((Object)this.sourceDocument));
                this.sourceDocument.addDocumentListener(this);
                this.sourceDocument.addUndoableEditListener(this.undoManager);
                this.document = this.sourceDocument;
                this.sourceDocument.enableParser(false);
                loaded = true;
                this.scheduleReparseRunner();
            }
            catch (FileNotFoundException ex) {
                this.clear();
            }
            catch (IOException ex) {
                Debug.reportError((String)"Couldn't open file", (Throwable)ex);
            }
        } else if (docFilename != null && new File(docFilename).exists()) {
            this.showInterface(true);
            loaded = true;
            this.interfaceToggle.setEnabled(false);
        }
        if (!loaded) {
            return false;
        }
        this.info.message(Config.getString((String)"editor.info.version") + " " + versionString);
        this.sourcePane.setFont(PrefMgr.getStandardEditorFont());
        this.setCompileStatus(compiled);
        return true;
    }

    @Override
    public void reloadFile() {
        this.doReload();
    }

    @Override
    public void clear() {
        this.ignoreChanges = true;
        this.sourcePane.setText("");
        this.ignoreChanges = false;
    }

    @Override
    public void insertText(String text, boolean caretBack) {
        this.sourcePane.replaceSelection(text);
        if (caretBack) {
            this.sourcePane.setCaretPosition(this.sourcePane.getCaretPosition() - text.length());
        }
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            this.sourcePane.setFont(PrefMgr.getStandardEditorFont());
            this.checkBracketStatus();
        }
        Platform.runLater(() -> {
            if (this.fxTabbedEditor == null) {
                this.fxTabbedEditor = (FXTabbedEditor)this.defaultFXTabbedEditor.get();
            }
            if (vis) {
                this.fxTabbedEditor.addTab(this.fxTab, vis, true);
            }
            this.fxTabbedEditor.setWindowVisible(vis, this.fxTab);
            if (vis) {
                this.fxTabbedEditor.bringToFront(this.fxTab);
                SwingUtilities.invokeLater(() -> {
                    if (this.callbackOnOpen != null) {
                        this.callbackOnOpen.run();
                    }
                });
            }
        });
    }

    @Override
    public void refresh() {
        this.sourcePane.setFont(PrefMgr.getStandardEditorFont());
        this.checkBracketStatus();
        this.scheduleReparseRunner();
        this.currentTextPane.repaint();
        Info.resetFont();
        this.info.refresh();
        StatusLabel.resetFont();
        this.saveState.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws IOException {
        IOException failureException = null;
        if (this.saveState.isChanged()) {
            this.recordEdit(true);
            Writer writer = null;
            try {
                String crashFilename = this.filename + CRASHFILE_SUFFIX;
                String backupFilename = this.filename + BACKUP_SUFFIX;
                FileUtility.copyFile((String)this.filename, (String)crashFilename);
                BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(this.filename));
                writer = new OutputStreamWriter((OutputStream)ostream, this.characterSet);
                this.sourcePane.write(writer);
                writer.close();
                writer = null;
                this.setSaved();
                this.lastModified = new File(this.filename).lastModified();
                if (PrefMgr.getFlag((String)"bluej.editor.makeBackup")) {
                    File crashFile = new File(crashFilename);
                    File backupFile = new File(backupFilename);
                    backupFile.delete();
                    crashFile.renameTo(backupFile);
                } else {
                    File crashFile = new File(crashFilename);
                    crashFile.delete();
                }
            }
            catch (IOException ex) {
                failureException = ex;
                this.info.warning(Config.getString((String)"editor.info.errorSaving") + " - " + ex.getLocalizedMessage());
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException ex) {
                    failureException = ex;
                }
            }
        }
        if (failureException != null) {
            this.info.warning(Config.getString((String)"editor.info.errorSaving") + " - " + failureException.getLocalizedMessage());
            throw failureException;
        }
    }

    @Override
    public void close() {
        try {
            this.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.doClose();
    }

    @Override
    public void displayMessage(String message, int lineNumber, int column, boolean beep, String help) {
        this.switchToSourceView();
        Element line = this.getSourceLine(lineNumber);
        int pos = line.getStartOffset();
        this.sourcePane.setCaretPosition(pos);
        this.sourcePane.moveCaretPosition(line.getEndOffset() - 1);
        this.moeCaret.setPersistentHighlight();
        if (beep) {
            this.info.warningImportant(message);
        } else {
            this.info.messageImportant(message);
        }
        if (help != null) {
            this.info.setHelp(help);
        }
    }

    @Override
    public boolean displayDiagnostic(Diagnostic diagnostic, int errorIndex, CompileType compileType) {
        if (compileType.showEditorOnError()) {
            this.setVisible(true);
        }
        this.switchToSourceView();
        Element line = this.getSourceLine((int)diagnostic.getStartLine());
        if (line != null) {
            int startPos = this.getPosFromColumn(line, (int)diagnostic.getStartColumn());
            int endPos = diagnostic.getStartLine() != diagnostic.getEndLine() ? line.getEndOffset() - 1 : this.getPosFromColumn(line, (int)diagnostic.getEndColumn());
            if (endPos == startPos) {
                try {
                    if (endPos < this.getTextLength() - 1 && !this.sourceDocument.getText(endPos, 1).equals("\n")) {
                        ++endPos;
                    } else if (startPos > 0 && !this.sourceDocument.getText(startPos - 1, 1).equals("\n")) {
                        --startPos;
                    }
                }
                catch (BadLocationException e) {
                    Debug.reportError((Throwable)e);
                }
            }
            this.errorManager.addErrorHighlight(startPos, endPos, diagnostic.getMessage(), diagnostic.getIdentifier());
            this.repaint();
        }
        this.info.setHelp("javac");
        return true;
    }

    @Override
    public void setStepMark(int lineNumber, String message, boolean isBreak, DebuggerThread thread) {
        this.switchToSourceView();
        Element line = this.getSourceLine(lineNumber);
        int pos = line.getStartOffset();
        if (isBreak) {
            this.setStepMark(pos);
        }
        this.sourcePane.setCaretPosition(pos);
        this.sourcePane.moveCaretPosition(line.getEndOffset() - 1);
        this.moeCaret.setPersistentHighlight();
        if (message != null) {
            this.info.messageImportant(message);
        }
    }

    private int getPosFromColumn(Element line, int column) {
        int spos = line.getStartOffset();
        int epos = line.getEndOffset();
        int testPos = Math.min(epos - spos - 1, column - 1);
        if (testPos == 0) {
            return spos;
        }
        try {
            int tpos = 0;
            String lineText = this.sourceDocument.getText(spos, testPos);
            for (int cpos = 0; cpos < column - 1; cpos -= cpos % 8) {
                int tabPos = lineText.indexOf(9, tpos);
                if (tabPos == -1) {
                    return Math.min(spos + (tpos += column - cpos - 1), epos - 1);
                }
                int newcpos = cpos + (tabPos - tpos);
                if (newcpos >= column) {
                    return spos + (tpos += column - cpos - 1);
                }
                cpos = newcpos;
                cpos += 8;
                tpos = tabPos + 1;
            }
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
        return spos;
    }

    @Override
    public void setSelection(int lineNumber, int columnNumber, int len) {
        Element line = this.getSourceLine(lineNumber);
        this.sourcePane.select(line.getStartOffset() + columnNumber - 1, line.getStartOffset() + columnNumber + len - 1);
    }

    @Override
    public void setSelection(int lineNumber1, int columnNumber1, int lineNumber2, int columnNumber2) {
        Element line1 = this.getSourceLine(lineNumber1);
        Element line2 = this.getSourceLine(lineNumber2);
        this.sourcePane.select(line1.getStartOffset() + columnNumber1 - 1, line2.getStartOffset() + columnNumber2 - 1);
    }

    @Override
    public void removeStepMark() {
        if (this.currentStepPos != -1) {
            SimpleAttributeSet a = new SimpleAttributeSet();
            a.addAttribute("step", Boolean.FALSE);
            this.sourceDocument.setParagraphAttributes(this.currentStepPos, a);
            this.currentStepPos = -1;
            this.sourcePane.setCaretPosition(this.sourcePane.getCaretPosition());
            this.repaint();
        }
    }

    @Override
    public void changeName(String title, String filename, String javaFilename, String docFilename) {
        this.filename = filename;
        this.docFilename = docFilename;
        this.windowTitle = title;
        this.setWindowTitle();
    }

    @Override
    public void setCompiled(boolean compiled) {
        this.setCompileStatus(compiled);
        if (compiled) {
            this.errorManager.removeAllErrorHighlights();
        }
    }

    @Override
    public void compileFinished(boolean successful) {
        if (successful && this.isVisible()) {
            this.info.messageImportant(Config.getString((String)"editor.info.compiled"));
        }
    }

    @Override
    public void removeBreakpoints() {
        this.getSourceDocument().scheduleUpdate(() -> this.clearAllBreakpoints());
    }

    @Override
    public void reInitBreakpoints() {
        if (this.mayHaveBreakpoints) {
            this.mayHaveBreakpoints = false;
            for (int i = 1; i <= this.numberOfLines(); ++i) {
                if (!this.lineHasBreakpoint(i)) continue;
                if (this.watcher != null) {
                    this.watcher.breakpointToggleEvent(i, true);
                }
                this.mayHaveBreakpoints = true;
            }
        }
    }

    @Override
    public boolean isModified() {
        return this.saveState.isChanged();
    }

    @Override
    public boolean isReadOnly() {
        return !this.sourcePane.isEditable();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.saveState.setState(0);
            this.updateUndoRedoControls();
        }
        this.sourcePane.setEditable(!readOnly);
    }

    @Override
    public void showInterface(boolean interfaceStatus) {
        this.interfaceToggle.setSelectedIndex(interfaceStatus ? 1 : 0);
    }

    public boolean isShowingInterface() {
        return this.viewingHTML;
    }

    @Override
    public SourceLocation getCaretLocation() {
        int caretOffset = this.sourcePane.getCaretPosition();
        return this.getLineColumnFromOffset(caretOffset);
    }

    @Override
    public void setCaretLocation(SourceLocation location) {
        this.sourcePane.setCaretPosition(this.getOffsetFromLineColumn(location));
    }

    @Override
    public SourceLocation getLineColumnFromOffset(int offset) {
        int lineNumber;
        if (offset < 0) {
            return null;
        }
        Element map = this.sourceDocument.getDefaultRootElement();
        Element lineElement = map.getElement(lineNumber = map.getElementIndex(offset));
        if (offset >= lineElement.getEndOffset()) {
            return null;
        }
        int column = offset - lineElement.getStartOffset();
        return new SourceLocation(lineNumber + 1, column + 1);
    }

    @Override
    public SourceLocation getSelectionBegin() {
        Caret aCaret = this.sourcePane.getCaret();
        if (aCaret.getDot() == aCaret.getMark()) {
            return null;
        }
        int beginOffset = Math.min(aCaret.getDot(), aCaret.getMark());
        return this.getLineColumnFromOffset(beginOffset);
    }

    @Override
    public SourceLocation getSelectionEnd() {
        Caret aCaret = this.sourcePane.getCaret();
        if (aCaret.getDot() == aCaret.getMark()) {
            return null;
        }
        int endOffset = Math.max(aCaret.getDot(), aCaret.getMark());
        return this.getLineColumnFromOffset(endOffset);
    }

    @Override
    public String getText(SourceLocation begin, SourceLocation end) {
        int first = this.getOffsetFromLineColumn(begin);
        int last = this.getOffsetFromLineColumn(end);
        int beginOffset = Math.min(first, last);
        int endOffset = Math.max(first, last);
        try {
            return this.sourceDocument.getText(beginOffset, endOffset - beginOffset);
        }
        catch (BadLocationException exc) {
            throw new IllegalArgumentException(exc.getMessage());
        }
    }

    @Override
    public void setText(SourceLocation begin, SourceLocation end, String newText) throws BadLocationException {
        int endOffset;
        int finish;
        int start = this.getOffsetFromLineColumn(begin);
        int beginOffset = Math.min(start, finish = this.getOffsetFromLineColumn(end));
        if (beginOffset != (endOffset = Math.max(start, finish))) {
            this.sourceDocument.remove(beginOffset, endOffset - beginOffset);
        }
        this.sourceDocument.insertString(beginOffset, newText, null);
    }

    @Override
    public void setSelection(SourceLocation begin, SourceLocation end) {
        int start = this.getOffsetFromLineColumn(begin);
        int finish = this.getOffsetFromLineColumn(end);
        int selectionStart = Math.min(start, finish);
        int selectionEnd = Math.max(start, finish);
        this.sourcePane.setCaretPosition(selectionStart);
        this.sourcePane.moveCaretPosition(selectionEnd);
    }

    @Override
    public int getOffsetFromLineColumn(SourceLocation location) {
        int col = location.getColumn() - 1;
        int line = location.getLine() - 1;
        if (line < 0 || col < 0) {
            throw new IllegalArgumentException("line or column < 1");
        }
        Element map = this.sourceDocument.getDefaultRootElement();
        if (line >= map.getElementCount()) {
            throw new IllegalArgumentException("line=" + location.getLine() + " is out of bound");
        }
        Element lineElement = this.sourceDocument.getDefaultRootElement().getElement(line);
        int lineOffset = lineElement.getStartOffset();
        int lineLen = lineElement.getEndOffset() - lineOffset;
        if (col >= lineLen) {
            throw new IllegalArgumentException("column=" + location.getColumn() + " greater than line len=" + lineLen);
        }
        return lineOffset + col;
    }

    @Override
    public Object getProperty(String propertyKey) {
        return this.propertyMap.get(propertyKey);
    }

    @Override
    public void setProperty(String propertyKey, Object value) {
        if (propertyKey == null) {
            return;
        }
        this.propertyMap.put(propertyKey, value);
    }

    @Override
    public int getLineLength(int line) {
        if (line < 0) {
            return -1;
        }
        Element lineElement = this.sourceDocument.getDefaultRootElement().getElement(line);
        if (lineElement == null) {
            return -1;
        }
        int startOffset = lineElement.getStartOffset();
        return lineElement.getEndOffset() - startOffset;
    }

    @Override
    public int getTextLength() {
        return this.sourceDocument.getLength();
    }

    @Override
    public int numberOfLines() {
        return this.sourceDocument.getDefaultRootElement().getElementCount();
    }

    @Override
    public ParsedCUNode getParsedNode() {
        return this.sourceDocument.getParser();
    }

    public void updateUndoRedoControls() {
        this.updateUndoRedoControls(this.undoManager.canUndo(), this.undoManager.canRedo());
    }

    private void updateUndoRedoControls(boolean canUndo, boolean canRedo) {
        this.setEnabled(this.undoMenuItem, canUndo);
        this.setEnabled(this.redoMenuItem, canRedo);
        this.setEnabled(this.undoButton, canUndo);
        this.setEnabled(this.redoButton, canRedo);
    }

    private void setEnabled(AbstractButton item, boolean enable) {
        if (item != null) {
            item.setEnabled(enable);
        }
    }

    private void scheduleReparseRunner() {
        if (this.reparseRunner == null) {
            this.reparseRunner = new ReparseRunner(this);
            EventQueue.invokeLater(this.reparseRunner);
        }
    }

    public void reparseRunnerFinished() {
        this.reparseRunner = null;
    }

    public void blueJEvent(int eventId, Object arg) {
        switch (eventId) {
            case 7: {
                BlueJEvent.removeListener((BlueJEventListener)this);
                this.refreshHtmlDisplay();
                break;
            }
            case 8: {
                BlueJEvent.removeListener((BlueJEventListener)this);
                this.info.warning(Config.getString((String)"editor.info.docAborted"));
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        DocumentEvent.ElementChange ec = e.getChange(this.sourceDocument.getDefaultRootElement());
        if (ec != null) {
            this.saveState.setState(2);
            this.setChanged();
            if (this.watcher != null) {
                this.watcher.scheduleCompilation(true, CompileReason.MODIFIED, CompileType.ERROR_CHECK_ONLY);
            }
            this.madeChangeOnCurrentLine = false;
        } else {
            this.madeChangeOnCurrentLine = true;
        }
        this.clearMessage();
        this.removeSearchHighlights();
        this.errorManager.removeAllErrorHighlights();
        if (!this.saveState.isChanged()) {
            this.saveState.setState(2);
            this.setChanged();
        }
        this.actions.userAction();
        this.doTextInsert.setEvent(e, this.sourcePane);
        MoeSyntaxDocument msd = (MoeSyntaxDocument)((Object)e.getDocument());
        if (!msd.isRunningScheduledUpdates()) {
            msd.scheduleUpdate(this.doTextInsert);
        }
        this.recordEdit(false);
        this.scheduleReparseRunner();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        DocumentEvent.ElementChange ec = e.getChange(this.sourceDocument.getDefaultRootElement());
        if (ec != null) {
            this.saveState.setState(2);
            this.setChanged();
            if (this.watcher != null) {
                this.watcher.scheduleCompilation(true, CompileReason.MODIFIED, CompileType.ERROR_CHECK_ONLY);
            }
            this.madeChangeOnCurrentLine = false;
        } else {
            this.madeChangeOnCurrentLine = true;
        }
        this.clearMessage();
        this.removeSearchHighlights();
        this.errorManager.removeAllErrorHighlights();
        if (!this.saveState.isChanged()) {
            this.saveState.setState(2);
            this.setChanged();
        }
        this.actions.userAction();
        this.recordEdit(false);
        this.scheduleReparseRunner();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public void clearMessage() {
        this.info.clear();
    }

    @Override
    public void writeMessage(String msg) {
        this.info.message(msg);
    }

    public void writeWarningMessage(String msg) {
        this.info.warning(msg);
    }

    public void userSave() {
        if (this.saveState.isSaved()) {
            this.info.message(Config.getString((String)"editor.info.noChanges"));
        } else {
            try {
                this.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void reload() {
        if (this.filename == null) {
            this.info.warning(Config.getString((String)"editor.info.cannotReload"), Config.getString((String)"editor.info.reload"));
        } else if (this.saveState.isChanged()) {
            Platform.runLater(() -> {
                int answer = DialogManager.askQuestionFX((javafx.stage.Window)this.fxTabbedEditor.getWindow(), (String)"really-reload");
                if (answer == 0) {
                    SwingUtilities.invokeLater(() -> this.doReload());
                }
            });
        } else {
            this.doReload();
        }
    }

    @Override
    @OnThread(value=Tag.Any)
    public void printTo(PrinterJob printerJob, boolean printLineNumbers, boolean printBackground) {
        PrintHandler pt = new PrintHandler(printerJob, MoeEditor.getPageFormat(printerJob), printLineNumbers, printBackground);
        pt.print();
    }

    public void print() {
        PrinterJob job;
        if (this.printDialog == null) {
            this.printDialog = new PrintDialog();
        }
        if (this.printDialog.display() && (job = PrinterJob.getPrinterJob()).printDialog()) {
            PrintHandler pt = new PrintHandler(job, MoeEditor.getPageFormat(job), this.printDialog.printLineNumbers(), this.printDialog.printHighlighting());
            Thread printJobThread = new Thread(pt);
            printJobThread.setPriority(Thread.currentThread().getPriority() - 1);
            printJobThread.start();
        }
    }

    public void doClose() {
        this.setVisible(false);
        if (this.watcher != null) {
            this.watcher.setProperty("naviviewExpandedProperty", String.valueOf(this.dividerPanel.isExpanded()));
            this.watcher.closeEvent(this);
        }
    }

    public boolean checkExpandTabs() {
        if (this.tabsAreExpanded) {
            return false;
        }
        this.tabsAreExpanded = true;
        return true;
    }

    public void toggleReplacePanelVisible() {
        if (this.replacer.isVisible() || !this.finder.isVisible()) {
            this.replacer.setVisible(false);
            return;
        }
        this.replacer.setVisible(true);
        this.finder.requestFindfieldFocus();
    }

    protected void setReplacePanelVisible(boolean visible) {
        if (visible) {
            if (!this.finder.isVisible()) {
                this.finder.setVisible(visible);
            }
            this.replacer.setVisible(visible);
            this.finder.requestFindfieldFocus();
            this.finder.setFindReplaceIcon(true);
        } else {
            this.replacer.setVisible(false);
            this.finder.setFindReplaceIcon(false);
        }
    }

    public void replace(String replaceString) {
        int caretPos = this.sourcePane.getCaretPosition();
        String searchString = this.finder.getSearchString();
        if (this.getSourcePane().getSelectedText() == null || this.getSourcePane().getSelectedText().length() <= 0) {
            if (this.finder.getSearchString() != null && this.finder.getSearchString().length() > 0) {
                searchString = this.finder.getSearchTextfield();
            } else {
                this.writeMessage("Invalid search string ");
                return;
            }
        }
        String replaceText = MoeEditor.smartFormat(searchString, replaceString);
        this.insertText(replaceText, true);
        this.sourcePane.setCaretPosition(caretPos);
        this.finder.find(true);
        this.writeMessage("Replaced an instance of " + searchString);
    }

    public void findNext(boolean backwards) {
        String selection = this.currentTextPane.getSelectedText();
        if (selection == null) {
            selection = this.finder.getSearchString();
        }
        if (this.finder.isVisible()) {
            this.finder.setSearchString(selection);
            if (backwards) {
                this.finder.getPrev();
            } else {
                this.finder.getNext();
            }
        } else {
            this.removeSearchHighlights();
            MoeEditor.removeSelection(this.currentTextPane);
            this.findString(selection, backwards, !this.finder.getMatchCase(), true);
        }
    }

    boolean findString(String s, boolean backward, boolean ignoreCase, boolean wrap) {
        boolean found;
        if (s.length() == 0) {
            this.info.message(" ");
            return false;
        }
        if (backward) {
            found = this.doFindBackward(s, ignoreCase, wrap);
        } else {
            this.setCaretPositionForward(1);
            found = this.doFind(s, ignoreCase, wrap);
        }
        StringBuilder msg = new StringBuilder(Config.getString((String)"editor.find.find.label") + " ");
        msg.append(backward ? Config.getString((String)"editor.find.backward") : Config.getString((String)"editor.find.forward"));
        if (ignoreCase || wrap) {
            msg.append(" (");
        }
        if (ignoreCase) {
            msg.append(Config.getString((String)"editor.find.ignoreCase").toLowerCase()).append(", ");
        }
        if (wrap) {
            msg.append(Config.getString((String)"editor.find.wrapAround").toLowerCase()).append(", ");
        }
        if (ignoreCase || wrap) {
            msg.replace(msg.length() - 2, msg.length(), "): ");
        } else {
            msg.append(": ");
        }
        msg.append(s);
        if (found) {
            this.info.message(msg.toString());
        } else {
            this.info.warning(msg.toString(), Config.getString((String)"editor.info.notFound"));
        }
        return found;
    }

    boolean doFind(String s, boolean ignoreCase, boolean wrap) {
        int docLength = this.document.getLength();
        int startPosition = this.currentTextPane.getCaretPosition();
        int endPos = docLength;
        boolean found = false;
        boolean finished = false;
        int start = startPosition;
        Element line = this.getLineAt(start);
        int lineEnd = Math.min(line.getEndOffset(), endPos);
        try {
            while (!found && !finished) {
                int foundPos;
                String lineText = this.document.getText(start, lineEnd - start);
                if (lineText != null && lineText.length() > 0 && (foundPos = MoeEditor.findSubstring(lineText, s, ignoreCase, false)) != -1) {
                    this.currentTextPane.select(start + foundPos, start + foundPos + s.length());
                    this.currentTextPane.getCaret().setSelectionVisible(true);
                    found = true;
                }
                if (lineEnd >= endPos) {
                    if (wrap) {
                        endPos = startPosition;
                        line = this.document.getParagraphElement(0);
                        start = line.getStartOffset();
                        lineEnd = Math.min(line.getEndOffset(), endPos);
                        wrap = false;
                        continue;
                    }
                    finished = true;
                    continue;
                }
                line = this.document.getParagraphElement(lineEnd + 1);
                start = line.getStartOffset();
                lineEnd = Math.min(line.getEndOffset(), endPos);
            }
        }
        catch (BadLocationException ex) {
            Debug.reportError((String)"Error in editor find operation", (Throwable)ex);
        }
        return found;
    }

    boolean doFindBackward(String s, boolean ignoreCase, boolean wrap) {
        int docLength = this.document.getLength();
        int startPosition = this.currentTextPane.getCaretPosition() - 1;
        if (startPosition < 0) {
            startPosition = docLength;
        }
        int endPos = 0;
        boolean found = false;
        boolean finished = false;
        int start = startPosition;
        Element line = this.getLineAt(start);
        int lineStart = Math.max(line.getStartOffset(), endPos);
        try {
            while (!found && !finished) {
                int foundPos;
                String lineText = this.document.getText(lineStart, start - lineStart);
                if (lineText != null && lineText.length() > 0 && (foundPos = MoeEditor.findSubstring(lineText, s, ignoreCase, true)) != -1) {
                    this.currentTextPane.select(lineStart + foundPos, lineStart + foundPos + s.length());
                    this.currentTextPane.getCaret().setSelectionVisible(true);
                    found = true;
                }
                if (lineStart <= endPos) {
                    if (wrap) {
                        endPos = startPosition;
                        line = this.document.getParagraphElement(docLength);
                        start = line.getEndOffset();
                        lineStart = Math.max(line.getStartOffset(), endPos);
                        wrap = false;
                        continue;
                    }
                    finished = true;
                    continue;
                }
                line = this.document.getParagraphElement(lineStart - 1);
                start = line.getEndOffset();
                lineStart = Math.max(line.getStartOffset(), endPos);
            }
        }
        catch (BadLocationException ex) {
            Debug.reportError((String)"Error in editor find operation", (Throwable)ex);
        }
        return found;
    }

    int doFindSelect(String s, boolean ignoreCase, boolean wrap) {
        boolean select = true;
        int docLength = this.document.getLength();
        int startPosition = this.currentTextPane.getCaretPosition();
        int endPos = docLength;
        int highlightCount = 0;
        boolean finished = false;
        int start = startPosition;
        Element line = this.document.getParagraphElement(start);
        int lineEnd = line.getEndOffset();
        int foundPos = 0;
        try {
            while (!finished) {
                String lineText = this.document.getText(start, lineEnd - start);
                while (lineText != null && lineText.length() > 0) {
                    if ((foundPos = MoeEditor.findSubstring(lineText, s, ignoreCase, false, foundPos)) != -1) {
                        this.addSearchHighlight(start + foundPos, start + foundPos + s.length());
                        ++highlightCount;
                        if (select) {
                            this.currentTextPane.select(start + foundPos, start + foundPos + s.length());
                            this.setSelectionVisible();
                            startPosition = start + foundPos;
                            select = false;
                        }
                        foundPos += s.length();
                        continue;
                    }
                    lineText = null;
                }
                if (lineEnd >= endPos) {
                    if (wrap) {
                        endPos = Math.min(startPosition + s.length() - 1, this.document.getLength());
                        line = this.document.getParagraphElement(0);
                        start = line.getStartOffset();
                        lineEnd = Math.min(line.getEndOffset(), endPos);
                        wrap = false;
                        continue;
                    }
                    finished = true;
                    continue;
                }
                line = this.document.getParagraphElement(lineEnd + 1);
                start = line.getStartOffset();
                lineEnd = Math.min(line.getEndOffset(), endPos);
            }
        }
        catch (BadLocationException ex) {
            Debug.reportError((String)"Error in editor find operation", (Throwable)ex);
        }
        return highlightCount;
    }

    private void addSearchHighlight(int startPos, int endPos) {
        try {
            MoeHighlighter highlighter = (MoeHighlighter)this.currentTextPane.getHighlighter();
            Object tag = highlighter.addHighlight(startPos, endPos, searchHighlightPainter);
            if (this.currentTextPane == this.sourcePane) {
                this.sourceSearchHighlightTags.add(tag);
            } else {
                this.htmlSearchHighlightTags.add(tag);
            }
        }
        catch (BadLocationException ble) {
            Debug.reportError((String)"Error adding search highlight", (Throwable)ble);
        }
    }

    public void goToLine() {
        int numberOfLines = this.numberOfLines();
        Platform.runLater(() -> {
            if (this.goToLineDialog == null) {
                this.goToLineDialog = new GoToLineDialog(this.fxTabbedEditor.getWindow());
            }
            this.goToLineDialog.setRangeMax(numberOfLines);
            Optional o = this.goToLineDialog.showAndWait();
            SwingUtilities.invokeLater(() -> o.ifPresent(n -> this.setSelection((int)n, 1, 0)));
        });
    }

    public void toggleInterfaceMenu() {
        if (!this.sourceIsCode) {
            return;
        }
        if (this.interfaceToggle.getSelectedIndex() == 0) {
            this.interfaceToggle.setSelectedIndex(1);
        } else {
            this.interfaceToggle.setSelectedIndex(0);
        }
    }

    public void toggleInterface() {
        boolean wantHTML;
        if (!this.sourceIsCode) {
            return;
        }
        boolean bl = wantHTML = this.interfaceToggle.getSelectedItem() == this.interfaceString;
        if (wantHTML && !this.viewingHTML) {
            this.switchToInterfaceView();
        } else if (!wantHTML && this.viewingHTML) {
            this.switchToSourceView();
        }
    }

    public void enablePrinting(boolean flag) {
        Action pageSetupAction;
        Action printAction = this.actions.getActionByName("print");
        if (printAction != null) {
            printAction.setEnabled(flag);
        }
        if ((pageSetupAction = this.actions.getActionByName("page-setup")) != null) {
            pageSetupAction.setEnabled(flag);
        }
    }

    private void initSearch() {
        if (this.isShowingInterface()) {
            this.finder.setSearchStart(0);
        } else {
            this.finder.setSearchStart(this.getCurrentTextPane().getCaretPosition());
        }
        this.finder.setSearchString(null);
        this.removeSearchHighlights();
        this.removeSelections();
        this.finder.setSearchString(null);
        this.replacer.setReplaceString(null);
        this.replacer.populateReplaceField(null);
        if (this.finder.isVisible()) {
            this.initFindPanel();
        }
    }

    private void switchToSourceView() {
        if (!this.viewingHTML) {
            return;
        }
        this.resetMenuToolbar(true);
        this.document = this.sourceDocument;
        this.currentTextPane = this.sourcePane;
        this.viewingHTML = false;
        this.watcher.showingInterface(false);
        this.scrollPane.setViewportView(this.currentTextPane);
        this.dividerPanel.endTemporaryHide();
        this.currentTextPane.requestFocus();
        this.initSearch();
    }

    private void switchToInterfaceView() {
        if (this.viewingHTML) {
            return;
        }
        this.resetMenuToolbar(false);
        this.dividerPanel.beginTemporaryHide();
        try {
            this.save();
            this.displayInterface();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void refreshHtmlDisplay() {
        block5: {
            FileInputStream fis = null;
            try {
                File urlFile = new File(this.getDocPath());
                URL myURL = urlFile.toURI().toURL();
                HTMLEditorKit ekit = new HTMLEditorKit();
                this.htmlDocument = (HTMLDocument)ekit.createDefaultDocument();
                this.htmlDocument.setBase(myURL);
                this.htmlDocument.putProperty("IgnoreCharsetDirective", true);
                this.htmlDocument.putProperty("stream", myURL);
                fis = new FileInputStream(urlFile);
                InputStreamReader r = new InputStreamReader((InputStream)fis, this.characterSet);
                ekit.read(r, (Document)this.htmlDocument, 0);
                ((Reader)r).close();
                this.htmlPane.setDocument(this.htmlDocument);
                this.info.message(Config.getString((String)"editor.info.docLoaded"));
                if (this.isShowingInterface()) {
                    this.document = this.htmlDocument;
                }
            }
            catch (IOException | BadLocationException exc) {
                this.info.warning(Config.getString((String)"editor.info.docDisappeared"), this.getDocPath());
                Debug.reportError((String)("loading class interface failed: " + exc));
                if (fis == null) break block5;
                try {
                    fis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private boolean docUpToDate() {
        if (this.filename == null) {
            return true;
        }
        try {
            File src = new File(this.filename);
            File doc = new File(this.docFilename);
            if (!doc.exists() || src.exists() && src.lastModified() > doc.lastModified()) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void resetMenuToolbar(boolean sourceView) {
        boolean canUndo = false;
        boolean canRedo = false;
        this.displayMenubar(sourceView);
        this.displayToolbar(sourceView);
        if (sourceView) {
            canUndo = this.undoManager.canUndo();
            canRedo = this.undoManager.canRedo();
        }
        this.updateUndoRedoControls(canUndo, canRedo);
    }

    private void displayMenubar(boolean sourceView) {
        Component[] menus;
        for (Component menu : menus = this.menubar.getComponents()) {
            if (!(menu instanceof JMenu)) continue;
            JMenu jmenu = (JMenu)menu;
            for (int j = 0; j < jmenu.getMenuComponentCount(); ++j) {
                if (!(jmenu.getMenuComponent(j) instanceof JMenuItem) || !MoeEditor.isEditAction(((JMenuItem)jmenu.getMenuComponent(j)).getName())) continue;
                ((JMenuItem)jmenu.getMenuComponent(j)).setEnabled(sourceView);
            }
        }
    }

    private void displayToolbar(boolean sourceView) {
        Component[] buttons;
        for (Component button : buttons = this.toolbar.getComponents()) {
            JButton actionButton;
            if (!(button instanceof JButton) || !MoeEditor.isEditAction((actionButton = (JButton)button).getName())) continue;
            actionButton.setEnabled(sourceView);
        }
    }

    private JButton findToolbarButton(String itemName) {
        Component[] buttons;
        for (Component button : buttons = this.toolbar.getComponents()) {
            JButton actionButton;
            if (!(button instanceof JButton) || !(actionButton = (JButton)button).getName().equals(itemName)) continue;
            return actionButton;
        }
        return null;
    }

    private JMenuItem findMenuItem(String itemName) {
        Component[] menubarComponent;
        for (Component menu : menubarComponent = this.menubar.getComponents()) {
            if (!(menu instanceof JMenu)) continue;
            JMenu jmenu = (JMenu)menu;
            for (int j = 0; j < jmenu.getMenuComponentCount(); ++j) {
                JMenuItem menuItem;
                if (!(jmenu.getMenuComponent(j) instanceof JMenuItem) || !(menuItem = (JMenuItem)jmenu.getMenuComponent(j)).getName().equals(itemName)) continue;
                return menuItem;
            }
        }
        return null;
    }

    private void displayInterface() {
        boolean generateDoc;
        this.info.message(Config.getString((String)"editor.info.loadingDoc"));
        boolean bl = generateDoc = !this.docUpToDate();
        if (this.htmlPane == null) {
            this.createHTMLPane();
            if (!generateDoc) {
                this.refreshHtmlDisplay();
            }
        } else if (!generateDoc) {
            this.info.message(Config.getString((String)"editor.info.docLoaded"));
        }
        if (generateDoc) {
            this.htmlDocument = new HTMLDocument();
            this.htmlPane.setDocument(this.htmlDocument);
            this.info.message(Config.getString((String)"editor.info.generatingDoc"));
            BlueJEvent.addListener((BlueJEventListener)this);
            if (this.watcher != null) {
                this.watcher.generateDoc();
            }
        }
        this.document = this.htmlDocument;
        this.currentTextPane = this.htmlPane;
        this.viewingHTML = true;
        this.watcher.showingInterface(true);
        this.scrollPane.setViewportView(this.htmlPane);
        this.currentTextPane.requestFocus();
        this.initSearch();
    }

    private void createHTMLPane() {
        this.htmlPane = new JEditorPane();
        this.htmlPane.setHighlighter(new MoeHighlighter());
        this.htmlPane.setEditorKit(new HTMLEditorKit());
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(this);
        this.htmlPane.setInputMap(0, new InputMap(){

            @Override
            public Object get(KeyStroke keyStroke) {
                Object action = super.get(keyStroke);
                if ("caret-up".equals(action) || "caret-down".equals(action)) {
                    return null;
                }
                return action;
            }
        });
        FXTabbedEditor.disableCtrlTabTraversal(this.htmlPane);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        this.info.clear();
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    pane.setPage(e.getURL());
                }
                catch (Throwable t) {
                    this.info.warning("cannot display hyperlink: " + e.getURL());
                    Debug.reportError((String)("hyperlink failed: " + t));
                }
            }
        }
    }

    public void toggleBreakpoint() {
        if (!this.viewingCode()) {
            this.info.warning(" ");
            return;
        }
        this.toggleBreakpoint(this.sourcePane.getCaretPosition());
    }

    public void toggleBreakpoint(int pos) {
        if (this.positionHasBreakpoint(pos)) {
            this.setUnsetBreakpoint(pos, false);
        } else {
            this.setUnsetBreakpoint(pos, true);
        }
    }

    private void clearAllBreakpoints() {
        if (this.mayHaveBreakpoints) {
            for (int i = 1; i <= this.numberOfLines(); ++i) {
                if (!this.lineHasBreakpoint(i)) continue;
                this.doRemoveBreakpoint(this.getPositionInLine(i));
            }
            this.mayHaveBreakpoints = false;
        }
    }

    private boolean positionHasBreakpoint(int pos) {
        Element line = this.getSourceLine(this.getLineNumberAt(pos));
        return Boolean.TRUE.equals(line.getAttributes().getAttribute("break"));
    }

    private boolean lineHasBreakpoint(int lineNo) {
        Element line = this.getSourceLine(lineNo);
        return Boolean.TRUE.equals(line.getAttributes().getAttribute("break"));
    }

    private void setUnsetBreakpoint(int pos, boolean set) {
        if (this.watcher != null) {
            int line = this.getLineNumberAt(pos);
            String result = this.watcher.breakpointToggleEvent(line, set);
            if (result == null) {
                SimpleAttributeSet a = new SimpleAttributeSet();
                if (set) {
                    a.addAttribute("break", Boolean.TRUE);
                    this.mayHaveBreakpoints = true;
                } else {
                    a.addAttribute("break", Boolean.FALSE);
                }
                this.sourceDocument.setParagraphAttributes(pos, a);
            } else {
                this.info.warning(result);
            }
            this.repaint();
        } else {
            this.info.warning(Config.getString((String)"editor.info.cannotSetBreak"));
        }
    }

    private void doRemoveBreakpoint(int pos) {
        SimpleAttributeSet a = new SimpleAttributeSet();
        a.addAttribute("break", Boolean.FALSE);
        this.sourceDocument.setParagraphAttributes(pos, a);
        this.repaint();
    }

    private void setStepMark(int pos) {
        this.removeStepMark();
        SimpleAttributeSet a = new SimpleAttributeSet();
        a.addAttribute("step", Boolean.TRUE);
        this.sourceDocument.setParagraphAttributes(pos, a);
        this.currentStepPos = pos;
        this.repaint();
    }

    private boolean viewingCode() {
        return this.sourceIsCode && !this.viewingHTML;
    }

    private Element getSourceLine(int lineNo) {
        Element map = this.sourceDocument.getDefaultRootElement();
        if (map.getElementCount() >= lineNo) {
            return this.sourceDocument.getDefaultRootElement().getElement(lineNo - 1);
        }
        return null;
    }

    private Element getLineAt(int pos) {
        return this.document.getParagraphElement(pos);
    }

    private int getPositionInLine(int lineNo) {
        return this.getSourceLine(lineNo).getStartOffset();
    }

    private int getLineNumberAt(int pos) {
        return this.sourceDocument.getDefaultRootElement().getElementIndex(pos) + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReload() {
        this.removeSearchHighlights();
        Reader reader = null;
        boolean isShowingSrc = this.sourceDocument == this.document;
        try {
            FileInputStream inputStream = new FileInputStream(this.filename);
            reader = new InputStreamReader((InputStream)inputStream, this.characterSet);
            this.sourcePane.read(reader, null);
            try {
                reader.close();
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            File file = new File(this.filename);
            this.lastModified = file.lastModified();
            this.sourceDocument = (MoeSyntaxDocument)((Object)this.sourcePane.getDocument());
            this.sourceDocument.enableParser(false);
            this.naviView.setDocument((Document)((Object)this.sourceDocument));
            this.sourceDocument.addDocumentListener(this);
            this.sourceDocument.addUndoableEditListener(this.undoManager);
            this.saveState.setState(1);
            this.setChanged();
            this.setSaved();
            this.scheduleReparseRunner();
            if (this.watcher != null) {
                this.watcher.scheduleCompilation(false, CompileReason.LOADED, CompileType.ERROR_CHECK_ONLY);
            }
        }
        catch (FileNotFoundException ex) {
            this.info.warning(Config.getString((String)"editor.info.fileDisappeared"));
        }
        catch (IOException ex) {
            this.info.warning(Config.getString((String)"editor.info.fileReadError"));
            this.setChanged();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {}
            if (isShowingSrc) {
                this.document = this.sourceDocument;
            }
            if (this.finder != null && this.finder.isVisible()) {
                this.finder.find(true);
            }
        }
    }

    private void checkBracketStatus() {
        matchBrackets = PrefMgr.getFlag((String)"bluej.editor.matchBrackets");
        if (matchBrackets) {
            this.doBracketMatch();
        } else {
            this.moeCaret.removeBracket();
        }
    }

    public void setCaretActive(boolean active) {
        if (!active) {
            this.currentTextPane.setCaret(new NullCaret(this.moeCaret.getMark(), this.moeCaret.getDot()));
        } else {
            Caret caret = this.currentTextPane.getCaret();
            this.currentTextPane.setCaret(this.moeCaret);
            this.moeCaret.setDot(caret.getMark());
            this.moeCaret.moveDot(caret.getDot());
        }
    }

    private void setCompileStatus(boolean compiled) {
        this.actions.getActionByName("toggle-breakpoint").setEnabled(compiled && this.viewingCode());
        if (compiled) {
            this.sourceDocument.putProperty(COMPILED, Boolean.TRUE);
        } else {
            this.sourceDocument.putProperty(COMPILED, Boolean.FALSE);
        }
        this.currentTextPane.repaint();
    }

    private void setSaved() {
        this.info.message(Config.getString((String)"editor.info.saved"));
        this.saveState.setState(1);
        if (this.watcher != null) {
            this.watcher.saveEvent(this);
        }
    }

    private void setChanged() {
        if (this.ignoreChanges) {
            return;
        }
        this.setCompileStatus(false);
        if (this.watcher != null) {
            this.watcher.modificationEvent(this);
        }
    }

    public void caretMoved() {
        int caretPos = this.sourcePane.getCaretPosition();
        this.showErrorPopupForCaretPos(caretPos, false);
        this.enableReplaceButtons();
        if (matchBrackets) {
            this.doBracketMatch();
        }
        this.actions.userAction();
        if (this.oldCaretLineNumber != this.getLineNumberAt(caretPos)) {
            this.recordEdit(true);
            this.cancelFreshState();
        }
        this.oldCaretLineNumber = this.getLineNumberAt(caretPos);
    }

    private void showErrorPopupForCaretPos(int caretPos, boolean mousePosition) {
        MoeErrorManager.ErrorDetails err = this.errorManager.getErrorAtPosition(caretPos);
        if (err != null) {
            this.showErrorOverlay(err, caretPos);
        } else if (!(this.errorDisplay == null || mousePosition && this.errorDisplay.details.containsPosition(this.sourcePane.getCaretPosition()))) {
            this.showErrorOverlay(null, caretPos);
        }
    }

    @Override
    public void cancelFreshState() {
        if (this.madeChangeOnCurrentLine) {
            if (this.watcher != null) {
                this.watcher.scheduleCompilation(true, CompileReason.MODIFIED, CompileType.ERROR_CHECK_ONLY);
            }
            this.madeChangeOnCurrentLine = false;
        }
    }

    @Override
    public void focusMethod(String methodName) {
        this.focusMethod(methodName, (NodeTree.NodeAndPosition<ParsedNode>)new NodeTree.NodeAndPosition((RBTreeNode)this.getParsedNode(), 0, 0), 0);
    }

    private boolean focusMethod(String methodName, NodeTree.NodeAndPosition<ParsedNode> tree, int offset) {
        if (((ParsedNode)tree.getNode()).getNodeType() == 2 && methodName.equals(((ParsedNode)tree.getNode()).getName())) {
            this.switchToSourceView();
            this.sourcePane.setCaretPosition(offset);
            return true;
        }
        for (NodeTree.NodeAndPosition child : () -> ((ParsedNode)tree.getNode()).getChildren(0)) {
            if (!this.focusMethod(methodName, (NodeTree.NodeAndPosition<ParsedNode>)child, offset + child.getPosition())) continue;
            return true;
        }
        return false;
    }

    private void showErrorOverlay(MoeErrorManager.ErrorDetails details, int displayPosition) {
        if (details != null) {
            if (this.errorDisplay == null || this.errorDisplay.details != details) {
                if (this.errorDisplay != null) {
                    this.errorDisplay.setVisible(false);
                }
                this.errorDisplay = new ErrorDisplay(details);
                try {
                    Rectangle pos = this.sourcePane.modelToView(displayPosition);
                    Point spLoc = this.sourcePane.getLocationOnScreen();
                    int xpos = pos.x + spLoc.x;
                    int ypos = pos.y + 3 * pos.height / 2 + spLoc.y;
                    this.errorDisplay.setLocation(xpos, ypos);
                    this.errorDisplay.setVisible(true);
                    if (this.watcher != null) {
                        this.watcher.recordShowErrorMessage(details.identifier, Collections.emptyList());
                    }
                }
                catch (BadLocationException ble) {
                    Debug.reportError((Throwable)ble);
                }
            }
        } else if (this.errorDisplay != null) {
            this.errorDisplay.setVisible(false);
            this.errorDisplay = null;
        }
    }

    public int getBracketMatch() {
        int pos = -1;
        try {
            int caretPos = this.sourcePane.getCaretPosition();
            if (caretPos != 0) {
                --caretPos;
            }
            pos = TextUtilities.findMatchingBracket((Document)((Object)this.sourceDocument), caretPos);
        }
        catch (BadLocationException ble) {
            Debug.reportError((String)"Bad document location reached while trying to match brackets");
            Debug.log((String)("Caret position: " + this.sourcePane.getCaretPosition()));
            Debug.log((String)("Document length: " + this.sourcePane.getText().length()));
            Debug.log((String)"Source code: ---begin---");
            Debug.log((String)this.sourcePane.getText());
            Debug.log((String)"---end---");
        }
        return pos;
    }

    private void doBracketMatch() {
        this.moeCaret.paintMatchingBracket();
    }

    private void setWindowTitle() {
        String title = this.windowTitle;
        if (title == null) {
            title = this.filename == null ? "Moe:  <no name>" : "Moe:  " + this.filename;
        }
        String finalTitle = title;
        Platform.runLater(() -> this.fxTab.setWindowTitle(finalTitle));
    }

    private String getDocPath() {
        return this.docFilename;
    }

    private String getResource(String name) {
        return Config.getPropString((String)name, null, (Properties)this.resources);
    }

    private void initWindow(EntityResolver projectResolver) {
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel bottomArea = new JPanel();
        bottomArea.setLayout(new BorderLayout(6, 1));
        if (!Config.isRaspberryPi()) {
            bottomArea.setOpaque(false);
        }
        JPanel finderPanel = new JPanel((LayoutManager)new DBoxLayout(DBox.Y_AXIS, 0, 0));
        finderPanel.setBorder(BorderFactory.createEmptyBorder(0, 11, 0, 0));
        if (!Config.isRaspberryPi()) {
            finderPanel.setOpaque(false);
        }
        int smallSpc = 5;
        this.finder = new FindPanel(this);
        this.finder.setVisible(false);
        this.finder.setBorder(BorderFactory.createEmptyBorder(0, 0, smallSpc, 0));
        this.finder.setName("FinderPanel");
        this.finder.setAlignmentX(0.0f);
        if (!Config.isRaspberryPi()) {
            this.finder.setOpaque(false);
        }
        finderPanel.add(this.finder);
        this.replacer = new ReplacePanel(this, this.finder);
        this.replacer.setVisible(false);
        this.replacer.setBorder(BorderFactory.createEmptyBorder(0, 0, smallSpc, 0));
        this.replacer.setAlignmentX(0.0f);
        if (!Config.isRaspberryPi()) {
            this.replacer.setOpaque(false);
        }
        finderPanel.add(this.replacer);
        bottomArea.add((Component)finderPanel, "North");
        this.statusArea = new JPanel();
        this.statusArea.setLayout(new GridLayout(0, 1));
        this.statusArea.setBackground(infoColor);
        this.statusArea.setBorder(BorderFactory.createLineBorder(Color.black));
        this.saveState = new StatusLabel(1);
        this.statusArea.add(this.saveState);
        this.info = new Info((FXPlatformSupplier<javafx.stage.Window>)((FXPlatformSupplier)() -> this.fxTabbedEditor.getWindow()));
        JPanel commentsPanel = new JPanel(new BorderLayout(6, 1));
        if (!Config.isRaspberryPi()) {
            commentsPanel.setOpaque(false);
        }
        commentsPanel.add((Component)this.info, "Center");
        commentsPanel.add((Component)this.statusArea, "East");
        bottomArea.add((Component)commentsPanel, "South");
        this.add((Component)bottomArea, "South");
        this.sourceDocument = projectResolver != null ? new MoeSyntaxDocument(projectResolver, this.errorManager) : new MoeSyntaxDocument();
        this.sourceDocument.addDocumentListener(this);
        this.sourceDocument.addUndoableEditListener(this.undoManager);
        MoeSyntaxEditorKit kit = projectResolver != null ? new MoeSyntaxEditorKit(projectResolver, this.errorManager, this.errorManager) : new ReadmeEditorKit();
        this.sourcePane = new MoeEditorPane();
        this.sourcePane.setDocument((Document)((Object)this.sourceDocument));
        this.sourcePane.setCaretPosition(0);
        this.sourcePane.setMargin(new Insets(2, 0, 2, 0));
        this.sourcePane.setOpaque(true);
        this.sourcePane.setEditorKit(kit);
        this.moeCaret = new MoeCaret(this);
        this.sourcePane.setCaret(this.moeCaret);
        this.sourcePane.setBackground(MoeSyntaxDocument.getBackgroundColor());
        FXTabbedEditor.disableCtrlTabTraversal(this.sourcePane);
        this.sourcePane.setSelectionColor(selectionColour);
        this.sourcePane.setCaretColor(cursorColor);
        this.currentTextPane = this.sourcePane;
        JPanel editorPane = new JPanel();
        editorPane.setLayout(new BoxLayout(editorPane, 0));
        if (!Config.isRaspberryPi()) {
            editorPane.setOpaque(false);
        }
        this.scrollPane = new JScrollPane(this.currentTextPane);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.naviView = new NaviView((Document)((Object)this.sourceDocument), this.errorManager, this.scrollPane.getVerticalScrollBar());
        this.naviView.setPreferredSize(new Dimension(90, 0));
        this.naviView.setMaximumSize(new Dimension(90, Integer.MAX_VALUE));
        this.naviView.setBorder(BorderFactory.createBevelBorder(1));
        this.dividerPanel = new EditorDividerPanel(this.naviView, this.getNaviviewExpandedProperty());
        if (!Config.isRaspberryPi()) {
            this.dividerPanel.setOpaque(false);
        }
        editorPane.add(this.scrollPane);
        editorPane.add(this.dividerPanel);
        editorPane.add(this.naviView);
        this.add((Component)editorPane, "Center");
        this.actions = MoeActions.getActions(this, this.sourcePane);
        this.actions.setUndoEnabled(false);
        this.actions.setRedoEnabled(false);
        this.menubar = this.createMenuBar();
        this.menubar.setName("menubar");
        FXPlatformSupplier genMenubar = JavaFXUtil.swingMenuBarToFX((JMenuBar)this.menubar, (Object)this);
        Platform.runLater(() -> {
            this.fxMenus.clear();
            ((MenuBar)genMenubar.get()).getMenus().forEach(this.fxMenus::add);
        });
        this.toolbar = this.createToolbar();
        this.toolbar.setName("toolbar");
        if (!Config.isRaspberryPi()) {
            this.toolbar.setOpaque(false);
        }
        this.add((Component)this.toolbar, "North");
        this.popup = this.createPopupMenu();
        this.setFocusTraversalPolicy(new MoeFocusTraversalPolicy());
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle maxBounds = ge.getMaximumWindowBounds();
        int myWidth = Math.min(900, (int)maxBounds.getWidth());
        int myHeight = Math.min(700, (int)maxBounds.getHeight());
        this.setSize(myWidth, myHeight);
    }

    private JMenuBar createMenuBar() {
        String[] menuKeys;
        JMenuBar menubar = new JMenuBar();
        for (String menuKey : menuKeys = this.getResource("menubar").split(" ")) {
            JMenu menu = this.createMenu(menuKey);
            if (menu == null) continue;
            menubar.add(menu);
        }
        return menubar;
    }

    private JPopupMenu createPopupMenu() {
        String[] popupKeys;
        this.popup = new JPopupMenu();
        for (String popupKey : popupKeys = this.getResource("popupmenu").split(" ")) {
            String label = Config.getString((String)("editor." + popupKey + LabelSuffix));
            String actionName = this.getResource(popupKey + ActionSuffix);
            Action action = this.actions.getActionByName(actionName);
            if (action == null) {
                Debug.message((String)("Moe: cannot find action " + popupKey));
                continue;
            }
            JMenuItem menuItem = new JMenuItem(action);
            menuItem.setText(label);
            this.popup.add(menuItem);
        }
        return this.popup;
    }

    private JMenu createMenu(String key) {
        String[] itemKeys;
        JMenu menu = new JMenu(Config.getString((String)("editor." + key + LabelSuffix)));
        int mnemonic = Config.getMnemonicKey((String)("editor." + key + LabelSuffix));
        menu.setMnemonic(mnemonic);
        String itemString = this.getResource(key);
        if (itemString == null) {
            Debug.message((String)("Moe: cannot find menu definition for " + key));
            return null;
        }
        for (String itemKey : itemKeys = itemString.split(" ")) {
            if (itemKey.equals("-")) {
                menu.addSeparator();
                continue;
            }
            Action action = this.actions.getActionByName(itemKey);
            if (action == null) {
                Debug.message((String)("Moe: cannot find action " + itemKey));
                continue;
            }
            JMenuItem item = menu.add(action);
            String label = Config.getString((String)("editor." + itemKey + LabelSuffix));
            item.setText(label);
            KeyStroke[] keys = this.actions.getKeyStrokesForAction(action);
            if (keys != null) {
                KeyStroke keyStroke = MoeEditor.chooseKey(keys);
                item.setAccelerator(keyStroke);
                this.actions.setKeyStrokeBindingToDoNothingAction(keyStroke, this);
            }
            item.setName(itemKey);
            if (!MoeEditor.isNonReadmeAction(itemKey)) continue;
            item.setEnabled(this.sourceIsCode);
        }
        return menu;
    }

    private JComponent createToolbar() {
        String[] toolGroups;
        JPanel toolbar = new JPanel();
        toolbar.setLayout(new BoxLayout(toolbar, 0));
        for (String group : toolGroups = this.getResource("toolbar").split(" ")) {
            this.addToolbarGroup(toolbar, group);
        }
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(this.createInterfaceSelector());
        return toolbar;
    }

    private void addToolbarGroup(JComponent toolbar, String group) {
        String[] toolKeys;
        for (String toolKey : toolKeys = group.split(":")) {
            toolbar.add(this.createToolbarButton(toolKey));
            if (Config.isMacOSLeopard()) continue;
            toolbar.add(Box.createHorizontalStrut(3));
        }
    }

    private AbstractButton createToolbarButton(String key) {
        JButton button;
        Action action;
        String label = Config.getString((String)("editor." + key + LabelSuffix));
        String actionName = this.getResource(key + ActionSuffix);
        if (actionName == null) {
            actionName = key;
        }
        if ((action = this.actions.getActionByName(actionName)) != null) {
            ToolbarAction tbAction = new ToolbarAction(action, label);
            button = new JButton(tbAction);
        } else {
            button = new JButton("Unknown");
        }
        button.setName(actionName);
        if (action == null) {
            button.setEnabled(false);
            Debug.message((String)("Moe: action not found for button " + label));
        }
        if (MoeEditor.isNonReadmeAction(actionName) && !this.sourceIsCode) {
            button.setEnabled(false);
        }
        button.setRequestFocusEnabled(false);
        if (!Config.isMacOS()) {
            Insets margin = button.getMargin();
            button.setMargin(new Insets(margin.top, 3, margin.bottom, 3));
        } else {
            Utility.changeToMacButton((AbstractButton)button);
        }
        button.setFont(PrefMgr.getStandardFont());
        return button;
    }

    private JComboBox<String> createInterfaceSelector() {
        String actionName;
        Action action;
        String[] choiceStrings = new String[]{this.implementationString, this.interfaceString};
        this.interfaceToggle = new JComboBox<String>(choiceStrings);
        this.interfaceToggle.setRequestFocusEnabled(false);
        this.interfaceToggle.setFont(PrefMgr.getStandardFont());
        this.interfaceToggle.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.interfaceToggle.setForeground(envOpColour);
        if (!Config.isRaspberryPi()) {
            this.interfaceToggle.setOpaque(false);
        }
        if ((action = this.actions.getActionByName(actionName = "toggle-interface-view")) != null) {
            this.interfaceToggle.setAction(action);
        } else {
            this.interfaceToggle.setEnabled(false);
            Debug.message((String)("Moe: action not found: " + actionName));
        }
        if (!this.sourceIsCode) {
            this.interfaceToggle.setEnabled(false);
        }
        return this.interfaceToggle;
    }

    public void initFindPanel() {
        this.finder.displayFindPanel(this.currentTextPane.getSelectedText());
        if (this.isShowingInterface()) {
            this.finder.setReplaceEnabled(false);
            this.replacer.setVisible(false);
        } else {
            this.finder.setReplaceEnabled(true);
        }
    }

    public void setCaretPositionForward(int caretPos) {
        int docLength = this.document.getLength();
        if (this.currentTextPane.getCaretPosition() + caretPos <= docLength) {
            this.currentTextPane.setCaretPosition(this.currentTextPane.getCaretPosition() + caretPos);
        } else {
            this.currentTextPane.setCaretPosition(docLength);
        }
    }

    public JEditorPane getSourcePane() {
        return this.sourcePane;
    }

    public JEditorPane getHTMLPane() {
        return this.htmlPane;
    }

    public JEditorPane getCurrentTextPane() {
        return this.currentTextPane;
    }

    public MoeSyntaxDocument getSourceDocument() {
        return this.sourceDocument;
    }

    public void removeSearchHighlights() {
        for (Object tag : this.sourceSearchHighlightTags) {
            this.sourcePane.getHighlighter().removeHighlight(tag);
        }
        this.sourceSearchHighlightTags.clear();
        for (Object tag : this.htmlSearchHighlightTags) {
            this.htmlPane.getHighlighter().removeHighlight(tag);
        }
        this.htmlSearchHighlightTags.clear();
    }

    public void removeSelections() {
        MoeEditor.removeSelection(this.sourcePane);
        MoeEditor.removeSelection(this.htmlPane);
    }

    protected void createContentAssist() {
        ParsedCUNode parser = this.sourceDocument.getParser();
        CodeSuggestions suggests = parser == null ? null : parser.getExpressionType(this.sourcePane.getCaretPosition(), (Document)((Object)this.sourceDocument));
        int xpos = 0;
        int ypos = 0;
        int cpos = this.sourcePane.getCaretPosition();
        try {
            Rectangle pos = this.sourcePane.modelToView(cpos);
            Point spLoc = this.sourcePane.getLocationOnScreen();
            xpos = pos.x + spLoc.x;
            ypos = pos.y + pos.height + spLoc.y;
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
        if (suggests != null) {
            LocatableToken suggestToken = suggests.getSuggestionToken();
            PopulateCompletionsWorker worker = new PopulateCompletionsWorker(suggests, suggestToken, xpos, ypos);
            worker.execute();
        } else {
            this.info.warning("No completions available.");
            CodeCompletionDisplay codeCompletionDlg = new CodeCompletionDisplay(this, this.watcher, null, new AssistContent[0], null);
            MoeEditor.initialiseContentAssist(codeCompletionDlg, xpos, ypos);
        }
    }

    public void setFindPanelVisible() {
        this.finder.setVisible(true);
    }

    public void replaceAll(String replaceString) {
        int caretPos = this.sourcePane.getCaretPosition();
        if (this.getSelectionBegin() != null) {
            this.sourcePane.setCaretPosition(this.getSelectionBegin().getColumn());
        }
        this.removeSearchHighlights();
        String searchString = this.finder.getSearchString();
        boolean isMatchCase = this.finder.getMatchCase();
        int count = 0;
        while (this.doFindBackward(searchString, !isMatchCase, false)) {
            this.insertText(MoeEditor.smartFormat(searchString, replaceString), true);
            ++count;
        }
        while (this.doFind(searchString, !isMatchCase, false)) {
            this.insertText(MoeEditor.smartFormat(searchString, replaceString), false);
            ++count;
        }
        this.removeSearchHighlights();
        this.sourcePane.setCaretPosition(caretPos);
        if (count > 0) {
            this.writeMessage(Config.getString((String)"editor.replaceAll.replaced").trim() + " " + count + " " + Config.getString((String)"editor.replaceAll.intancesOf").trim() + " " + searchString);
        } else {
            this.writeMessage(Config.getString((String)"editor.replaceAll.string").trim() + " " + searchString + " " + Config.getString((String)"editor.replaceAll.notFoundNothingReplaced"));
        }
    }

    protected void setSelectionVisible() {
        Caret caret = this.currentTextPane.getCaret();
        caret.setSelectionVisible(true);
        if (caret instanceof MoeCaret) {
            MoeCaret mcaret = (MoeCaret)caret;
            mcaret.setPersistentHighlight();
        }
    }

    protected String getFindSearchString() {
        return this.finder.getSearchString();
    }

    protected void enableReplaceButtons(boolean enable) {
        this.replacer.enableButtons(enable);
    }

    protected void enableReplaceButtons() {
        this.replacer.enableButtons();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.showPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.showPopup(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int caretPos = this.sourcePane.viewToModel(e.getPoint());
        if (caretPos != this.mouseCaretPos) {
            if (this.mouseHover != null) {
                this.mouseHover.stop();
            }
            this.mouseCaretPos = caretPos;
            this.mouseHover = new Timer(400, a -> this.showErrorPopupForCaretPos(caretPos, true));
            this.mouseHover.start();
        }
    }

    private void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void setFindTextfield(String text) {
        this.finder.populateFindTextfield(text);
    }

    protected boolean getNaviviewExpandedProperty() {
        if (this.watcher != null && this.watcher.getProperty("naviviewExpandedProperty") != null) {
            return Boolean.parseBoolean(this.watcher.getProperty("naviviewExpandedProperty"));
        }
        return PrefMgr.getNaviviewExpanded();
    }

    protected boolean containsSourceCode() {
        return this.sourceIsCode;
    }

    private void recordEdit(boolean includeOneLineEdits) {
        if (this.watcher != null) {
            try {
                this.watcher.recordEdit(SourceType.Java, this.sourceDocument.getText(0, this.sourceDocument.getLength()), includeOneLineEdits);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public TextEditor assumeText() {
        return this;
    }

    @Override
    public void insertAppendMethod(Editor e, NormalMethodElement method, Consumer<Boolean> after) {
        NodeTree.NodeAndPosition<ParsedNode> classNode = this.findClassNode();
        if (classNode != null) {
            NodeTree.NodeAndPosition<ParsedNode> existingMethodNode = this.findMethodNode(method.getName(), classNode);
            if (existingMethodNode != null) {
                String text = "";
                for (CodeElement codeElement : method.getContents()) {
                    text = text + codeElement.toJavaSource().toTemporaryJavaCodeString();
                }
                this.appendTextToNode(e, existingMethodNode, text);
                after.accept(true);
                return;
            }
            this.appendTextToNode(e, classNode, method.toJavaSource().toTemporaryJavaCodeString());
        }
        after.accept(false);
    }

    @Override
    public void insertMethodCallInConstructor(Editor e, String className, CallElement callElement, Consumer<Boolean> after) {
        NodeTree.NodeAndPosition<ParsedNode> classNode = this.findClassNode();
        if (classNode != null) {
            NodeTree.NodeAndPosition<ParsedNode> constructor = this.findMethodNode(className, classNode);
            if (constructor == null) {
                this.addDefaultConstructor(e, className, callElement);
            } else {
                String methodName = callElement.toJavaSource().toTemporaryJavaCodeString();
                if (!this.hasMethodCall(methodName = methodName.substring(0, methodName.indexOf(40)), constructor, true)) {
                    this.appendTextToNode(e, constructor, callElement.toJavaSource().toTemporaryJavaCodeString());
                    after.accept(true);
                    return;
                }
            }
        }
        after.accept(false);
    }

    private void addDefaultConstructor(Editor e, String className, CallElement callElement) {
        NodeTree.NodeAndPosition<ParsedNode> classNode = this.findClassNode();
        if (classNode != null) {
            this.appendTextToNode(e, classNode, "public " + className + "()\n{\n" + callElement.toJavaSource().toTemporaryJavaCodeString() + "}\n");
        }
    }

    private void appendTextToNode(Editor e, NodeTree.NodeAndPosition<ParsedNode> node, String text) {
        for (int pos = node.getEnd() - 1; pos >= 0; --pos) {
            if (!"}".equals(e.getText(e.getTextLocationFromOffset(pos), e.getTextLocationFromOffset(pos + 1)))) continue;
            this.undoManager.beginCompoundEdit();
            int originalLength = node.getSize();
            e.setText(e.getTextLocationFromOffset(pos), e.getTextLocationFromOffset(pos), text);
            int oldPos = this.getSourcePane().getCaretPosition();
            MoeIndent.calculateIndentsAndApply(this.sourceDocument, node.getPosition(), node.getPosition() + originalLength + text.length(), oldPos);
            this.undoManager.endCompoundEdit();
            e.setCaretLocation(e.getTextLocationFromOffset(pos));
            return;
        }
        Debug.message((String)("Could not find end of node to append to: \"" + e.getText(e.getTextLocationFromOffset(node.getPosition()), e.getTextLocationFromOffset(node.getEnd())) + "\""));
    }

    private NodeTree.NodeAndPosition<ParsedNode> findClassNode() {
        NodeTree.NodeAndPosition root = new NodeTree.NodeAndPosition((RBTreeNode)this.sourceDocument.getParser(), 0, this.sourceDocument.getParser().getSize());
        for (NodeTree.NodeAndPosition<ParsedNode> nap : this.iterable((NodeTree.NodeAndPosition<ParsedNode>)root)) {
            if (((ParsedNode)nap.getNode()).getNodeType() != 1) continue;
            return nap;
        }
        return null;
    }

    private NodeTree.NodeAndPosition<ParsedNode> findMethodNode(String methodName, NodeTree.NodeAndPosition<ParsedNode> start) {
        for (NodeTree.NodeAndPosition<ParsedNode> nap : this.iterable(start)) {
            NodeTree.NodeAndPosition<ParsedNode> r;
            if (((ParsedNode)nap.getNode()).getNodeType() == 0 && (r = this.findMethodNode(methodName, nap)) != null) {
                return r;
            }
            if (((ParsedNode)nap.getNode()).getNodeType() != 2 || !((ParsedNode)nap.getNode()).getName().equals(methodName)) continue;
            return nap;
        }
        return null;
    }

    private boolean hasMethodCall(String methodName, NodeTree.NodeAndPosition<ParsedNode> methodNode, boolean root) {
        for (NodeTree.NodeAndPosition<ParsedNode> nap : this.iterable(methodNode)) {
            if (((ParsedNode)nap.getNode()).getNodeType() == 0 && root) {
                return this.hasMethodCall(methodName, nap, false);
            }
            try {
                if (((ParsedNode)nap.getNode()).getNodeType() != 6 || !this.sourceDocument.getText(nap.getPosition(), nap.getSize()).startsWith(methodName)) continue;
                return true;
            }
            catch (BadLocationException badLocationException) {
            }
        }
        return false;
    }

    private Iterable<NodeTree.NodeAndPosition<ParsedNode>> iterable(NodeTree.NodeAndPosition<ParsedNode> parent) {
        return () -> ((ParsedNode)parent.getNode()).getChildren(parent.getPosition());
    }

    @Override
    @OnThread(value=Tag.FX)
    public FrameEditor assumeFrame() {
        return null;
    }

    @Override
    public boolean compileStarted() {
        this.madeChangeOnCurrentLine = false;
        this.errorManager.removeAllErrorHighlights();
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.fxTabbedEditor != null && this.fxTabbedEditor.isWindowVisibleSwing();
    }

    public String getTitle() {
        return this.windowTitle;
    }

    public void compileOrShowNextError() {
        if (this.watcher != null) {
            if (this.madeChangeOnCurrentLine || !this.errorManager.hasErrorHighlights()) {
                this.watcher.scheduleCompilation(true, CompileReason.USER, CompileType.EXPLICIT_USER_COMPILE);
                this.madeChangeOnCurrentLine = false;
            } else {
                int pos = this.errorManager.getNextErrorPos(this.sourcePane.getCaretPosition());
                if (pos >= 0) {
                    this.sourcePane.setCaretPosition(pos);
                }
            }
        }
    }

    public void notifyVisibleTab(boolean visible) {
        if (!visible) {
            this.showErrorOverlay(null, 0);
        }
        if (visible && this.watcher != null) {
            this.watcher.recordSelected();
        }
    }

    @OnThread(value=Tag.FX)
    public void setParent(FXTabbedEditor parent, boolean partOfMove) {
        SwingUtilities.invokeLater(() -> {
            if (this.watcher != null) {
                if (!partOfMove && parent != null) {
                    this.watcher.recordOpen();
                } else if (!partOfMove && parent == null) {
                    this.watcher.recordClose();
                }
                if (parent == null) {
                    this.watcher.scheduleCompilation(false, CompileReason.MODIFIED, CompileType.ERROR_CHECK_ONLY);
                }
            }
        });
        this.fxTabbedEditor = parent;
    }

    void updateHeaderHasErrors(boolean hasErrors) {
        Platform.runLater(() -> this.fxTab.setErrorStatus(hasErrors));
    }

    @OnThread(value=Tag.FX)
    public List<Menu> getFXMenu() {
        return this.fxMenus;
    }

    @OnThread(value=Tag.Any)
    public void requestEditorFocus() {
        SwingUtilities.invokeLater(() -> this.sourcePane.requestFocusInWindow());
    }

    @Override
    public void setExtendsClass(String className, ClassInfo info) {
        try {
            this.save();
            if (info != null) {
                if (info.getSuperclass() == null) {
                    Selection s1 = info.getExtendsInsertSelection();
                    this.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    this.insertText(" extends " + className, false);
                } else {
                    Selection s1 = info.getSuperReplaceSelection();
                    this.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    this.insertText(className, false);
                }
                this.save();
            }
        }
        catch (IOException ioe) {
            Platform.runLater(() -> DialogManager.showMessageWithTextFX((javafx.stage.Window)this.getWindow(), (String)"generic-file-save-error", (String)ioe.getLocalizedMessage()));
        }
    }

    @Override
    public void removeExtendsClass(ClassInfo info) {
        try {
            this.save();
            if (info != null) {
                Selection s1 = info.getExtendsReplaceSelection();
                s1.combineWith(info.getSuperReplaceSelection());
                if (s1 != null) {
                    this.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    this.insertText("", false);
                }
                this.save();
            }
        }
        catch (IOException ioe) {
            Platform.runLater(() -> DialogManager.showMessageWithTextFX((javafx.stage.Window)this.getWindow(), (String)"generic-file-save-error", (String)ioe.getLocalizedMessage()));
        }
    }

    @Override
    public void addImplements(String interfaceName, ClassInfo info) {
        try {
            this.save();
            if (info != null) {
                Selection s1 = info.getImplementsInsertSelection();
                this.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                if (info.hasInterfaceSelections()) {
                    List<String> exists = this.getInterfaceTexts(info.getInterfaceSelections());
                    if (!exists.contains(interfaceName)) {
                        this.insertText(", " + interfaceName, false);
                    }
                } else {
                    this.insertText(" implements " + interfaceName, false);
                }
                this.save();
            }
        }
        catch (IOException ioe) {
            Platform.runLater(() -> DialogManager.showMessageWithTextFX((javafx.stage.Window)this.getWindow(), (String)"generic-file-save-error", (String)ioe.getLocalizedMessage()));
        }
    }

    @Override
    public void addExtendsInterface(String interfaceName, ClassInfo info) {
        try {
            this.save();
            if (info != null) {
                Selection s1 = info.getExtendsInsertSelection();
                this.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                if (info.hasInterfaceSelections()) {
                    List<String> exists = this.getInterfaceTexts(info.getInterfaceSelections());
                    if (!exists.contains(interfaceName)) {
                        this.insertText(", " + interfaceName, false);
                    }
                } else {
                    this.insertText(" extends " + interfaceName, false);
                }
                this.save();
            }
        }
        catch (IOException ioe) {
            Platform.runLater(() -> DialogManager.showMessageWithTextFX((javafx.stage.Window)this.getWindow(), (String)"generic-file-save-error", (String)ioe.getLocalizedMessage()));
        }
    }

    @Override
    public void removeExtendsOrImplementsInterface(String interfaceName, ClassInfo info) {
        try {
            this.save();
            if (info != null) {
                Selection s1 = null;
                List vsels = info.getInterfaceSelections();
                List<String> vtexts = this.getInterfaceTexts(vsels);
                int where = vtexts.indexOf(interfaceName);
                if (where == 1 && vsels.size() > 2) {
                    where = 2;
                }
                if (where > 0) {
                    s1 = (Selection)vsels.get(where - 1);
                    s1.combineWith((Selection)vsels.get(where));
                }
                if (s1 != null) {
                    this.setSelection(s1.getLine(), s1.getColumn(), s1.getEndLine(), s1.getEndColumn());
                    this.insertText("", false);
                }
                this.save();
            }
        }
        catch (IOException ioe) {
            Platform.runLater(() -> DialogManager.showMessageWithTextFX((javafx.stage.Window)this.getWindow(), (String)"generic-file-save-error", (String)ioe.getLocalizedMessage()));
        }
    }

    private List<String> getInterfaceTexts(List<Selection> selections) {
        ArrayList<String> r = new ArrayList<String>(selections.size());
        for (Selection sel : selections) {
            String text = this.getText(new SourceLocation(sel.getLine(), sel.getColumn()), new SourceLocation(sel.getEndLine(), sel.getEndColumn()));
            int taIndex = text.indexOf(60);
            if (taIndex != -1) {
                text = text.substring(0, taIndex);
            }
            text = text.trim();
            r.add(text);
        }
        return r;
    }

    @OnThread(value=Tag.Swing)
    private static void initialiseContentAssist(final CodeCompletionDisplay codeCompletionDlg, int xpos, int ypos) {
        codeCompletionDlg.setLocation(xpos, ypos);
        codeCompletionDlg.setReady(false);
        codeCompletionDlg.setVisible(true);
        codeCompletionDlg.toFront();
        new Thread(){

            @Override
            @OnThread(value=Tag.Unique)
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(() -> {
                    codeCompletionDlg.requestFocus();
                    codeCompletionDlg.setReady(true);
                });
            }
        }.start();
    }

    @OnThread(value=Tag.FXPlatform)
    public javafx.stage.Window getWindow() {
        return this.fxTabbedEditor.getWindow();
    }

    class PopulateCompletionsWorker
    extends SwingWorker<AssistContent[], AssistContent> {
        CodeCompletionDisplay codeCompletionDlg;
        CodeSuggestions suggests;
        LocatableToken suggestToken;
        int xpos = 0;
        int ypos = 0;

        public PopulateCompletionsWorker(CodeSuggestions sug, LocatableToken sugT, int x, int y) {
            this.suggests = sug;
            this.suggestToken = sugT;
            this.xpos = x;
            this.ypos = y;
        }

        @Override
        protected AssistContent[] doInBackground() throws Exception {
            AssistContent[] completions = ParseUtils.getPossibleCompletions((CodeSuggestions)this.suggests, (JavadocResolver)MoeEditor.this.javadocResolver, (ParseUtils.AssistContentConsumer)new ParseUtils.AssistContentConsumer(){

                public void consume(AssistContent ac, boolean overridden) {
                    if (!overridden && ac.getKind() == AssistContent.CompletionKind.METHOD) {
                        PopulateCompletionsWorker.this.publish(new AssistContent[]{ac});
                    }
                }
            });
            return completions;
        }

        @Override
        protected void process(List<AssistContent> chunks) {
            if (chunks != null && !chunks.isEmpty()) {
                if (this.codeCompletionDlg == null) {
                    AssistContent[] initialElements = chunks.toArray(new AssistContent[chunks.size()]);
                    this.codeCompletionDlg = new CodeCompletionDisplay(MoeEditor.this, MoeEditor.this.watcher, this.suggests.getSuggestionType().toString(false), initialElements, this.suggestToken);
                    MoeEditor.initialiseContentAssist(this.codeCompletionDlg, this.xpos, this.ypos);
                } else {
                    this.codeCompletionDlg.addElements(chunks);
                }
            }
        }

        @Override
        protected void done() {
            try {
                AssistContent[] result = (AssistContent[])this.get();
                if (result != null && result.length == 0) {
                    MoeEditor.this.info.warning("No completions available.");
                }
            }
            catch (InterruptedException result) {
            }
            catch (ExecutionException ee) {
                Debug.reportError((Throwable)ee);
            }
        }
    }

    class ToolbarAction
    extends AbstractAction
    implements PropertyChangeListener {
        private final Action subAction;

        public ToolbarAction(Action subAction, String label) {
            super(label);
            this.subAction = subAction;
            subAction.addPropertyChangeListener(this);
            this.setEnabled(subAction.isEnabled());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.subAction.actionPerformed(e);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object newVal;
            if (evt.getPropertyName().equals("enabled") && (newVal = evt.getNewValue()) instanceof Boolean) {
                boolean state = (Boolean)newVal;
                this.setEnabled(state);
            }
        }
    }

    class MoeFocusTraversalPolicy
    extends FocusTraversalPolicy {
        MoeFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(MoeEditor.this.finder.getFindTField()) && MoeEditor.this.replacer.isVisible()) {
                return MoeEditor.this.replacer.getReplaceText();
            }
            return MoeEditor.this.currentTextPane;
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(MoeEditor.this.replacer.getReplaceText())) {
                return MoeEditor.this.finder.getFindTField();
            }
            return MoeEditor.this.currentTextPane;
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return MoeEditor.this.currentTextPane;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return MoeEditor.this.currentTextPane;
        }

        @Override
        public Component getInitialComponent(Window window) {
            return MoeEditor.this.currentTextPane;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return MoeEditor.this.currentTextPane;
        }
    }

    class TextInsertNotifier
    implements Runnable {
        private DocumentEvent evt;
        private JEditorPane editorPane;

        TextInsertNotifier() {
        }

        public void setEvent(DocumentEvent e, JEditorPane editorPane) {
            this.evt = e;
            this.editorPane = editorPane;
        }

        @Override
        @OnThread(value=Tag.Swing, ignoreParent=true)
        public void run() {
            MoeEditor.this.actions.textInsertAction(this.evt, this.editorPane);
        }
    }

    @OnThread(value=Tag.Any)
    class PrintHandler
    implements Runnable {
        PrinterJob printJob;
        PageFormat pageFormat;
        boolean lineNumbers;
        boolean syntaxHighlighting;

        public PrintHandler(PrinterJob pj, PageFormat format, boolean lineNumbers, boolean syntaxHighlighting) {
            this.printJob = pj;
            this.pageFormat = format;
            this.lineNumbers = lineNumbers;
            this.syntaxHighlighting = syntaxHighlighting;
        }

        @Override
        public void run() {
            this.print();
        }

        public void print() {
            if (MoeEditor.this.printer == null) {
                MoeEditor.this.printer = new MoePrinter();
            }
            SwingUtilities.invokeLater(() -> MoeEditor.this.info.message(Config.getString((String)"editor.info.printing")));
            if (MoeEditor.this.printer.printDocument(this.printJob, MoeEditor.this.sourceDocument, this.lineNumbers, this.syntaxHighlighting, MoeEditor.this.windowTitle, printFont, this.pageFormat)) {
                SwingUtilities.invokeLater(() -> MoeEditor.this.info.message(Config.getString((String)"editor.info.printed")));
            } else {
                SwingUtilities.invokeLater(() -> MoeEditor.this.info.message(Config.getString((String)"editor.info.cancelled")));
            }
        }
    }

    private static class ErrorDisplay
    extends JFrame {
        private final MoeErrorManager.ErrorDetails details;

        public ErrorDisplay(MoeErrorManager.ErrorDetails details) {
            this.details = details;
            this.setDefaultCloseOperation(2);
            this.setUndecorated(true);
            this.setFocusableWindowState(false);
            this.setAlwaysOnTop(true);
            JTextArea err = new JTextArea(ParserMessageHandler.getMessageForCode(details.message));
            err.setOpaque(false);
            err.setBackground(new Color(0, 0, 0, 0));
            err.setForeground(Color.WHITE);
            err.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            err.setFont(PrefMgr.getStandardFont());
            this.add(err);
            err.setMaximumSize(new Dimension(600, 300));
            err.setWrapStyleWord(true);
            this.getContentPane().setBackground(Color.BLACK);
            this.pack();
            this.setShape(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 5.0, 5.0));
            this.setOpacity(1.0f);
        }
    }
}

