/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.DecimalPrefix;
import com.jrockit.mc.common.unit.DecimalScaleFactor;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.LinearKindOfQuantity;
import com.jrockit.mc.common.unit.LinearQuantity;
import com.jrockit.mc.common.unit.LinearUnit;
import com.jrockit.mc.common.unit.ScaleFactor;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;

public class DecimalUnitSelector
implements IUnit.UnitSelector<LinearQuantity, LinearUnit> {
    protected final LinearKindOfQuantity kindOfQuantity;
    protected final LinearUnit exponentialBaseUnit;
    protected final ScaleFactor baseToAtomFactor;
    protected final Map<ScaleFactor, LinearUnit> unitCache = new HashMap<ScaleFactor, LinearUnit>();

    public DecimalUnitSelector(LinearKindOfQuantity kindOfQuantity) {
        this(kindOfQuantity, kindOfQuantity.atomUnit);
    }

    public DecimalUnitSelector(LinearKindOfQuantity kindOfQuantity, LinearUnit exponentialBaseUnit) {
        this.kindOfQuantity = kindOfQuantity;
        this.exponentialBaseUnit = exponentialBaseUnit;
        this.baseToAtomFactor = exponentialBaseUnit.valueFactorTo(kindOfQuantity.atomUnit);
        this.cachePlain(-3, "\u00d70.001");
        this.cachePlain(-2, "\u00d70.01");
        this.cachePlain(-1, "\u00d70.1");
        this.unitCache.put(DecimalScaleFactor.get(0), exponentialBaseUnit);
        this.cachePlain(1, "\u00d710");
        this.cachePlain(2, "\u00d7100");
        this.cachePlain(3, "\u00d71000");
    }

    public DecimalUnitSelector(LinearKindOfQuantity kindOfQuantity, Iterable<DecimalPrefix> prefixes) {
        this(kindOfQuantity, kindOfQuantity.atomUnit);
        for (DecimalPrefix prefix : prefixes) {
            this.unitCache.put(prefix.scaleFactor(), kindOfQuantity.getUnit(prefix));
        }
    }

    protected void cachePlain(int powerOf10, String unitId) {
        DecimalScaleFactor factor = DecimalScaleFactor.get(powerOf10);
        String unitName = String.valueOf(unitId.replace('.', DecimalFormatSymbols.getInstance().getDecimalSeparator())) + this.exponentialBaseUnit.getAppendableSuffix(false);
        ScaleFactor atomFactor = this.baseToAtomFactor.chain(factor);
        LinearUnit unit = new LinearUnit(this.kindOfQuantity, null, atomFactor, unitName, unitName, new String[0]);
        this.unitCache.put(factor, unit);
    }

    @Override
    public LinearUnit getPreferredUnit(LinearQuantity quantity, double minNumericalValue, double maxNumericalValue) {
        double absVal = Math.abs(quantity.doubleValueIn(this.exponentialBaseUnit));
        if (absVal > minNumericalValue && absVal < maxNumericalValue) {
            return this.exponentialBaseUnit;
        }
        DecimalScaleFactor factor = maxNumericalValue >= 1000.0 ? DecimalScaleFactor.getEngFloorFactor(absVal) : DecimalScaleFactor.getSciFloorFactor(absVal);
        LinearUnit unit = this.unitCache.get(factor);
        if (unit == null) {
            String unitName = factor.asExponentialStringBuilder(true).append(this.exponentialBaseUnit.getAppendableSuffix(false)).toString();
            ScaleFactor atomFactor = this.baseToAtomFactor.chain(factor);
            unit = new LinearUnit(this.kindOfQuantity, null, atomFactor, unitName, unitName, new String[0]);
            this.unitCache.put(factor, unit);
        }
        return unit;
    }
}

