/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.persistence;

import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.xml.EscapeToolkit;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;

final class PrettyPrinter {
    private static final String INDENT = "   ";
    private final Writer m_writer;

    PrettyPrinter(Writer writer) {
        this.m_writer = writer;
    }

    void printDeep(Setting setting) throws IOException {
        this.prettyPrint(setting, "", Integer.MAX_VALUE);
    }

    void printShallow(Setting setting) throws IOException {
        this.prettyPrint(setting, "", 3);
    }

    void prettyPrint(Setting setting, String leftPadding, int depth) throws IOException {
        if (!setting.getChildren().isEmpty() || !setting.getProperties().isEmpty()) {
            this.writeWithPad(leftPadding, this.createStartTag(setting.getName()));
            if (depth > 0) {
                this.printProperties(setting, String.valueOf(leftPadding) + INDENT);
                this.printSetting(setting, leftPadding, depth);
            } else {
                this.writeWithPad(leftPadding, "...");
            }
            this.writeWithPad(leftPadding, this.createEndTag(setting.getName()));
        }
    }

    private void printProperties(Setting test, String leftPadding) throws IOException {
        Map<String, String> props = test.getProperties();
        if (!props.isEmpty()) {
            Object[] os = props.keySet().toArray();
            Arrays.sort(os);
            Object[] objectArray = os;
            int n = os.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                String tag = (String)key;
                String value = props.get(tag);
                if (value != null && value.trim().length() != 0 && !tag.equals("dataSelection")) {
                    this.writeWithPad(leftPadding, String.valueOf(this.createStartTag(tag)) + EscapeToolkit.escape(value) + this.createEndTag(tag));
                }
                ++n2;
            }
        }
    }

    private void printSetting(Setting setting, String leftPadding, int depth) throws IOException {
        for (Setting child : setting.getChildren()) {
            this.prettyPrint(child, String.valueOf(leftPadding) + INDENT, depth - 1);
        }
    }

    private String createStartTag(String tagName) {
        return "<" + tagName + ">";
    }

    private String createEndTag(String tagName) {
        return "</" + tagName + ">";
    }

    private void writeWithPad(String leftPadding, String content) throws IOException {
        this.m_writer.write(leftPadding);
        this.m_writer.write(content);
        this.m_writer.write("\n");
    }
}

