/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.light;

import com.pi4j.component.ComponentListener;
import com.pi4j.component.ObserveableComponentBase;
import com.pi4j.component.light.DimmableLight;
import com.pi4j.component.light.DimmableLightListener;
import com.pi4j.component.light.Light;
import com.pi4j.component.light.LightLevelChangeEvent;
import com.pi4j.component.light.LightListener;
import com.pi4j.component.light.LightStateChangeEvent;

public abstract class DimmableLightBase
extends ObserveableComponentBase
implements Light,
DimmableLight {
    @Override
    public abstract int getMinLevel();

    @Override
    public abstract int getMaxLevel();

    @Override
    public abstract int getLevel();

    @Override
    public abstract void setLevel(int var1);

    @Override
    public float getLevelPercentage() {
        return this.getLevelPercentage(this.getLevel());
    }

    @Override
    public float getLevelPercentage(int level) {
        int min = Math.min(this.getMinLevel(), this.getMaxLevel());
        int max = Math.max(this.getMinLevel(), this.getMaxLevel());
        int range = max - min;
        float percentage = level * 100 / range;
        return percentage;
    }

    @Override
    public void on() {
        this.setLevel(this.getMaxLevel());
    }

    @Override
    public void off() {
        this.setLevel(this.getMinLevel());
    }

    @Override
    public boolean isOn() {
        return this.getLevel() > this.getMinLevel();
    }

    @Override
    public boolean isOff() {
        return this.getLevel() <= this.getMinLevel();
    }

    @Override
    public void addListener(LightListener ... listener) {
        super.addListener(listener);
    }

    @Override
    public synchronized void removeListener(LightListener ... listener) {
        super.removeListener(listener);
    }

    @Override
    public void addListener(DimmableLightListener ... listener) {
        super.addListener(listener);
    }

    @Override
    public synchronized void removeListener(DimmableLightListener ... listener) {
        super.removeListener(listener);
    }

    protected synchronized void notifyListeners(LightStateChangeEvent event) {
        for (ComponentListener listener : this.listeners) {
            ((LightListener)listener).onStateChange(event);
        }
    }

    protected synchronized void notifyListeners(LightLevelChangeEvent event) {
        for (ComponentListener listener : this.listeners) {
            ((DimmableLightListener)listener).onLevelChange(event);
        }
    }
}

