/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.provider;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.util.EventValueLookup;
import java.util.Iterator;
import java.util.NoSuchElementException;

class SimpleFieldValueIterator
implements Iterator<Object> {
    private final Iterator<IEvent> m_iterator;
    private final EventValueLookup m_lookup;
    private IEvent m_event;

    SimpleFieldValueIterator(EventValueLookup evl, IView view) {
        IView newView = view.copy();
        newView.setEventTypes(evl.getEventTypes());
        this.m_iterator = newView.iterator();
        this.m_lookup = evl;
        this.skipForward();
    }

    private void skipForward() {
        this.m_event = this.m_iterator.hasNext() ? this.m_iterator.next() : null;
    }

    @Override
    public boolean hasNext() {
        return this.m_event != null;
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        IField field = this.m_lookup.getField(this.m_event.getEventType());
        Object o = field.getValue(this.m_event);
        this.skipForward();
        return o;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("");
    }
}

