/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.config.Platform;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.ProxyConfigException;
import com.sun.deploy.net.proxy.ProxyHandler;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.trace.Trace;
import java.net.URL;
import java.util.StringTokenizer;

public final class MacOSXSystemProxyHandler
implements ProxyHandler {
    private String mAutoProxyURL;

    public final boolean isSupported(int n) {
        return n == 4;
    }

    public final boolean isProxyCacheSupported() {
        return false;
    }

    public final void init(BrowserProxyInfo browserProxyInfo) throws ProxyConfigException {
        Trace.msgNetPrintln("net.proxy.loading.browser");
        if (!this.isSupported(browserProxyInfo.getType())) {
            throw new ProxyConfigException("Unable to support proxy type: " + browserProxyInfo.getType());
        }
        this.mAutoProxyURL = browserProxyInfo.getAutoConfigURL();
        Trace.msgNetPrintln("net.proxy.loading.done");
    }

    public final ProxyInfo[] getProxyInfo(URL uRL) {
        String string = this.getProxyStringForURL(uRL.toString(), this.mAutoProxyURL);
        return this.extractProxySetting(string);
    }

    private ProxyInfo[] extractProxySetting(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
            ProxyInfo[] proxyInfoArray = new ProxyInfo[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n2 = string2.indexOf("PROXY");
                if (n2 != -1) {
                    proxyInfoArray[n++] = new ProxyInfo(string2.substring(n2 + 6));
                    continue;
                }
                n2 = string2.indexOf("SOCKS");
                if (n2 != -1) {
                    proxyInfoArray[n++] = new ProxyInfo(null, string2.substring(n2 + 6));
                    continue;
                }
                proxyInfoArray[n++] = new ProxyInfo(null, -1);
            }
            return proxyInfoArray;
        }
        return new ProxyInfo[]{new ProxyInfo(null)};
    }

    private native String getProxyStringForURL(String var1, String var2);

    static {
        Platform.get().loadDeployNativeLib();
    }
}

