/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.attach;

import com.sun.tools.visualvm.attach.HeapHistogramImpl;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;

class JRockitHeapHistogramImpl
extends HeapHistogramImpl {
    JRockitHeapHistogramImpl(InputStream in) {
        HashMap<String, HeapHistogramImpl.ClassInfoImpl> classesMap = new HashMap<String, HeapHistogramImpl.ClassInfoImpl>(1024);
        this.time = new Date();
        Scanner sc = new Scanner(in, "UTF-8");
        sc.useRadix(10);
        sc.nextLine();
        sc.skip("-+");
        sc.nextLine();
        while (sc.hasNext("[0-9]+\\.[0-9]%")) {
            JRockitClassInfoImpl newClInfo = new JRockitClassInfoImpl(sc);
            this.storeClassInfo(newClInfo, classesMap);
            this.totalHeapBytes += newClInfo.getBytes();
            this.totalHeapInstances += newClInfo.getInstancesCount();
        }
        this.totalInstances = this.totalHeapInstances;
        this.totalBytes = this.totalHeapBytes;
        this.classes = new HashSet(classesMap.values());
        this.permGenClasses = Collections.EMPTY_SET;
    }

    static class JRockitClassInfoImpl
    extends HeapHistogramImpl.ClassInfoImpl {
        JRockitClassInfoImpl(Scanner sc) {
            sc.next();
            this.bytes = this.computeBytes(sc.next());
            this.instances = sc.nextLong();
            sc.next();
            String jvmName = sc.next();
            this.name = this.convertJVMName(jvmName.replace('/', '.'));
        }

        private long computeBytes(String size) {
            String multi = size.substring(size.length() - 1);
            long bytes = Long.parseLong(size.substring(0, size.length() - 1));
            if ("K".equalsIgnoreCase(multi)) {
                bytes *= 1024L;
            } else if ("M".equalsIgnoreCase(multi)) {
                bytes *= 0x100000L;
            } else if ("G".equalsIgnoreCase(multi)) {
                bytes *= 0x40000000L;
            }
            return bytes;
        }
    }
}

